/*
 * Decompiled with CFR 0.152.
 */
package com.staros.section;

import com.google.common.base.Preconditions;
import com.google.protobuf.InvalidProtocolBufferException;
import com.staros.proto.SectionHeader;
import com.staros.proto.SectionType;
import com.staros.section.Section;
import com.staros.section.SectionConsumer;
import com.staros.stream.ChunkedInputStream;
import com.staros.stream.NullInputStream;
import com.staros.util.LockCloseable;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;

public class SectionReader
implements Closeable {
    private final InputStream parent;
    private final ReentrantLock lock;
    private Section currentSection;

    public SectionReader(InputStream in) {
        this.parent = in;
        this.lock = new ReentrantLock();
        this.currentSection = null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Section next() throws IOException {
        try (LockCloseable ignored = new LockCloseable(this.lock);){
            SectionHeader header;
            if (this.currentSection != null) {
                if (this.currentSection.isDone()) {
                    throw new EOFException("Reaches the end of sections");
                }
                this.currentSection.skip();
            }
            if ((header = SectionHeader.parseDelimitedFrom(this.parent)) == null) {
                throw new EOFException();
            }
            InputStream stream = header.getSectionType() == SectionType.SECTION_DONE ? new NullInputStream() : new ChunkedInputStream(this.parent);
            Section section = this.currentSection = new Section(header, stream);
            return section;
        }
        catch (InvalidProtocolBufferException exception) {
            throw new EOFException();
        }
    }

    public void forEach(SectionConsumer<? super Section> action) throws IOException, IllegalStateException {
        Objects.requireNonNull(action);
        if (this.currentSection != null) {
            throw new IllegalStateException("SectionReader has already been consumed!");
        }
        this.next();
        Preconditions.checkState((this.currentSection != null ? 1 : 0) != 0);
        while (!this.currentSection.isDone()) {
            action.accept(this.currentSection);
            this.next();
        }
    }

    @Override
    public void close() throws IOException {
        try (LockCloseable ignored = new LockCloseable(this.lock);){
            if (this.currentSection == null) {
                this.next();
            }
            while (!this.currentSection.isDone()) {
                this.next();
            }
        }
    }
}

