/*
 * Decompiled with CFR 0.152.
 */
package com.staros.journal;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.staros.exception.ExceptionCode;
import com.staros.exception.StarException;
import com.staros.proto.JournalEntry;
import com.staros.proto.JournalHeader;
import com.staros.proto.OperationType;
import com.staros.util.AbstractParser;
import com.staros.util.Text;
import com.staros.util.Writable;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class Journal
implements Writable {
    private final JournalEntry entry;

    public Journal(JournalEntry entry) {
        this.entry = entry;
    }

    public JournalEntry getEntry() {
        return this.entry;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        Text.writeBytes(out, this.entry.toByteArray());
    }

    public long size() {
        return this.entry.getSerializedSize();
    }

    public static Journal read(DataInput in) throws IOException {
        return new Journal(JournalEntry.parseFrom(Text.readBytes(in)));
    }

    static abstract class AbstractListWritableJournalOp<T extends Writable>
    extends AbstractListJournalOp<T> {
        AbstractListWritableJournalOp() {
        }

        @Override
        public void writeElement(DataOutput out, T data) throws IOException {
            data.write(out);
        }
    }

    static abstract class AbstractListJournalOp<T>
    extends AbstractJournalOp<List<T>> {
        AbstractListJournalOp() {
        }

        @Override
        public void write(DataOutput out, List<T> data) throws IOException {
            out.writeInt(data.size());
            for (T t : data) {
                this.writeElement(out, t);
            }
        }

        public abstract void writeElement(DataOutput var1, T var2) throws IOException;

        public abstract T parseElement(DataInput var1) throws IOException;

        @Override
        public List<T> parseFrom(DataInput in) throws IOException {
            int size = in.readInt();
            ArrayList<T> result = new ArrayList<T>(size);
            for (int i = 0; i < size; ++i) {
                result.add(this.parseElement(in));
            }
            return result;
        }
    }

    static abstract class WritableJournalOp<T extends Writable>
    extends AbstractJournalOp<T> {
        WritableJournalOp() {
        }

        @Override
        public void write(DataOutput out, T data) throws IOException {
            data.write(out);
        }
    }

    public static abstract class ProtoJournalOp<T extends Message>
    extends AbstractJournalOp<T> {
        @Override
        public void write(DataOutput out, T data) throws IOException {
            Text.writeBytes(out, data.toByteArray());
        }

        public abstract T read(byte[] var1) throws InvalidProtocolBufferException;

        @Override
        public T parseFrom(DataInput in) throws IOException {
            return this.read(Text.readBytes(in));
        }
    }

    static abstract class AbstractJournalOp<T>
    extends AbstractParser<T> {
        AbstractJournalOp() {
        }

        public Journal toJournal(OperationType type, String serviceId, T data) throws StarException {
            assert (type != OperationType.OP_INVALID);
            ByteArrayOutputStream out = new ByteArrayOutputStream(128);
            try {
                this.write(new DataOutputStream(out), data);
            }
            catch (IOException e) {
                throw new StarException(ExceptionCode.IO, e.getMessage());
            }
            JournalHeader header = JournalHeader.newBuilder().setServiceId(serviceId).setOperationType(type).build();
            JournalEntry entry = JournalEntry.newBuilder().setHeader(header).setBody(ByteString.copyFrom((byte[])out.toByteArray())).build();
            return new Journal(entry);
        }

        public abstract void write(DataOutput var1, T var2) throws IOException;

        public T parseFromJournal(OperationType type, Journal journal) throws StarException {
            try {
                assert (journal.entry.getHeader().getOperationType() == type);
                return (T)this.parseFrom(journal.entry.getBody().toByteArray());
            }
            catch (IOException e) {
                throw new StarException(ExceptionCode.IO, e.getMessage());
            }
        }
    }
}

