/*
 * Decompiled with CFR 0.152.
 */
package com.staros.exception;

import com.staros.exception.ExceptionCode;
import com.staros.exception.StarException;
import com.staros.proto.LeaderInfo;
import com.staros.proto.StarStatus;
import com.staros.proto.StatusCode;

public class NotLeaderStarException
extends StarException {
    private static final ExceptionCode code = ExceptionCode.NOT_LEADER;
    private final LeaderInfo leader;

    public NotLeaderStarException(String msg) {
        super(code, msg);
        this.leader = null;
    }

    public NotLeaderStarException(LeaderInfo leader, String msg) {
        super(code, msg);
        this.leader = leader;
    }

    public NotLeaderStarException(String messagePattern, Object ... params) {
        super(code, messagePattern, params);
        this.leader = null;
    }

    public LeaderInfo getLeaderInfo() {
        return this.leader;
    }

    @Override
    public StarStatus toStatus() {
        if (this.leader == null) {
            return super.toStatus();
        }
        return StarStatus.newBuilder().setStatusCode(StatusCode.NOT_LEADER).setExtraInfo(this.leader.toByteString()).setErrorMsg(this.getMessage()).build();
    }
}

