/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker.client.messages;

import com.spotify.docker.client.messages.AutoValue_Info;
import com.spotify.docker.client.messages.AutoValue_Info_IndexConfig;
import com.spotify.docker.client.messages.AutoValue_Info_Plugins;
import com.spotify.docker.client.messages.AutoValue_Info_RegistryConfig;
import com.spotify.docker.client.messages.swarm.SwarmInfo;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import com.spotify.docker.client.shaded.com.google.common.collect.ImmutableList;
import com.spotify.docker.client.shaded.com.google.common.collect.ImmutableMap;
import com.spotify.docker.client.shaded.javax.annotation.Nullable;
import java.util.Date;
import java.util.List;
import java.util.Map;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public abstract class Info {
    @Nullable
    @JsonProperty(value="Architecture")
    public abstract String architecture();

    @Nullable
    @JsonProperty(value="ClusterStore")
    public abstract String clusterStore();

    @Nullable
    @JsonProperty(value="CgroupDriver")
    public abstract String cgroupDriver();

    @JsonProperty(value="Containers")
    public abstract Integer containers();

    @Nullable
    @JsonProperty(value="ContainersRunning")
    public abstract Integer containersRunning();

    @Nullable
    @JsonProperty(value="ContainersStopped")
    public abstract Integer containersStopped();

    @Nullable
    @JsonProperty(value="ContainersPaused")
    public abstract Integer containersPaused();

    @Nullable
    @JsonProperty(value="CpuCfsPeriod")
    public abstract Boolean cpuCfsPeriod();

    @Nullable
    @JsonProperty(value="CpuCfsQuota")
    public abstract Boolean cpuCfsQuota();

    @JsonProperty(value="Debug")
    public abstract Boolean debug();

    @JsonProperty(value="DockerRootDir")
    public abstract String dockerRootDir();

    @JsonProperty(value="Driver")
    public abstract String storageDriver();

    @JsonProperty(value="DriverStatus")
    public abstract ImmutableList<ImmutableList<String>> driverStatus();

    @Deprecated
    @Nullable
    @JsonProperty(value="ExecutionDriver")
    public abstract String executionDriver();

    @Nullable
    @JsonProperty(value="ExperimentalBuild")
    public abstract Boolean experimentalBuild();

    @Nullable
    @JsonProperty(value="HttpProxy")
    public abstract String httpProxy();

    @Nullable
    @JsonProperty(value="HttpsProxy")
    public abstract String httpsProxy();

    @JsonProperty(value="ID")
    public abstract String id();

    @JsonProperty(value="IPv4Forwarding")
    public abstract Boolean ipv4Forwarding();

    @JsonProperty(value="Images")
    public abstract Integer images();

    @JsonProperty(value="IndexServerAddress")
    public abstract String indexServerAddress();

    @Nullable
    @JsonProperty(value="InitPath")
    public abstract String initPath();

    @Nullable
    @JsonProperty(value="InitSha1")
    public abstract String initSha1();

    @Nullable
    @JsonProperty(value="KernelMemory")
    public abstract Boolean kernelMemory();

    @JsonProperty(value="KernelVersion")
    public abstract String kernelVersion();

    @JsonProperty(value="Labels")
    public abstract ImmutableList<String> labels();

    @JsonProperty(value="MemTotal")
    public abstract Long memTotal();

    @JsonProperty(value="MemoryLimit")
    public abstract Boolean memoryLimit();

    @JsonProperty(value="NCPU")
    public abstract Integer cpus();

    @JsonProperty(value="NEventsListener")
    public abstract Integer eventsListener();

    @JsonProperty(value="NFd")
    public abstract Integer fileDescriptors();

    @JsonProperty(value="NGoroutines")
    public abstract Integer goroutines();

    @JsonProperty(value="Name")
    public abstract String name();

    @Nullable
    @JsonProperty(value="NoProxy")
    public abstract String noProxy();

    @Nullable
    @JsonProperty(value="OomKillDisable")
    public abstract Boolean oomKillDisable();

    @JsonProperty(value="OperatingSystem")
    public abstract String operatingSystem();

    @Nullable
    @JsonProperty(value="OSType")
    public abstract String osType();

    @Nullable
    @JsonProperty(value="Plugins")
    public abstract Plugins plugins();

    @JsonProperty(value="RegistryConfig")
    public abstract RegistryConfig registryConfig();

    @Nullable
    @JsonProperty(value="ServerVersion")
    public abstract String serverVersion();

    @JsonProperty(value="SwapLimit")
    public abstract Boolean swapLimit();

    @Nullable
    @JsonProperty(value="Swarm")
    public abstract SwarmInfo swarm();

    @Nullable
    @JsonProperty(value="SystemStatus")
    public abstract ImmutableList<ImmutableList<String>> systemStatus();

    @JsonProperty(value="SystemTime")
    public abstract Date systemTime();

    @JsonCreator
    static Info create(@JsonProperty(value="Architecture") String architecture, @JsonProperty(value="ClusterStore") String clusterStore, @JsonProperty(value="CgroupDriver") String cgroupDriver, @JsonProperty(value="Containers") Integer containers, @JsonProperty(value="ContainersRunning") Integer containersRunning, @JsonProperty(value="ContainersStopped") Integer containersStopped, @JsonProperty(value="ContainersPaused") Integer containersPaused, @JsonProperty(value="CpuCfsPeriod") Boolean cpuCfsPeriod, @JsonProperty(value="CpuCfsQuota") Boolean cpuCfsQuota, @JsonProperty(value="Debug") Boolean debug, @JsonProperty(value="DockerRootDir") String dockerRootDir, @JsonProperty(value="Driver") String storageDriver, @JsonProperty(value="DriverStatus") List<List<String>> driverStatus, @JsonProperty(value="ExecutionDriver") String executionDriver, @JsonProperty(value="ExperimentalBuild") Boolean experimentalBuild, @JsonProperty(value="HttpProxy") String httpProxy, @JsonProperty(value="HttpsProxy") String httpsProxy, @JsonProperty(value="ID") String id, @JsonProperty(value="IPv4Forwarding") Boolean ipv4Forwarding, @JsonProperty(value="Images") Integer images, @JsonProperty(value="IndexServerAddress") String indexServerAddress, @JsonProperty(value="InitPath") String initPath, @JsonProperty(value="InitSha1") String initSha1, @JsonProperty(value="KernelMemory") Boolean kernelMemory, @JsonProperty(value="KernelVersion") String kernelVersion, @JsonProperty(value="Labels") List<String> labels, @JsonProperty(value="MemTotal") Long memTotal, @JsonProperty(value="MemoryLimit") Boolean memoryLimit, @JsonProperty(value="NCPU") Integer cpus, @JsonProperty(value="NEventsListener") Integer eventsListener, @JsonProperty(value="NFd") Integer fileDescriptors, @JsonProperty(value="NGoroutines") Integer goroutines, @JsonProperty(value="Name") String name, @JsonProperty(value="NoProxy") String noProxy, @JsonProperty(value="OomKillDisable") Boolean oomKillDisable, @JsonProperty(value="OperatingSystem") String operatingSystem, @JsonProperty(value="OSType") String osType, @JsonProperty(value="Plugins") Plugins plugins, @JsonProperty(value="RegistryConfig") RegistryConfig registryConfig, @JsonProperty(value="ServerVersion") String serverVersion, @JsonProperty(value="SwapLimit") Boolean swapLimit, @JsonProperty(value="Swarm") SwarmInfo swarm, @JsonProperty(value="SystemStatus") List<List<String>> systemStatus, @JsonProperty(value="SystemTime") Date systemTime) {
        ImmutableList.Builder driverStatusB = ImmutableList.builder();
        if (driverStatus != null) {
            for (List<String> ds : driverStatus) {
                driverStatusB.add(ImmutableList.copyOf(ds));
            }
        }
        ImmutableList<String> labelsT = labels == null ? ImmutableList.of() : ImmutableList.copyOf(labels);
        ImmutableList.Builder systemStatusB = ImmutableList.builder();
        if (systemStatus != null) {
            for (List<String> ss : systemStatus) {
                systemStatusB.add(ImmutableList.copyOf(ss));
            }
        }
        return new AutoValue_Info(architecture, clusterStore, cgroupDriver, containers, containersRunning, containersStopped, containersPaused, cpuCfsPeriod, cpuCfsQuota, debug, dockerRootDir, storageDriver, (ImmutableList<ImmutableList<String>>)driverStatusB.build(), executionDriver, experimentalBuild, httpProxy, httpsProxy, id, ipv4Forwarding, images, indexServerAddress, initPath, initSha1, kernelMemory, kernelVersion, labelsT, memTotal, memoryLimit, cpus, eventsListener, fileDescriptors, goroutines, name, noProxy, oomKillDisable, operatingSystem, osType, plugins, registryConfig, serverVersion, swapLimit, swarm, (ImmutableList<ImmutableList<String>>)systemStatusB.build(), systemTime);
    }

    public static abstract class IndexConfig {
        @JsonProperty(value="Name")
        public abstract String name();

        @JsonProperty(value="Mirrors")
        public abstract ImmutableList<String> mirrors();

        @JsonProperty(value="Secure")
        public abstract Boolean secure();

        @JsonProperty(value="Official")
        public abstract Boolean official();

        @JsonCreator
        static IndexConfig create(@JsonProperty(value="Name") String name, @JsonProperty(value="Mirrors") List<String> mirrors, @JsonProperty(value="Secure") Boolean secure, @JsonProperty(value="Official") Boolean official) {
            ImmutableList<String> mirrorsT = mirrors == null ? ImmutableList.of() : ImmutableList.copyOf(mirrors);
            return new AutoValue_Info_IndexConfig(name, mirrorsT, secure, official);
        }
    }

    public static abstract class RegistryConfig {
        @JsonProperty(value="IndexConfigs")
        public abstract ImmutableMap<String, IndexConfig> indexConfigs();

        @JsonProperty(value="InsecureRegistryCIDRs")
        public abstract ImmutableList<String> insecureRegistryCidrs();

        @JsonCreator
        static RegistryConfig create(@JsonProperty(value="IndexConfigs") Map<String, IndexConfig> indexConfigs, @JsonProperty(value="InsecureRegistryCIDRs") List<String> insecureRegistryCidrs) {
            ImmutableMap<String, IndexConfig> indexConfigsT = indexConfigs == null ? ImmutableMap.of() : ImmutableMap.copyOf(indexConfigs);
            ImmutableList<String> insecureRegistryCidrsT = insecureRegistryCidrs == null ? ImmutableList.of() : ImmutableList.copyOf(insecureRegistryCidrs);
            return new AutoValue_Info_RegistryConfig(indexConfigsT, insecureRegistryCidrsT);
        }
    }

    public static abstract class Plugins {
        @JsonProperty(value="Volumes")
        public abstract ImmutableList<String> volumes();

        @JsonProperty(value="Networks")
        public abstract ImmutableList<String> networks();

        @JsonCreator
        static Plugins create(@JsonProperty(value="Volumes") List<String> volumes, @JsonProperty(value="Networks") List<String> networks) {
            ImmutableList<String> volumesT = volumes == null ? ImmutableList.of() : ImmutableList.copyOf(volumes);
            ImmutableList<String> networksT = networks == null ? ImmutableList.of() : ImmutableList.copyOf(networks);
            return new AutoValue_Info_Plugins(volumesT, networksT);
        }
    }
}

