/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.indentation;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.utils.CommonUtils;
import org.apache.commons.lang3.ArrayUtils;

public class CommentsIndentationCheck
extends Check {
    public static final String MSG_KEY_SINGLE = "comments.indentation.single";
    public static final String MSG_KEY_BLOCK = "comments.indentation.block";

    @Override
    public int[] getDefaultTokens() {
        return new int[]{144, 145};
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{144, 145};
    }

    @Override
    public int[] getRequiredTokens() {
        return ArrayUtils.EMPTY_INT_ARRAY;
    }

    @Override
    public boolean isCommentNodesRequired() {
        return true;
    }

    @Override
    public void visitToken(DetailAST commentAst) {
        switch (commentAst.getType()) {
            case 144: {
                this.visitSingleLineComment(commentAst);
                break;
            }
            case 145: {
                this.visitBlockComment(commentAst);
                break;
            }
            default: {
                String exceptionMsg = "Unexpected token type: " + commentAst.getText();
                throw new IllegalArgumentException(exceptionMsg);
            }
        }
    }

    private void visitSingleLineComment(DetailAST singleLineComment) {
        DetailAST nextStatement = singleLineComment.getNextSibling();
        DetailAST prevStatement = CommentsIndentationCheck.getPrevStatementFromSwitchBlock(singleLineComment);
        if (nextStatement != null && nextStatement.getType() != 73 && !this.isTrailingSingleLineComment(singleLineComment) && !CommentsIndentationCheck.areSameLevelIndented(singleLineComment, prevStatement, nextStatement)) {
            this.log(singleLineComment.getLineNo(), MSG_KEY_SINGLE, nextStatement.getLineNo(), singleLineComment.getColumnNo(), nextStatement.getColumnNo());
        }
    }

    private static DetailAST getPrevStatementFromSwitchBlock(DetailAST comment) {
        DetailAST prevStmt = null;
        DetailAST parentStatement = comment.getParent();
        if (parentStatement != null) {
            prevStmt = parentStatement.getType() == 33 ? CommentsIndentationCheck.getPrevStatementWhenCommentIsUnderCase(parentStatement) : CommentsIndentationCheck.getPrevCaseToken(parentStatement);
        }
        return prevStmt;
    }

    private static DetailAST getPrevStatementWhenCommentIsUnderCase(DetailAST parentStatement) {
        DetailAST prevStmt = null;
        DetailAST prevBlock = parentStatement.getPreviousSibling();
        if (prevBlock.getLastChild() != null) {
            DetailAST blockBody = prevBlock.getLastChild().getLastChild();
            if (blockBody.getPreviousSibling() != null) {
                blockBody = blockBody.getPreviousSibling();
            }
            prevStmt = blockBody.getType() == 28 ? blockBody.getFirstChild().getFirstChild() : blockBody;
        }
        return prevStmt;
    }

    private static DetailAST getPrevCaseToken(DetailAST parentStatement) {
        DetailAST parentBlock = parentStatement.getParent();
        DetailAST prevCaseToken = parentBlock != null && parentBlock.getParent() != null && parentBlock.getParent().getPreviousSibling() != null && parentBlock.getParent().getPreviousSibling().getType() == 93 ? parentBlock.getParent().getPreviousSibling() : null;
        return prevCaseToken;
    }

    private static boolean areSameLevelIndented(DetailAST singleLineComment, DetailAST prevStmt, DetailAST nextStmt) {
        boolean result = prevStmt == null ? singleLineComment.getColumnNo() == nextStmt.getColumnNo() : singleLineComment.getColumnNo() == nextStmt.getColumnNo() || singleLineComment.getColumnNo() == prevStmt.getColumnNo();
        return result;
    }

    private boolean isTrailingSingleLineComment(DetailAST singleLineComment) {
        String targetSourceLine = this.getLine(singleLineComment.getLineNo() - 1);
        int commentColumnNo = singleLineComment.getColumnNo();
        return !CommonUtils.hasWhitespaceBefore(commentColumnNo, targetSourceLine);
    }

    private void visitBlockComment(DetailAST blockComment) {
        DetailAST nextStatement = blockComment.getNextSibling();
        DetailAST prevStatement = CommentsIndentationCheck.getPrevStatementFromSwitchBlock(blockComment);
        if (nextStatement != null && nextStatement.getType() != 73 && !this.isTrailingBlockComment(blockComment) && !CommentsIndentationCheck.areSameLevelIndented(blockComment, prevStatement, nextStatement)) {
            this.log(blockComment.getLineNo(), MSG_KEY_BLOCK, nextStatement.getLineNo(), blockComment.getColumnNo(), nextStatement.getColumnNo());
        }
    }

    private boolean isTrailingBlockComment(DetailAST blockComment) {
        String commentLine = this.getLine(blockComment.getLineNo() - 1);
        int commentColumnNo = blockComment.getColumnNo();
        return !CommonUtils.hasWhitespaceBefore(commentColumnNo, commentLine) || blockComment.getNextSibling().getLineNo() == blockComment.getLineNo();
    }
}

