/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.api;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public final class FullIdent {
    private final List<String> elements = new ArrayList<String>();
    private int lineNo;
    private int columnNo;

    private FullIdent() {
    }

    public String getText() {
        return StringUtils.join(this.elements, (String)"");
    }

    public int getLineNo() {
        return this.lineNo;
    }

    public int getColumnNo() {
        return this.columnNo;
    }

    private void append(String text) {
        this.elements.add(text);
    }

    private void append(DetailAST ast) {
        this.elements.add(ast.getText());
        if (this.lineNo == 0) {
            this.lineNo = ast.getLineNo();
        } else if (ast.getLineNo() > 0) {
            this.lineNo = Math.min(this.lineNo, ast.getLineNo());
        }
        if (this.columnNo == 0) {
            this.columnNo = ast.getColumnNo();
        } else if (ast.getColumnNo() > 0) {
            this.columnNo = Math.min(this.columnNo, ast.getColumnNo());
        }
    }

    public static FullIdent createFullIdent(DetailAST ast) {
        FullIdent fi = new FullIdent();
        FullIdent.extractFullIdent(fi, ast);
        return fi;
    }

    public static FullIdent createFullIdentBelow(DetailAST ast) {
        return FullIdent.createFullIdent(ast.getFirstChild());
    }

    private static void extractFullIdent(FullIdent full, DetailAST ast) {
        if (ast == null) {
            return;
        }
        if (ast.getType() == 59) {
            FullIdent.extractFullIdent(full, ast.getFirstChild());
            full.append(".");
            FullIdent.extractFullIdent(full, ast.getFirstChild().getNextSibling());
        } else {
            full.append(ast);
        }
    }

    public String toString() {
        return this.getText() + "[" + this.lineNo + "x" + this.columnNo + "]";
    }
}

