/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.whitespace;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;

public class EmptyLineSeparatorCheck
extends Check {
    private boolean mAllowNoEmptyLineBetweenFields;

    public final void setAllowNoEmptyLineBetweenFields(boolean aAllow) {
        this.mAllowNoEmptyLineBetweenFields = aAllow;
    }

    public int[] getDefaultTokens() {
        return new int[]{16, 31, 14, 15, 156, 12, 11, 9, 8, 10};
    }

    public void visitToken(DetailAST aAST) {
        DetailAST nextToken = aAST.getNextSibling();
        if (nextToken != null && nextToken.getType() != 74) {
            int astType = aAST.getType();
            switch (astType) {
                case 10: {
                    if (!this.isTypeField(aAST) || this.hasEmptyLineAfter(aAST)) break;
                    if (this.mAllowNoEmptyLineBetweenFields && nextToken.getType() != 10) {
                        this.log(nextToken.getLineNo(), "empty.line.separator", nextToken.getText());
                        break;
                    }
                    if (this.mAllowNoEmptyLineBetweenFields) break;
                    this.log(nextToken.getLineNo(), "empty.line.separator", nextToken.getText());
                    break;
                }
                case 31: {
                    if ((astType == nextToken.getType() || this.hasEmptyLineAfter(aAST)) && (aAST.getLineNo() <= 1 || this.hasEmptyLineBefore(aAST) || aAST.getPreviousSibling() != null)) break;
                    this.log(nextToken.getLineNo(), "empty.line.separator", nextToken.getText());
                    break;
                }
                case 16: {
                    if (aAST.getLineNo() > 1 && !this.hasEmptyLineBefore(aAST)) {
                        this.log(aAST.getLineNo(), "empty.line.separator", aAST.getText());
                    }
                }
                default: {
                    if (this.hasEmptyLineAfter(aAST)) break;
                    this.log(nextToken.getLineNo(), "empty.line.separator", nextToken.getText());
                }
            }
        }
    }

    private boolean hasEmptyLineAfter(DetailAST aToken) {
        DetailAST lastToken = aToken.getLastChild().getLastChild();
        if (null == lastToken) {
            lastToken = aToken.getLastChild();
        }
        return aToken.getNextSibling().getLineNo() - lastToken.getLineNo() > 1;
    }

    private boolean hasEmptyLineBefore(DetailAST aToken) {
        int lineNo = aToken.getLineNo();
        String lineBefore = this.getLines()[lineNo - 2];
        return lineBefore.trim().isEmpty();
    }

    private boolean isTypeField(DetailAST aVariableDef) {
        int parentType = aVariableDef.getParent().getParent().getType();
        return parentType == 14;
    }
}

