/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.modifier;

import com.google.common.collect.Lists;
import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModifierOrderCheck
extends Check {
    private static final String[] JLS_ORDER = new String[]{"public", "protected", "private", "abstract", "static", "final", "transient", "volatile", "synchronized", "native", "strictfp", "default"};

    @Override
    public int[] getDefaultTokens() {
        return new int[]{5};
    }

    @Override
    public void visitToken(DetailAST aAST) {
        DetailAST error;
        ArrayList mods = Lists.newArrayList();
        for (DetailAST modifier = aAST.getFirstChild(); modifier != null; modifier = modifier.getNextSibling()) {
            mods.add(modifier);
        }
        if (!mods.isEmpty() && (error = this.checkOrderSuggestedByJLS(mods)) != null) {
            if (error.getType() == 161) {
                this.log(error.getLineNo(), error.getColumnNo(), "annotation.order", error.getFirstChild().getText() + error.getFirstChild().getNextSibling().getText());
            } else {
                this.log(error.getLineNo(), error.getColumnNo(), "mod.order", error.getText());
            }
        }
    }

    DetailAST checkOrderSuggestedByJLS(List<DetailAST> aModifiers) {
        DetailAST modifier;
        int i = 0;
        Iterator<DetailAST> it = aModifiers.iterator();
        if (!it.hasNext()) {
            return null;
        }
        do {
            modifier = it.next();
        } while (it.hasNext() && modifier.getType() == 161);
        if (modifier.getType() == 161) {
            return null;
        }
        while (i < JLS_ORDER.length) {
            if (modifier.getType() == 161) {
                return modifier;
            }
            while (i < JLS_ORDER.length && !JLS_ORDER[i].equals(modifier.getText())) {
                ++i;
            }
            if (i == JLS_ORDER.length) {
                return modifier;
            }
            if (!it.hasNext()) {
                return null;
            }
            modifier = it.next();
        }
        return modifier;
    }
}

