/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.coding;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FastStack;
import com.puppycrawl.tools.checkstyle.api.ScopeUtils;
import java.util.HashMap;
import java.util.Map;

public class FinalLocalVariableCheck
extends Check {
    private final FastStack<Map<String, DetailAST>> mScopeStack = FastStack.newInstance();

    public int[] getDefaultTokens() {
        return new int[]{59, 8, 9, 10, 11, 12, 93, 7, 6};
    }

    public int[] getAcceptableTokens() {
        return new int[]{10, 21};
    }

    public int[] getRequiredTokens() {
        return new int[]{59, 8, 9, 11, 12, 93, 7, 6};
    }

    public void visitToken(DetailAST aAST) {
        switch (aAST.getType()) {
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 93: {
                this.mScopeStack.push(new HashMap());
                break;
            }
            case 21: {
                if (ScopeUtils.inInterfaceBlock(aAST) || this.inAbstractMethod(aAST)) break;
            }
            case 10: {
                if (aAST.getParent().getType() == 6 || aAST.getParent().getType() == 158) break;
                this.insertVariable(aAST);
                break;
            }
            case 59: {
                int parentType = aAST.getParent().getType();
                if (26 != parentType && 132 != parentType && 25 != parentType && 131 != parentType && 81 != parentType && 100 != parentType && 101 != parentType && 103 != parentType && 102 != parentType && 104 != parentType && 105 != parentType && 106 != parentType && 107 != parentType && 109 != parentType && 110 != parentType && 108 != parentType || aAST.getParent().getFirstChild() != aAST) break;
                this.removeVariable(aAST);
                break;
            }
        }
    }

    private boolean inAbstractMethod(DetailAST aAST) {
        for (DetailAST parent = aAST.getParent(); parent != null; parent = parent.getParent()) {
            if (parent.getType() != 9) continue;
            DetailAST modifiers = parent.findFirstToken(5);
            return modifiers.branchContains(41);
        }
        return false;
    }

    private void insertVariable(DetailAST aAST) {
        if (!aAST.branchContains(40)) {
            Map<String, DetailAST> state = this.mScopeStack.peek();
            DetailAST ast = aAST.findFirstToken(59);
            state.put(ast.getText(), ast);
        }
    }

    private void removeVariable(DetailAST aAST) {
        Map<String, DetailAST> state;
        DetailAST obj;
        for (int i = this.mScopeStack.size() - 1; i >= 0 && (obj = (state = this.mScopeStack.peek(i)).remove(aAST.getText())) == null; --i) {
        }
    }

    public void leaveToken(DetailAST aAST) {
        super.leaveToken(aAST);
        switch (aAST.getType()) {
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 93: {
                Map<String, DetailAST> state = this.mScopeStack.pop();
                for (DetailAST var : state.values()) {
                    this.log(var.getLineNo(), var.getColumnNo(), "final.variable", var.getText());
                }
                break;
            }
        }
    }
}

