/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.javaformat;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableRangeMap;
import com.google.errorprone.annotations.Immutable;
import com.palantir.javaformat.InputOutput;
import com.palantir.javaformat.java.FormatterDiagnostic;

public abstract class Input
extends InputOutput {
    public abstract ImmutableList<? extends Token> getTokens();

    public abstract ImmutableRangeMap<Integer, ? extends Token> getPositionTokenMap();

    public abstract ImmutableMap<Integer, Integer> getPositionToColumnMap();

    public abstract String getText();

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("super", (Object)super.toString()).toString();
    }

    public abstract int getLineNumber(int var1);

    public abstract int getColumnNumber(int var1);

    public FormatterDiagnostic createDiagnostic(int inputPosition, String message) {
        return FormatterDiagnostic.create((int)this.getLineNumber(inputPosition), (int)this.getColumnNumber(inputPosition), (String)message);
    }

    @Immutable
    public static interface Token {
        public Tok getTok();

        public ImmutableList<? extends Tok> getToksBefore();

        public ImmutableList<? extends Tok> getToksAfter();
    }

    @Immutable
    public static interface Tok {
        public int getIndex();

        public int getPosition();

        public int getColumn();

        public String getText();

        public String getOriginalText();

        public int length();

        public boolean isNewline();

        public boolean isSlashSlashComment();

        public boolean isSlashStarComment();

        public boolean isJavadocComment();

        public boolean isComment();
    }
}

