/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.gradle.docker;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.gradle.api.artifacts.DependencyConstraint;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.artifacts.ExcludeRule;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.attributes.Usage;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.internal.attributes.AttributesFactory;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.component.SoftwareComponentInternal;
import org.gradle.api.internal.component.UsageContext;
import org.gradle.api.model.ObjectFactory;

public class DockerComponent
implements SoftwareComponentInternal {
    private final UsageContext runtimeUsage;
    private final Set<PublishArtifact> artifacts = new LinkedHashSet<PublishArtifact>();
    private final DependencySet runtimeDependencies;

    public DockerComponent(PublishArtifact dockerArtifact, DependencySet runtimeDependencies, ObjectFactory objectFactory, AttributesFactory attributesFactory) {
        this.artifacts.add(dockerArtifact);
        this.runtimeDependencies = runtimeDependencies;
        Usage usage = (Usage)objectFactory.named(Usage.class, "java-runtime");
        ImmutableAttributes attributes = attributesFactory.of(Usage.USAGE_ATTRIBUTE, (Object)usage);
        this.runtimeUsage = new RuntimeUsageContext(usage, attributes);
    }

    public final String getName() {
        return "docker";
    }

    public final Set<UsageContext> getUsages() {
        return Collections.singleton(this.runtimeUsage);
    }

    private class RuntimeUsageContext
    implements UsageContext {
        private final Usage usage;
        private final ImmutableAttributes attributes;

        private RuntimeUsageContext(Usage usage, ImmutableAttributes attributes) {
            this.usage = usage;
            this.attributes = attributes;
        }

        public Usage getUsage() {
            return this.usage;
        }

        public Set<PublishArtifact> getArtifacts() {
            return DockerComponent.this.artifacts;
        }

        public Set<ModuleDependency> getDependencies() {
            return DockerComponent.this.runtimeDependencies.withType(ModuleDependency.class);
        }

        public String getName() {
            return "runtime";
        }

        public AttributeContainer getAttributes() {
            return this.attributes;
        }

        public Set<? extends DependencyConstraint> getDependencyConstraints() {
            return Collections.emptySet();
        }

        public Set<? extends Capability> getCapabilities() {
            return Collections.emptySet();
        }

        public Set<ExcludeRule> getGlobalExcludes() {
            return Collections.emptySet();
        }
    }
}

