/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.internal.restclient;

import com.openshift.internal.restclient.okhttp.ResponseCodeInterceptor;
import com.openshift.restclient.OpenShiftException;
import java.io.IOException;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class RequestingSupplier<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(RequestingSupplier.class);
    private String url;
    protected String description;
    private OkHttpClient client;
    private boolean requested = false;
    private T value;

    protected RequestingSupplier(String url, String description, OkHttpClient client) {
        this.url = url;
        this.description = description;
        this.client = client;
        this.value = this.getDefaultValue();
    }

    public T get() {
        return this.requestIfRequired();
    }

    private T requestIfRequired() {
        try {
            if (!this.requested) {
                this.value = this.request(this.url);
            }
            return this.value;
        }
        catch (IOException e) {
            throw new OpenShiftException((Throwable)e, "Unable to execute request to request url %s", this.url);
        }
    }

    protected T request(String url) throws IOException {
        Request request = new Request.Builder().url(url).header("Accept", "application/json").tag((Object)new ResponseCodeInterceptor.Ignore(){}).build();
        try (Response response = this.client.newCall(request).execute();){
            this.requested = true;
            if (response != null && response.isSuccessful()) {
                this.value = this.extractValue(response.body().string());
            } else {
                LOGGER.error("Failed to determine {}: got {}", (Object)this.description, response == null ? "null" : Integer.valueOf(response.code()));
            }
        }
        return this.value;
    }

    protected abstract T getDefaultValue();

    protected abstract T extractValue(String var1);
}

