/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.internal.restclient.model.volume;

import com.openshift.internal.restclient.model.KubernetesResource;
import com.openshift.internal.restclient.model.volume.property.AbstractPersistentVolumeProperties;
import com.openshift.internal.restclient.model.volume.property.HostPathVolumeProperties;
import com.openshift.internal.restclient.model.volume.property.NfsVolumeProperties;
import com.openshift.restclient.IClient;
import com.openshift.restclient.model.volume.IPersistentVolume;
import com.openshift.restclient.model.volume.VolumeType;
import com.openshift.restclient.model.volume.property.IHostPathVolumeProperties;
import com.openshift.restclient.model.volume.property.INfsVolumeProperties;
import com.openshift.restclient.model.volume.property.IPersistentVolumeProperties;
import com.openshift.restclient.utils.MemoryUnit;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class PersistentVolume
extends KubernetesResource
implements IPersistentVolume {
    private static final String PV_ACCESS_MODES = "spec.accessModes";
    private static final String PV_CAPACITY = "spec.capacity.storage";
    private static final String PV_RECLAIM_POLICY = "spec.persistentVolumeReclaimPolicy";
    private static final String PV_NFS = "spec.nfs";
    private static final String PV_HOST_PATH = "spec.hostPath";
    private static final String PV_SPEC = "spec";
    private static final String SERVER = "server";
    private static final String PATH = "path";
    private static final String READ_ONLY = "readOnly";

    public PersistentVolume(ModelNode node, IClient client, Map<String, String[]> propertyKeys) {
        super(node, client, propertyKeys);
    }

    @Override
    public long getCapacity(String unit) {
        String capacity = this.asString(PV_CAPACITY);
        return PersistentVolume.convert(capacity, MemoryUnit.valueOf(unit));
    }

    @Override
    public long getCapacity(MemoryUnit unit) {
        String capacity = this.asString(PV_CAPACITY);
        return PersistentVolume.convert(capacity, unit);
    }

    @Override
    public long getCapacity() {
        String capacity = this.asString(PV_CAPACITY);
        return Math.multiplyExact(PersistentVolume.convert(capacity, MemoryUnit.Ki), 1024L);
    }

    @Override
    public void setCapacity(long capacity, MemoryUnit unit) {
        this.set(PV_CAPACITY, capacity + unit.name());
    }

    @Override
    public MemoryUnit getCapacityUnit() {
        return PersistentVolume.parseCapacityUnit(this.asString(PV_CAPACITY));
    }

    @Override
    public Set<String> getAccessModes() {
        return this.asSet(PV_ACCESS_MODES, ModelType.STRING);
    }

    @Override
    public void setAccessModes(String ... modes) {
        this.get(PV_ACCESS_MODES).setEmptyList();
        this.set(PV_ACCESS_MODES, modes);
    }

    @Override
    public String getReclaimPolicy() {
        return this.asString(PV_RECLAIM_POLICY);
    }

    @Override
    public void setReclaimPolicy(String policy) {
        this.set(PV_RECLAIM_POLICY, policy);
    }

    @Override
    public IPersistentVolumeProperties getPersistentVolumeProperties() {
        IPersistentVolumeProperties properties;
        switch (this.getPVType()) {
            case "hostPath": {
                properties = this.createHostPathVolumeProperties();
                break;
            }
            case "nfs": {
                properties = this.createNFSVolumeProperties();
                break;
            }
            default: {
                properties = null;
            }
        }
        return properties;
    }

    @Override
    public void setPersistentVolumeProperties(IPersistentVolumeProperties properties) {
        if (properties instanceof AbstractPersistentVolumeProperties) {
            ((AbstractPersistentVolumeProperties)properties).setProperties(this.getNode());
        }
    }

    public String getPVType() {
        ModelNode spec = this.get(PV_SPEC);
        return VolumeType.getTypes().stream().filter(arg_0 -> ((ModelNode)spec).hasDefined(arg_0)).findFirst().get();
    }

    private INfsVolumeProperties createNFSVolumeProperties() {
        ModelNode node = this.get(PV_NFS);
        String server = this.asString(node, SERVER);
        String path = this.asString(node, PATH);
        boolean readOnly = this.asBoolean(node, READ_ONLY);
        return new NfsVolumeProperties(server, path, readOnly);
    }

    private IHostPathVolumeProperties createHostPathVolumeProperties() {
        ModelNode node = this.get(PV_HOST_PATH);
        String path = this.asString(node, PATH);
        return new HostPathVolumeProperties(path);
    }

    private static long convert(String capacity, MemoryUnit designatedUnit) {
        long number = PersistentVolume.parseCapacityValue(capacity);
        MemoryUnit currentUnit = PersistentVolume.parseCapacityUnit(capacity);
        int operation = currentUnit.compareTo(designatedUnit);
        if ((long)operation == 0L) {
            return number;
        }
        if ((long)operation > 0L) {
            return PersistentVolume.safeMultiplicationBy1024(number, operation);
        }
        return 0L;
    }

    private static long safeMultiplicationBy1024(long value, long times) {
        long multiplicand = (long)Math.pow(1024.0, times);
        return Math.multiplyExact(value, multiplicand);
    }

    private static long parseCapacityValue(String capacityString) {
        if (capacityString == null) {
            return 0L;
        }
        Pattern pattern = Pattern.compile("(\\d+)(\\w{2})");
        Matcher m = pattern.matcher(capacityString);
        if (!m.find()) {
            return 0L;
        }
        return Long.parseLong(m.group(1));
    }

    private static MemoryUnit parseCapacityUnit(String capacityString) {
        if (capacityString == null) {
            return null;
        }
        Pattern pattern = Pattern.compile("(\\d+)(\\w{2})");
        Matcher m = pattern.matcher(capacityString);
        if (!m.find()) {
            return null;
        }
        return MemoryUnit.valueOf(m.group(2));
    }
}

