/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal.notifications.internal.common;

import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.content.Context;
import android.content.res.Resources;
import android.net.Uri;
import android.os.Build;
import android.service.notification.StatusBarNotification;
import androidx.annotation.RequiresApi;
import androidx.core.app.NotificationCompat;
import androidx.core.app.NotificationManagerCompat;
import com.onesignal.common.AndroidUtils;
import com.onesignal.core.internal.time.ITime;
import com.onesignal.debug.internal.logging.Logging;
import com.onesignal.notifications.INotification;
import com.onesignal.notifications.internal.Notification;
import com.onesignal.notifications.internal.NotificationClickEvent;
import com.onesignal.notifications.internal.NotificationClickResult;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0016\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u0006J*\u0010\f\u001a\u00020\r2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0016\u0010\u000e\u001a\u0012\u0012\u0004\u0012\u00020\u00100\u000fj\b\u0012\u0004\u0012\u00020\u0010`\u0011H\u0007J\u001d\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0000\u00a2\u0006\u0002\b\u0018J \u0010\u0019\u001a\u0012\u0012\u0004\u0012\u00020\u00100\u000fj\b\u0012\u0004\u0012\u00020\u0010`\u00112\u0006\u0010\t\u001a\u00020\nH\u0007J\u001b\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00100\u001b2\u0006\u0010\t\u001a\u00020\nH\u0007\u00a2\u0006\u0002\u0010\u001cJ\u000e\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u001fJ\u000e\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020!J\u0010\u0010#\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nH\u0007J\u0012\u0010$\u001a\u0004\u0018\u00010\u00062\b\u0010%\u001a\u0004\u0018\u00010!J\u000e\u0010&\u001a\u00020'2\u0006\u0010\t\u001a\u00020\nJ\u001a\u0010(\u001a\u0004\u0018\u00010)2\u0006\u0010\t\u001a\u00020\n2\b\u0010*\u001a\u0004\u0018\u00010\u0006J\u000e\u0010+\u001a\u00020\b2\u0006\u0010,\u001a\u00020\u0010J\u0010\u0010-\u001a\u0004\u0018\u00010.2\u0006\u0010/\u001a\u00020!R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lcom/onesignal/notifications/internal/common/NotificationHelper;", "", "()V", "GROUPLESS_SUMMARY_ID", "", "GROUPLESS_SUMMARY_KEY", "", "areNotificationsEnabled", "", "context", "Landroid/content/Context;", "channelId", "assignGrouplessNotifications", "", "grouplessNotifs", "Ljava/util/ArrayList;", "Landroid/service/notification/StatusBarNotification;", "Lkotlin/collections/ArrayList;", "generateNotificationOpenedResult", "Lcom/onesignal/notifications/internal/NotificationClickEvent;", "jsonArray", "Lorg/json/JSONArray;", "time", "Lcom/onesignal/core/internal/time/ITime;", "generateNotificationOpenedResult$com_onesignal_notifications", "getActiveGrouplessNotifications", "getActiveNotifications", "", "(Landroid/content/Context;)[Landroid/service/notification/StatusBarNotification;", "getCampaignNameFromNotification", "notification", "Lcom/onesignal/notifications/INotification;", "getCustomJSONObject", "Lorg/json/JSONObject;", "jsonObject", "getGrouplessNotifsCount", "getNotificationIdFromFCMJson", "fcmJson", "getNotificationManager", "Landroid/app/NotificationManager;", "getSoundUri", "Landroid/net/Uri;", "sound", "isGroupSummary", "notif", "parseVibrationPattern", "", "fcmBundle", "com.onesignal.notifications"})
public final class NotificationHelper {
    @NotNull
    public static final NotificationHelper INSTANCE = new NotificationHelper();
    @NotNull
    public static final String GROUPLESS_SUMMARY_KEY = "os_group_undefined";
    public static final int GROUPLESS_SUMMARY_ID = -718463522;

    private NotificationHelper() {
    }

    @RequiresApi(api=23)
    @NotNull
    public final StatusBarNotification[] getActiveNotifications(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        StatusBarNotification[] statusBarNotifications = new StatusBarNotification[]{};
        try {
            StatusBarNotification[] statusBarNotificationArray = this.getNotificationManager(context).getActiveNotifications();
            Intrinsics.checkNotNullExpressionValue((Object)statusBarNotificationArray, (String)"getActiveNotifications(...)");
            statusBarNotifications = statusBarNotificationArray;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return statusBarNotifications;
    }

    @RequiresApi(api=23)
    public final int getGrouplessNotifsCount(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        StatusBarNotification[] statusBarNotifications = this.getActiveNotifications(context);
        int groupCount = 0;
        for (StatusBarNotification statusBarNotification : statusBarNotifications) {
            if (NotificationCompat.isGroupSummary((android.app.Notification)statusBarNotification.getNotification()) || !Intrinsics.areEqual((Object)GROUPLESS_SUMMARY_KEY, (Object)statusBarNotification.getNotification().getGroup())) continue;
            ++groupCount;
        }
        return groupCount;
    }

    @RequiresApi(api=23)
    @NotNull
    public final ArrayList<StatusBarNotification> getActiveGrouplessNotifications(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ArrayList<StatusBarNotification> grouplessStatusBarNotifications = new ArrayList<StatusBarNotification>();
        for (StatusBarNotification statusBarNotification : this.getActiveNotifications(context)) {
            boolean isGroupless;
            android.app.Notification notification = statusBarNotification.getNotification();
            boolean isGroupSummary = this.isGroupSummary(statusBarNotification);
            boolean bl = isGroupless = notification.getGroup() == null || Intrinsics.areEqual((Object)notification.getGroup(), (Object)GROUPLESS_SUMMARY_KEY);
            if (isGroupSummary || !isGroupless) continue;
            grouplessStatusBarNotifications.add(statusBarNotification);
        }
        return grouplessStatusBarNotifications;
    }

    public final boolean isGroupSummary(@NotNull StatusBarNotification notif) {
        Intrinsics.checkNotNullParameter((Object)notif, (String)"notif");
        return (notif.getNotification().flags & 0x200) != 0;
    }

    @RequiresApi(api=24)
    public final void assignGrouplessNotifications(@Nullable Context context, @NotNull ArrayList<StatusBarNotification> grouplessNotifs) {
        Intrinsics.checkNotNullParameter(grouplessNotifs, (String)"grouplessNotifs");
        for (StatusBarNotification grouplessNotif : grouplessNotifs) {
            android.app.Notification notif;
            Notification.Builder grouplessNotifBuilder;
            Intrinsics.checkNotNullExpressionValue((Object)Notification.Builder.recoverBuilder((Context)context, (android.app.Notification)grouplessNotif.getNotification()), (String)"recoverBuilder(...)");
            Intrinsics.checkNotNullExpressionValue((Object)grouplessNotifBuilder.setGroup(GROUPLESS_SUMMARY_KEY).setOnlyAlertOnce(true).build(), (String)"build(...)");
            Context context2 = context;
            Intrinsics.checkNotNull((Object)context2);
            NotificationManagerCompat.from((Context)context2).notify(grouplessNotif.getId(), notif);
        }
    }

    public final boolean areNotificationsEnabled(@NotNull Context context, @Nullable String channelId) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        try {
            boolean notificationsEnabled = NotificationManagerCompat.from((Context)context).areNotificationsEnabled();
            if (!notificationsEnabled) {
                return false;
            }
            if (channelId != null && Build.VERSION.SDK_INT >= 26) {
                NotificationManager notificationManager = this.getNotificationManager(context);
                NotificationChannel channel = notificationManager != null ? notificationManager.getNotificationChannel(channelId) : null;
                return channel == null || channel.getImportance() != 0;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return true;
    }

    public static /* synthetic */ boolean areNotificationsEnabled$default(NotificationHelper notificationHelper, Context context, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = null;
        }
        return notificationHelper.areNotificationsEnabled(context, string);
    }

    @NotNull
    public final NotificationManager getNotificationManager(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = context.getSystemService("notification");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.app.NotificationManager");
        return (NotificationManager)object;
    }

    @NotNull
    public final JSONObject getCustomJSONObject(@NotNull JSONObject jsonObject) throws JSONException {
        Intrinsics.checkNotNullParameter((Object)jsonObject, (String)"jsonObject");
        return new JSONObject(jsonObject.optString("custom"));
    }

    @Nullable
    public final String getNotificationIdFromFCMJson(@Nullable JSONObject fcmJson) {
        if (fcmJson == null) {
            return null;
        }
        try {
            JSONObject customJSON = new JSONObject(fcmJson.getString("custom"));
            if (customJSON.has("i")) {
                return customJSON.optString("i", null);
            }
            Logging.debug$default((String)"Not a OneSignal formatted FCM message. No 'i' field in custom.", null, (int)2, null);
        }
        catch (JSONException e) {
            Logging.debug$default((String)"Not a OneSignal formatted FCM message. No 'custom' field in the JSONObject.", null, (int)2, null);
        }
        return null;
    }

    @Nullable
    public final long[] parseVibrationPattern(@NotNull JSONObject fcmBundle) {
        Intrinsics.checkNotNullParameter((Object)fcmBundle, (String)"fcmBundle");
        try {
            JSONArray jSONArray;
            Object patternObj = fcmBundle.opt("vib_pt");
            JSONArray jsonVibArray = null;
            if (patternObj instanceof String) {
                jSONArray = new JSONArray((String)patternObj);
            } else {
                Intrinsics.checkNotNull((Object)patternObj, (String)"null cannot be cast to non-null type org.json.JSONArray");
                jSONArray = (JSONArray)patternObj;
            }
            jsonVibArray = jSONArray;
            long[] longArray = new long[jsonVibArray.length()];
            int n = jsonVibArray.length();
            for (int i = 0; i < n; ++i) {
                longArray[i] = jsonVibArray.optLong(i);
            }
            return longArray;
        }
        catch (JSONException jSONException) {
            return null;
        }
    }

    @Nullable
    public final Uri getSoundUri(@NotNull Context context, @Nullable String sound) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Resources resources = context.getResources();
        String packageName = context.getPackageName();
        int soundId = 0;
        if (AndroidUtils.INSTANCE.isValidResourceName(sound) && (soundId = resources.getIdentifier(sound, "raw", packageName)) != 0) {
            return Uri.parse((String)("android.resource://" + packageName + '/' + soundId));
        }
        soundId = resources.getIdentifier("onesignal_default_sound", "raw", packageName);
        return soundId != 0 ? Uri.parse((String)("android.resource://" + packageName + '/' + soundId)) : null;
    }

    @NotNull
    public final String getCampaignNameFromNotification(@NotNull INotification notification) {
        Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
        String string = notification.getTemplateName();
        if (!(string != null ? ((CharSequence)string).length() == 0 : false)) {
            String string2 = notification.getTemplateId();
            if (!(string2 != null ? ((CharSequence)string2).length() == 0 : false)) {
                return notification.getTemplateName() + " - " + notification.getTemplateId();
            }
        }
        if (notification.getTitle() != null) {
            String string3 = notification.getTitle();
            Intrinsics.checkNotNull((Object)string3);
            String string4 = notification.getTitle();
            Intrinsics.checkNotNull((Object)string4);
            String string5 = string3.substring(0, Math.min(10, string4.length()));
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
            return string5;
        }
        return "";
    }

    @NotNull
    public final NotificationClickEvent generateNotificationOpenedResult$com_onesignal_notifications(@NotNull JSONArray jsonArray, @NotNull ITime time) {
        Intrinsics.checkNotNullParameter((Object)jsonArray, (String)"jsonArray");
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        int jsonArraySize = jsonArray.length();
        boolean firstMessage = true;
        int androidNotificationId = jsonArray.optJSONObject(0).optInt("androidNotificationId");
        List groupedNotifications = new ArrayList();
        String actionSelected = null;
        JSONObject payload = null;
        for (int i = 0; i < jsonArraySize; ++i) {
            try {
                payload = jsonArray.getJSONObject(i);
                if (actionSelected == null && payload.has("actionId")) {
                    actionSelected = payload.optString("actionId", null);
                }
                if (firstMessage) {
                    firstMessage = false;
                    continue;
                }
                groupedNotifications.add(new Notification(payload, time));
                continue;
            }
            catch (Throwable t) {
                Logging.error((String)("Error parsing JSON item " + i + '/' + jsonArraySize + " for callback."), (Throwable)t);
            }
        }
        JSONObject jSONObject = payload;
        Intrinsics.checkNotNull((Object)jSONObject);
        Notification notification = new Notification(groupedNotifications, jSONObject, androidNotificationId, time);
        NotificationClickResult notificationResult = new NotificationClickResult(actionSelected, notification.getLaunchURL());
        return new NotificationClickEvent(notification, notificationResult);
    }
}

