/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal.notifications.internal;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import com.onesignal.common.events.EventProducer;
import com.onesignal.common.threading.ThreadUtilsKt;
import com.onesignal.core.internal.application.IApplicationLifecycleHandler;
import com.onesignal.core.internal.application.IApplicationService;
import com.onesignal.debug.internal.logging.Logging;
import com.onesignal.notifications.INotificationClickListener;
import com.onesignal.notifications.INotificationLifecycleListener;
import com.onesignal.notifications.INotificationsManager;
import com.onesignal.notifications.IPermissionObserver;
import com.onesignal.notifications.internal.INotificationActivityOpener;
import com.onesignal.notifications.internal.common.GenerateNotificationOpenIntent;
import com.onesignal.notifications.internal.common.GenerateNotificationOpenIntentFromPushPayload;
import com.onesignal.notifications.internal.common.NotificationHelper;
import com.onesignal.notifications.internal.data.INotificationRepository;
import com.onesignal.notifications.internal.lifecycle.INotificationLifecycleService;
import com.onesignal.notifications.internal.permissions.INotificationPermissionChangedHandler;
import com.onesignal.notifications.internal.permissions.INotificationPermissionController;
import com.onesignal.notifications.internal.restoration.INotificationRestoreWorkManager;
import com.onesignal.notifications.internal.summary.INotificationSummaryManager;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004B5\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0011J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\"H\u0016J\u0010\u0010#\u001a\u00020\u001e2\u0006\u0010$\u001a\u00020\u001cH\u0016J\b\u0010%\u001a\u00020\u001eH\u0016J\b\u0010&\u001a\u00020\u001eH\u0016J\u0010\u0010'\u001a\u00020\u001e2\u0006\u0010(\u001a\u00020\u0013H\u0016J\b\u0010)\u001a\u00020\u001eH\u0016J!\u0010*\u001a\u00020\u001e2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010/J\b\u00100\u001a\u00020\u001eH\u0002J\u0010\u00101\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0010\u00102\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\"H\u0016J\u0010\u00103\u001a\u00020\u001e2\u0006\u00104\u001a\u000205H\u0016J\u0010\u00106\u001a\u00020\u001e2\u0006\u00107\u001a\u000208H\u0016J\u0010\u00109\u001a\u00020\u001e2\u0006\u0010$\u001a\u00020\u001cH\u0016J\u0019\u0010:\u001a\u00020\u00132\u0006\u0010;\u001a\u00020\u0013H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010<J\u0010\u0010=\u001a\u00020\u001e2\u0006\u0010>\u001a\u00020\u0013H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u0013X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0015\"\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006?"}, d2={"Lcom/onesignal/notifications/internal/NotificationsManager;", "Lcom/onesignal/notifications/INotificationsManager;", "Lcom/onesignal/notifications/internal/INotificationActivityOpener;", "Lcom/onesignal/notifications/internal/permissions/INotificationPermissionChangedHandler;", "Lcom/onesignal/core/internal/application/IApplicationLifecycleHandler;", "_applicationService", "Lcom/onesignal/core/internal/application/IApplicationService;", "_notificationPermissionController", "Lcom/onesignal/notifications/internal/permissions/INotificationPermissionController;", "_notificationRestoreWorkManager", "Lcom/onesignal/notifications/internal/restoration/INotificationRestoreWorkManager;", "_notificationLifecycleService", "Lcom/onesignal/notifications/internal/lifecycle/INotificationLifecycleService;", "_notificationDataController", "Lcom/onesignal/notifications/internal/data/INotificationRepository;", "_summaryManager", "Lcom/onesignal/notifications/internal/summary/INotificationSummaryManager;", "(Lcom/onesignal/core/internal/application/IApplicationService;Lcom/onesignal/notifications/internal/permissions/INotificationPermissionController;Lcom/onesignal/notifications/internal/restoration/INotificationRestoreWorkManager;Lcom/onesignal/notifications/internal/lifecycle/INotificationLifecycleService;Lcom/onesignal/notifications/internal/data/INotificationRepository;Lcom/onesignal/notifications/internal/summary/INotificationSummaryManager;)V", "canRequestPermission", "", "getCanRequestPermission", "()Z", "permission", "getPermission", "setPermission", "(Z)V", "permissionChangedNotifier", "Lcom/onesignal/common/events/EventProducer;", "Lcom/onesignal/notifications/IPermissionObserver;", "addClickListener", "", "listener", "Lcom/onesignal/notifications/INotificationClickListener;", "addForegroundLifecycleListener", "Lcom/onesignal/notifications/INotificationLifecycleListener;", "addPermissionObserver", "observer", "clearAllNotifications", "onFocus", "onNotificationPermissionChanged", "enabled", "onUnfocused", "openDestinationActivity", "activity", "Landroid/app/Activity;", "pushPayloads", "Lorg/json/JSONArray;", "(Landroid/app/Activity;Lorg/json/JSONArray;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "refreshNotificationState", "removeClickListener", "removeForegroundLifecycleListener", "removeGroupedNotifications", "group", "", "removeNotification", "id", "", "removePermissionObserver", "requestPermission", "fallbackToSettings", "(ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "setPermissionStatusAndFire", "isEnabled", "com.onesignal.notifications"})
public final class NotificationsManager
implements INotificationsManager,
INotificationActivityOpener,
INotificationPermissionChangedHandler,
IApplicationLifecycleHandler {
    @NotNull
    private final IApplicationService _applicationService;
    @NotNull
    private final INotificationPermissionController _notificationPermissionController;
    @NotNull
    private final INotificationRestoreWorkManager _notificationRestoreWorkManager;
    @NotNull
    private final INotificationLifecycleService _notificationLifecycleService;
    @NotNull
    private final INotificationRepository _notificationDataController;
    @NotNull
    private final INotificationSummaryManager _summaryManager;
    private boolean permission;
    @NotNull
    private final EventProducer<IPermissionObserver> permissionChangedNotifier;

    public NotificationsManager(@NotNull IApplicationService _applicationService, @NotNull INotificationPermissionController _notificationPermissionController, @NotNull INotificationRestoreWorkManager _notificationRestoreWorkManager, @NotNull INotificationLifecycleService _notificationLifecycleService, @NotNull INotificationRepository _notificationDataController, @NotNull INotificationSummaryManager _summaryManager) {
        Intrinsics.checkNotNullParameter((Object)_applicationService, (String)"_applicationService");
        Intrinsics.checkNotNullParameter((Object)_notificationPermissionController, (String)"_notificationPermissionController");
        Intrinsics.checkNotNullParameter((Object)_notificationRestoreWorkManager, (String)"_notificationRestoreWorkManager");
        Intrinsics.checkNotNullParameter((Object)_notificationLifecycleService, (String)"_notificationLifecycleService");
        Intrinsics.checkNotNullParameter((Object)_notificationDataController, (String)"_notificationDataController");
        Intrinsics.checkNotNullParameter((Object)_summaryManager, (String)"_summaryManager");
        this._applicationService = _applicationService;
        this._notificationPermissionController = _notificationPermissionController;
        this._notificationRestoreWorkManager = _notificationRestoreWorkManager;
        this._notificationLifecycleService = _notificationLifecycleService;
        this._notificationDataController = _notificationDataController;
        this._summaryManager = _summaryManager;
        this.permission = NotificationHelper.areNotificationsEnabled$default(NotificationHelper.INSTANCE, this._applicationService.getAppContext(), null, 2, null);
        this.permissionChangedNotifier = new EventProducer();
        this._applicationService.addApplicationLifecycleHandler((IApplicationLifecycleHandler)this);
        this._notificationPermissionController.subscribe(this);
        ThreadUtilsKt.suspendifyOnThread$default((int)0, (Function1)((Function1)new Function1<Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ NotificationsManager this$0;
            {
                this.this$0 = $receiver;
                super(1, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = this.this$0._notificationDataController.deleteExpiredNotifications((Continuation<? super Unit>)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@Nullable Continuation<? super Unit> p1) {
                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
    }

    public boolean getPermission() {
        return this.permission;
    }

    public void setPermission(boolean bl) {
        this.permission = bl;
    }

    public boolean getCanRequestPermission() {
        return this._notificationPermissionController.getCanRequestPermission();
    }

    public void onFocus() {
        this.refreshNotificationState();
    }

    public void onUnfocused() {
    }

    @Override
    public void onNotificationPermissionChanged(boolean enabled) {
        this.setPermissionStatusAndFire(enabled);
    }

    private final void refreshNotificationState() {
        this._notificationRestoreWorkManager.beginEnqueueingWork(this._applicationService.getAppContext(), false);
        boolean isEnabled = NotificationHelper.areNotificationsEnabled$default(NotificationHelper.INSTANCE, this._applicationService.getAppContext(), null, 2, null);
        this.setPermissionStatusAndFire(isEnabled);
    }

    @Nullable
    public Object requestPermission(boolean fallbackToSettings, @NotNull Continuation<? super Boolean> $completion) {
        Logging.debug$default((String)"NotificationsManager.requestPermission()", null, (int)2, null);
        return BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getMain()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Boolean>, Object>(this, fallbackToSettings, null){
            int label;
            final /* synthetic */ NotificationsManager this$0;
            final /* synthetic */ boolean $fallbackToSettings;
            {
                this.this$0 = $receiver;
                this.$fallbackToSettings = $fallbackToSettings;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = NotificationsManager.access$get_notificationPermissionController$p(this.this$0).prompt(this.$fallbackToSettings, (Continuation<? super Boolean>)((Continuation)this));
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Boolean> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    private final void setPermissionStatusAndFire(boolean isEnabled) {
        boolean oldPermissionStatus = this.getPermission();
        this.setPermission(isEnabled);
        if (oldPermissionStatus != isEnabled) {
            this.permissionChangedNotifier.fireOnMain((Function1)new Function1<IPermissionObserver, Unit>(isEnabled){
                final /* synthetic */ boolean $isEnabled;
                {
                    this.$isEnabled = $isEnabled;
                    super(1);
                }

                public final void invoke(@NotNull IPermissionObserver it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    it.onNotificationPermissionChange(this.$isEnabled);
                }
            });
        }
    }

    public void removeNotification(int id) {
        Logging.debug$default((String)("NotificationsManager.removeNotification(id: " + id + ')'), null, (int)2, null);
        ThreadUtilsKt.suspendifyOnThread$default((int)0, (Function1)((Function1)new Function1<Continuation<? super Unit>, Object>(this, id, null){
            int label;
            final /* synthetic */ NotificationsManager this$0;
            final /* synthetic */ int $id;
            {
                this.this$0 = $receiver;
                this.$id = $id;
                super(1, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        this.label = 1;
                        v0 = NotificationsManager.access$get_notificationDataController$p(this.this$0).markAsDismissed(this.$id, (Continuation<? super Boolean>)((Continuation)this));
                        if (v0 == var2_2) {
                            return var2_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        if (((Boolean)v0).booleanValue()) {
                            this.label = 2;
                            v1 = NotificationsManager.access$get_summaryManager$p(this.this$0).updatePossibleDependentSummaryOnDismiss(this.$id, (Continuation<? super Unit>)((Continuation)this));
                            if (v1 == var2_2) {
                                return var2_2;
                            }
                        }
                        ** GOTO lbl22
                    }
                    case 2: {
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl22:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@Nullable Continuation<? super Unit> p1) {
                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
    }

    public void removeGroupedNotifications(@NotNull String group) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Logging.debug$default((String)("NotificationsManager.removeGroupedNotifications(group: " + group + ')'), null, (int)2, null);
        ThreadUtilsKt.suspendifyOnThread$default((int)0, (Function1)((Function1)new Function1<Continuation<? super Unit>, Object>(this, group, null){
            int label;
            final /* synthetic */ NotificationsManager this$0;
            final /* synthetic */ String $group;
            {
                this.this$0 = $receiver;
                this.$group = $group;
                super(1, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = NotificationsManager.access$get_notificationDataController$p(this.this$0).markAsDismissedForGroup(this.$group, (Continuation<? super Unit>)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@Nullable Continuation<? super Unit> p1) {
                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
    }

    public void clearAllNotifications() {
        Logging.debug$default((String)"NotificationsManager.clearAllNotifications()", null, (int)2, null);
        ThreadUtilsKt.suspendifyOnThread$default((int)0, (Function1)((Function1)new Function1<Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ NotificationsManager this$0;
            {
                this.this$0 = $receiver;
                super(1, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = NotificationsManager.access$get_notificationDataController$p(this.this$0).markAsDismissedForOutstanding((Continuation<? super Unit>)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@Nullable Continuation<? super Unit> p1) {
                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
    }

    public void addPermissionObserver(@NotNull IPermissionObserver observer) {
        Intrinsics.checkNotNullParameter((Object)observer, (String)"observer");
        Logging.debug$default((String)("NotificationsManager.addPermissionObserver(observer: " + observer + ')'), null, (int)2, null);
        this.permissionChangedNotifier.subscribe((Object)observer);
    }

    public void removePermissionObserver(@NotNull IPermissionObserver observer) {
        Intrinsics.checkNotNullParameter((Object)observer, (String)"observer");
        Logging.debug$default((String)("NotificationsManager.removePermissionObserver(observer: " + observer + ')'), null, (int)2, null);
        this.permissionChangedNotifier.unsubscribe((Object)observer);
    }

    public void addForegroundLifecycleListener(@NotNull INotificationLifecycleListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        Logging.debug$default((String)("NotificationsManager.addForegroundLifecycleListener(listener: " + listener + ')'), null, (int)2, null);
        this._notificationLifecycleService.addExternalForegroundLifecycleListener(listener);
    }

    public void removeForegroundLifecycleListener(@NotNull INotificationLifecycleListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        Logging.debug$default((String)("NotificationsManager.removeForegroundLifecycleListener(listener: " + listener + ')'), null, (int)2, null);
        this._notificationLifecycleService.removeExternalForegroundLifecycleListener(listener);
    }

    public void addClickListener(@NotNull INotificationClickListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        Logging.debug$default((String)("NotificationsManager.addClickListener(handler: " + listener + ')'), null, (int)2, null);
        this._notificationLifecycleService.addExternalClickListener(listener);
    }

    public void removeClickListener(@NotNull INotificationClickListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        Logging.debug$default((String)("NotificationsManager.removeClickListener(listener: " + listener + ')'), null, (int)2, null);
        this._notificationLifecycleService.removeExternalClickListener(listener);
    }

    @Override
    @Nullable
    public Object openDestinationActivity(@NotNull Activity activity, @NotNull JSONArray pushPayloads, @NotNull Continuation<? super Unit> $completion) {
        try {
            JSONObject firstPayloadItem = pushPayloads.getJSONObject(0);
            Context context = (Context)activity;
            Intrinsics.checkNotNullExpressionValue((Object)firstPayloadItem, (String)"firstPayloadItem");
            GenerateNotificationOpenIntent intentGenerator = GenerateNotificationOpenIntentFromPushPayload.INSTANCE.create(context, firstPayloadItem);
            Intent intent = intentGenerator.getIntentVisible();
            if (intent != null) {
                Logging.info$default((String)("SDK running startActivity with Intent: " + intent), null, (int)2, null);
                activity.startActivity(intent);
            } else {
                Logging.info$default((String)"SDK not showing an Activity automatically due to it's settings.", null, (int)2, null);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ INotificationPermissionController access$get_notificationPermissionController$p(NotificationsManager $this) {
        return $this._notificationPermissionController;
    }

    public static final /* synthetic */ INotificationSummaryManager access$get_summaryManager$p(NotificationsManager $this) {
        return $this._summaryManager;
    }
}

