/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal.notifications.internal;

import androidx.core.app.NotificationCompat;
import com.onesignal.common.JSONObjectExtensionsKt;
import com.onesignal.common.threading.WaiterWithValue;
import com.onesignal.core.internal.time.ITime;
import com.onesignal.debug.internal.logging.Logging;
import com.onesignal.notifications.BackgroundImageLayout;
import com.onesignal.notifications.IActionButton;
import com.onesignal.notifications.IDisplayableMutableNotification;
import com.onesignal.notifications.internal.common.NotificationHelper;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u001a\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\t\n\u0002\b\u001a\n\u0002\u0010\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u0001:\u0001\u007fB\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B/\b\u0016\u0012\u000e\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\u0000\u0018\u00010\b\u0012\u0006\u0010\t\u001a\u00020\u0003\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\fJ\b\u0010t\u001a\u00020uH\u0016J\u0006\u0010v\u001a\u000200J\u0018\u0010w\u001a\u00020u2\u0006\u0010x\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\b\u0010y\u001a\u00020uH\u0002J\u0010\u0010z\u001a\u00020u2\u0006\u0010x\u001a\u00020\u0003H\u0002J\u0012\u0010{\u001a\u00020u2\b\u0010|\u001a\u0004\u0018\u00010KH\u0016J\u0006\u0010}\u001a\u00020\u0003J\b\u0010~\u001a\u00020#H\u0016R\"\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001c\u0010\u0013\u001a\u0004\u0018\u00010\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001a\u0010\n\u001a\u00020\u000bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001c\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u001c\u0010\"\u001a\u0004\u0018\u00010#X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R\u001c\u0010(\u001a\u0004\u0018\u00010#X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010%\"\u0004\b*\u0010'R\u001c\u0010+\u001a\u0004\u0018\u00010#X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010%\"\u0004\b-\u0010'R\u0017\u0010.\u001a\b\u0012\u0004\u0012\u0002000/\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u00102R\u001c\u00103\u001a\u0004\u0018\u00010#X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b4\u0010%\"\u0004\b5\u0010'R\u001c\u00106\u001a\u0004\u0018\u00010#X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b7\u0010%\"\u0004\b8\u0010'R\u001c\u00109\u001a\u0004\u0018\u00010#X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b:\u0010%\"\u0004\b;\u0010'R\"\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\u0000\u0018\u00010\bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b<\u0010\u0010\"\u0004\b=\u0010\u0012R\u001c\u0010>\u001a\u0004\u0018\u00010#X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b?\u0010%\"\u0004\b@\u0010'R\u001c\u0010A\u001a\u0004\u0018\u00010#X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bB\u0010%\"\u0004\bC\u0010'R\u001c\u0010D\u001a\u0004\u0018\u00010#X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bE\u0010%\"\u0004\bF\u0010'R\u001a\u0010G\u001a\u00020\u000bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bH\u0010\u0019\"\u0004\bI\u0010\u001bR\u001c\u0010J\u001a\u0004\u0018\u00010KX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bL\u0010M\"\u0004\bN\u0010OR\u001c\u0010P\u001a\u0004\u0018\u00010#X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bQ\u0010%\"\u0004\bR\u0010'R\u001a\u0010S\u001a\u00020\u000bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bT\u0010\u0019\"\u0004\bU\u0010\u001bR\u001a\u0010V\u001a\u00020#X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bW\u0010%\"\u0004\bX\u0010'R\u001a\u0010Y\u001a\u00020ZX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b[\u0010\\\"\u0004\b]\u0010^R\u001c\u0010_\u001a\u0004\u0018\u00010#X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b`\u0010%\"\u0004\ba\u0010'R\u001c\u0010b\u001a\u0004\u0018\u00010#X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bc\u0010%\"\u0004\bd\u0010'R\u001c\u0010e\u001a\u0004\u0018\u00010#X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bf\u0010%\"\u0004\bg\u0010'R\u001c\u0010h\u001a\u0004\u0018\u00010#X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bi\u0010%\"\u0004\bj\u0010'R\u001c\u0010k\u001a\u0004\u0018\u00010#X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bl\u0010%\"\u0004\bm\u0010'R\u001c\u0010n\u001a\u0004\u0018\u00010#X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bo\u0010%\"\u0004\bp\u0010'R\u001a\u0010q\u001a\u00020\u000bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\br\u0010\u0019\"\u0004\bs\u0010\u001b\u00a8\u0006\u0080\u0001"}, d2={"Lcom/onesignal/notifications/internal/Notification;", "Lcom/onesignal/notifications/IDisplayableMutableNotification;", "payload", "Lorg/json/JSONObject;", "time", "Lcom/onesignal/core/internal/time/ITime;", "(Lorg/json/JSONObject;Lcom/onesignal/core/internal/time/ITime;)V", "groupedNotifications", "", "jsonPayload", "androidNotificationId", "", "(Ljava/util/List;Lorg/json/JSONObject;ILcom/onesignal/core/internal/time/ITime;)V", "actionButtons", "Lcom/onesignal/notifications/IActionButton;", "getActionButtons", "()Ljava/util/List;", "setActionButtons", "(Ljava/util/List;)V", "additionalData", "getAdditionalData", "()Lorg/json/JSONObject;", "setAdditionalData", "(Lorg/json/JSONObject;)V", "getAndroidNotificationId", "()I", "setAndroidNotificationId", "(I)V", "backgroundImageLayout", "Lcom/onesignal/notifications/BackgroundImageLayout;", "getBackgroundImageLayout", "()Lcom/onesignal/notifications/BackgroundImageLayout;", "setBackgroundImageLayout", "(Lcom/onesignal/notifications/BackgroundImageLayout;)V", "bigPicture", "", "getBigPicture", "()Ljava/lang/String;", "setBigPicture", "(Ljava/lang/String;)V", "body", "getBody", "setBody", "collapseId", "getCollapseId", "setCollapseId", "displayWaiter", "Lcom/onesignal/common/threading/WaiterWithValue;", "", "getDisplayWaiter", "()Lcom/onesignal/common/threading/WaiterWithValue;", "fromProjectNumber", "getFromProjectNumber", "setFromProjectNumber", "groupKey", "getGroupKey", "setGroupKey", "groupMessage", "getGroupMessage", "setGroupMessage", "getGroupedNotifications", "setGroupedNotifications", "largeIcon", "getLargeIcon", "setLargeIcon", "launchURL", "getLaunchURL", "setLaunchURL", "ledColor", "getLedColor", "setLedColor", "lockScreenVisibility", "getLockScreenVisibility", "setLockScreenVisibility", "notificationExtender", "Landroidx/core/app/NotificationCompat$Extender;", "getNotificationExtender", "()Landroidx/core/app/NotificationCompat$Extender;", "setNotificationExtender", "(Landroidx/core/app/NotificationCompat$Extender;)V", "notificationId", "getNotificationId", "setNotificationId", "priority", "getPriority", "setPriority", "rawPayload", "getRawPayload", "setRawPayload", "sentTime", "", "getSentTime", "()J", "setSentTime", "(J)V", "smallIcon", "getSmallIcon", "setSmallIcon", "smallIconAccentColor", "getSmallIconAccentColor", "setSmallIconAccentColor", "sound", "getSound", "setSound", "templateId", "getTemplateId", "setTemplateId", "templateName", "getTemplateName", "setTemplateName", "title", "getTitle", "setTitle", "ttl", "getTtl", "setTtl", "display", "", "hasNotificationId", "initPayloadData", "currentJsonPayload", "setActionButtonsFromData", "setBackgroundImageLayoutFromData", "setExtender", "extender", "toJSONObject", "toString", "ActionButton", "com.onesignal.notifications"})
public final class Notification
implements IDisplayableMutableNotification {
    @Nullable
    private NotificationCompat.Extender notificationExtender;
    @NotNull
    private final WaiterWithValue<Boolean> displayWaiter;
    @Nullable
    private List<Notification> groupedNotifications;
    private int androidNotificationId;
    @Nullable
    private String notificationId;
    @Nullable
    private String templateName;
    @Nullable
    private String templateId;
    @Nullable
    private String title;
    @Nullable
    private String body;
    @Nullable
    private JSONObject additionalData;
    @Nullable
    private String smallIcon;
    @Nullable
    private String largeIcon;
    @Nullable
    private String bigPicture;
    @Nullable
    private String smallIconAccentColor;
    @Nullable
    private String launchURL;
    @Nullable
    private String sound;
    @Nullable
    private String ledColor;
    private int lockScreenVisibility;
    @Nullable
    private String groupKey;
    @Nullable
    private String groupMessage;
    @Nullable
    private List<? extends IActionButton> actionButtons;
    @Nullable
    private String fromProjectNumber;
    @Nullable
    private BackgroundImageLayout backgroundImageLayout;
    @Nullable
    private String collapseId;
    private int priority;
    private long sentTime;
    private int ttl;
    @NotNull
    private String rawPayload;

    @Nullable
    public final NotificationCompat.Extender getNotificationExtender() {
        return this.notificationExtender;
    }

    public final void setNotificationExtender(@Nullable NotificationCompat.Extender extender) {
        this.notificationExtender = extender;
    }

    @NotNull
    public final WaiterWithValue<Boolean> getDisplayWaiter() {
        return this.displayWaiter;
    }

    @Nullable
    public List<Notification> getGroupedNotifications() {
        return this.groupedNotifications;
    }

    public void setGroupedNotifications(@Nullable List<Notification> list) {
        this.groupedNotifications = list;
    }

    public int getAndroidNotificationId() {
        return this.androidNotificationId;
    }

    public void setAndroidNotificationId(int n) {
        this.androidNotificationId = n;
    }

    @Nullable
    public String getNotificationId() {
        return this.notificationId;
    }

    public void setNotificationId(@Nullable String string) {
        this.notificationId = string;
    }

    @Nullable
    public String getTemplateName() {
        return this.templateName;
    }

    public void setTemplateName(@Nullable String string) {
        this.templateName = string;
    }

    @Nullable
    public String getTemplateId() {
        return this.templateId;
    }

    public void setTemplateId(@Nullable String string) {
        this.templateId = string;
    }

    @Nullable
    public String getTitle() {
        return this.title;
    }

    public void setTitle(@Nullable String string) {
        this.title = string;
    }

    @Nullable
    public String getBody() {
        return this.body;
    }

    public void setBody(@Nullable String string) {
        this.body = string;
    }

    @Nullable
    public JSONObject getAdditionalData() {
        return this.additionalData;
    }

    public void setAdditionalData(@Nullable JSONObject jSONObject) {
        this.additionalData = jSONObject;
    }

    @Nullable
    public String getSmallIcon() {
        return this.smallIcon;
    }

    public void setSmallIcon(@Nullable String string) {
        this.smallIcon = string;
    }

    @Nullable
    public String getLargeIcon() {
        return this.largeIcon;
    }

    public void setLargeIcon(@Nullable String string) {
        this.largeIcon = string;
    }

    @Nullable
    public String getBigPicture() {
        return this.bigPicture;
    }

    public void setBigPicture(@Nullable String string) {
        this.bigPicture = string;
    }

    @Nullable
    public String getSmallIconAccentColor() {
        return this.smallIconAccentColor;
    }

    public void setSmallIconAccentColor(@Nullable String string) {
        this.smallIconAccentColor = string;
    }

    @Nullable
    public String getLaunchURL() {
        return this.launchURL;
    }

    public void setLaunchURL(@Nullable String string) {
        this.launchURL = string;
    }

    @Nullable
    public String getSound() {
        return this.sound;
    }

    public void setSound(@Nullable String string) {
        this.sound = string;
    }

    @Nullable
    public String getLedColor() {
        return this.ledColor;
    }

    public void setLedColor(@Nullable String string) {
        this.ledColor = string;
    }

    public int getLockScreenVisibility() {
        return this.lockScreenVisibility;
    }

    public void setLockScreenVisibility(int n) {
        this.lockScreenVisibility = n;
    }

    @Nullable
    public String getGroupKey() {
        return this.groupKey;
    }

    public void setGroupKey(@Nullable String string) {
        this.groupKey = string;
    }

    @Nullable
    public String getGroupMessage() {
        return this.groupMessage;
    }

    public void setGroupMessage(@Nullable String string) {
        this.groupMessage = string;
    }

    @Nullable
    public List<IActionButton> getActionButtons() {
        return this.actionButtons;
    }

    public void setActionButtons(@Nullable List<? extends IActionButton> list) {
        this.actionButtons = list;
    }

    @Nullable
    public String getFromProjectNumber() {
        return this.fromProjectNumber;
    }

    public void setFromProjectNumber(@Nullable String string) {
        this.fromProjectNumber = string;
    }

    @Nullable
    public BackgroundImageLayout getBackgroundImageLayout() {
        return this.backgroundImageLayout;
    }

    public void setBackgroundImageLayout(@Nullable BackgroundImageLayout backgroundImageLayout) {
        this.backgroundImageLayout = backgroundImageLayout;
    }

    @Nullable
    public String getCollapseId() {
        return this.collapseId;
    }

    public void setCollapseId(@Nullable String string) {
        this.collapseId = string;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int n) {
        this.priority = n;
    }

    public long getSentTime() {
        return this.sentTime;
    }

    public void setSentTime(long l) {
        this.sentTime = l;
    }

    public int getTtl() {
        return this.ttl;
    }

    public void setTtl(int n) {
        this.ttl = n;
    }

    @NotNull
    public String getRawPayload() {
        return this.rawPayload;
    }

    public void setRawPayload(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.rawPayload = string;
    }

    public Notification(@NotNull JSONObject payload, @NotNull ITime time) {
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        this(null, payload, 0, time);
    }

    public Notification(@Nullable List<Notification> groupedNotifications, @NotNull JSONObject jsonPayload, int androidNotificationId, @NotNull ITime time) {
        Intrinsics.checkNotNullParameter((Object)jsonPayload, (String)"jsonPayload");
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        this.displayWaiter = new WaiterWithValue();
        this.lockScreenVisibility = 1;
        this.rawPayload = "";
        this.initPayloadData(jsonPayload, time);
        this.setGroupedNotifications(groupedNotifications);
        this.setAndroidNotificationId(androidNotificationId);
    }

    private final void initPayloadData(JSONObject currentJsonPayload, ITime time) {
        JSONObject jSONObject;
        try {
            jSONObject = NotificationHelper.INSTANCE.getCustomJSONObject(currentJsonPayload);
        }
        catch (Throwable t) {
            Logging.error((String)"Error assigning OSNotificationReceivedEvent payload values!", (Throwable)t);
            return;
        }
        JSONObject customJson = jSONObject;
        long currentTime = time.getCurrentTimeMillis();
        if (currentJsonPayload.has("google.ttl")) {
            this.setSentTime(currentJsonPayload.optLong("google.sent_time", currentTime) / (long)1000);
            this.setTtl(currentJsonPayload.optInt("google.ttl", 259200));
        } else if (currentJsonPayload.has("hms.ttl")) {
            this.setSentTime(currentJsonPayload.optLong("hms.sent_time", currentTime) / (long)1000);
            this.setTtl(currentJsonPayload.optInt("hms.ttl", 259200));
        } else {
            this.setSentTime(currentTime / (long)1000);
            this.setTtl(259200);
        }
        this.setNotificationId(JSONObjectExtensionsKt.safeString((JSONObject)customJson, (String)"i"));
        this.setTemplateId(JSONObjectExtensionsKt.safeString((JSONObject)customJson, (String)"ti"));
        this.setTemplateName(JSONObjectExtensionsKt.safeString((JSONObject)customJson, (String)"tn"));
        String string = currentJsonPayload.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"currentJsonPayload.toString()");
        this.setRawPayload(string);
        this.setAdditionalData(JSONObjectExtensionsKt.safeJSONObject((JSONObject)customJson, (String)"a"));
        this.setLaunchURL(JSONObjectExtensionsKt.safeString((JSONObject)customJson, (String)"u"));
        this.setBody(JSONObjectExtensionsKt.safeString((JSONObject)currentJsonPayload, (String)"alert"));
        this.setTitle(JSONObjectExtensionsKt.safeString((JSONObject)currentJsonPayload, (String)"title"));
        this.setSmallIcon(JSONObjectExtensionsKt.safeString((JSONObject)currentJsonPayload, (String)"sicon"));
        this.setBigPicture(JSONObjectExtensionsKt.safeString((JSONObject)currentJsonPayload, (String)"bicon"));
        this.setLargeIcon(JSONObjectExtensionsKt.safeString((JSONObject)currentJsonPayload, (String)"licon"));
        this.setSound(JSONObjectExtensionsKt.safeString((JSONObject)currentJsonPayload, (String)"sound"));
        this.setGroupKey(JSONObjectExtensionsKt.safeString((JSONObject)currentJsonPayload, (String)"grp"));
        this.setGroupMessage(JSONObjectExtensionsKt.safeString((JSONObject)currentJsonPayload, (String)"grp_msg"));
        this.setSmallIconAccentColor(JSONObjectExtensionsKt.safeString((JSONObject)currentJsonPayload, (String)"bgac"));
        this.setLedColor(JSONObjectExtensionsKt.safeString((JSONObject)currentJsonPayload, (String)"ledc"));
        String visibility = JSONObjectExtensionsKt.safeString((JSONObject)currentJsonPayload, (String)"vis");
        if (visibility != null) {
            this.setLockScreenVisibility(Integer.parseInt(visibility));
        }
        this.setFromProjectNumber(JSONObjectExtensionsKt.safeString((JSONObject)currentJsonPayload, (String)"from"));
        this.setPriority(currentJsonPayload.optInt("pri", 0));
        String collapseKey = JSONObjectExtensionsKt.safeString((JSONObject)currentJsonPayload, (String)"collapse_key");
        if (!Intrinsics.areEqual((Object)"do_not_collapse", (Object)collapseKey)) {
            this.setCollapseId(collapseKey);
        }
        try {
            this.setActionButtonsFromData();
        }
        catch (Throwable t) {
            Logging.error((String)"Error assigning OSNotificationReceivedEvent.actionButtons values!", (Throwable)t);
        }
        try {
            this.setBackgroundImageLayoutFromData(currentJsonPayload);
        }
        catch (Throwable t) {
            Logging.error((String)"Error assigning OSNotificationReceivedEvent.backgroundImageLayout values!", (Throwable)t);
        }
    }

    private final void setActionButtonsFromData() throws Throwable {
        if (this.getAdditionalData() != null) {
            JSONObject jSONObject = this.getAdditionalData();
            Intrinsics.checkNotNull((Object)jSONObject);
            if (jSONObject.has("actionButtons")) {
                JSONObject jSONObject2 = this.getAdditionalData();
                Intrinsics.checkNotNull((Object)jSONObject2);
                JSONArray jsonActionButtons = jSONObject2.getJSONArray("actionButtons");
                List actionBtns = new ArrayList();
                int n = jsonActionButtons.length();
                for (int i = 0; i < n; ++i) {
                    JSONObject jsonActionButton = jsonActionButtons.getJSONObject(i);
                    Intrinsics.checkNotNullExpressionValue((Object)jsonActionButton, (String)"jsonActionButton");
                    ActionButton actionButton = new ActionButton(JSONObjectExtensionsKt.safeString((JSONObject)jsonActionButton, (String)"id"), JSONObjectExtensionsKt.safeString((JSONObject)jsonActionButton, (String)"text"), JSONObjectExtensionsKt.safeString((JSONObject)jsonActionButton, (String)"icon"));
                    actionBtns.add(actionButton);
                }
                this.setActionButtons(actionBtns);
                JSONObject jSONObject3 = this.getAdditionalData();
                Intrinsics.checkNotNull((Object)jSONObject3);
                jSONObject3.remove("actionId");
                JSONObject jSONObject4 = this.getAdditionalData();
                Intrinsics.checkNotNull((Object)jSONObject4);
                jSONObject4.remove("actionButtons");
            }
        }
    }

    private final void setBackgroundImageLayoutFromData(JSONObject currentJsonPayload) throws Throwable {
        String jsonStrBgImage = JSONObjectExtensionsKt.safeString((JSONObject)currentJsonPayload, (String)"bg_img");
        if (jsonStrBgImage != null) {
            JSONObject jsonBgImage = new JSONObject(jsonStrBgImage);
            this.setBackgroundImageLayout(new BackgroundImageLayout(JSONObjectExtensionsKt.safeString((JSONObject)jsonBgImage, (String)"img"), JSONObjectExtensionsKt.safeString((JSONObject)jsonBgImage, (String)"tc"), JSONObjectExtensionsKt.safeString((JSONObject)jsonBgImage, (String)"bc")));
        }
    }

    public void setExtender(@Nullable NotificationCompat.Extender extender) {
        this.notificationExtender = extender;
    }

    public final boolean hasNotificationId() {
        return this.getAndroidNotificationId() != 0;
    }

    @NotNull
    public final JSONObject toJSONObject() {
        JSONObject mainObj = new JSONObject();
        try {
            mainObj.put("androidNotificationId", this.getAndroidNotificationId());
            JSONArray payloadJsonArray = new JSONArray();
            if (this.getGroupedNotifications() != null) {
                List<Notification> list = this.getGroupedNotifications();
                Intrinsics.checkNotNull(list);
                for (Notification notification : list) {
                    payloadJsonArray.put((Object)notification.toJSONObject());
                }
            }
            mainObj.put("groupedNotifications", (Object)payloadJsonArray);
            mainObj.put("notificationId", (Object)this.getNotificationId());
            mainObj.put("templateName", (Object)this.getTemplateName());
            mainObj.put("templateId", (Object)this.getTemplateId());
            mainObj.put("title", (Object)this.getTitle());
            mainObj.put("body", (Object)this.getBody());
            mainObj.put("smallIcon", (Object)this.getSmallIcon());
            mainObj.put("largeIcon", (Object)this.getLargeIcon());
            mainObj.put("bigPicture", (Object)this.getBigPicture());
            mainObj.put("smallIconAccentColor", (Object)this.getSmallIconAccentColor());
            mainObj.put("launchURL", (Object)this.getLaunchURL());
            mainObj.put("sound", (Object)this.getSound());
            mainObj.put("ledColor", (Object)this.getLedColor());
            mainObj.put("lockScreenVisibility", this.getLockScreenVisibility());
            mainObj.put("groupKey", (Object)this.getGroupKey());
            mainObj.put("groupMessage", (Object)this.getGroupMessage());
            mainObj.put("fromProjectNumber", (Object)this.getFromProjectNumber());
            mainObj.put("collapseId", (Object)this.getCollapseId());
            mainObj.put("priority", this.getPriority());
            if (this.getAdditionalData() != null) {
                mainObj.put("additionalData", (Object)this.getAdditionalData());
            }
            if (this.getActionButtons() != null) {
                JSONArray actionButtonJsonArray = new JSONArray();
                List<IActionButton> list = this.getActionButtons();
                Intrinsics.checkNotNull(list);
                for (IActionButton actionButton : list) {
                    Intrinsics.checkNotNull((Object)actionButton, (String)"null cannot be cast to non-null type com.onesignal.notifications.internal.Notification.ActionButton");
                    actionButtonJsonArray.put((Object)((ActionButton)actionButton).toJSONObject());
                }
                mainObj.put("actionButtons", (Object)actionButtonJsonArray);
            }
            mainObj.put("rawPayload", (Object)this.getRawPayload());
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return mainObj;
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("OSNotification{notificationExtender=").append(this.notificationExtender).append(", groupedNotifications=").append(this.getGroupedNotifications()).append(", androidNotificationId=").append(this.getAndroidNotificationId()).append(", notificationId='").append(this.getNotificationId()).append("', templateName='").append(this.getTemplateName()).append("', templateId='").append(this.getTemplateId()).append("', title='").append(this.getTitle()).append("', body='").append(this.getBody()).append("', additionalData=").append(this.getAdditionalData()).append(", smallIcon='").append(this.getSmallIcon()).append("', largeIcon='").append(this.getLargeIcon()).append("', bigPicture='");
        stringBuilder.append(this.getBigPicture()).append("', smallIconAccentColor='").append(this.getSmallIconAccentColor()).append("', launchURL='").append(this.getLaunchURL()).append("', sound='").append(this.getSound()).append("', ledColor='").append(this.getLedColor()).append("', lockScreenVisibility=").append(this.getLockScreenVisibility()).append(", groupKey='").append(this.getGroupKey()).append("', groupMessage='").append(this.getGroupMessage()).append("', actionButtons=").append(this.getActionButtons()).append(", fromProjectNumber='").append(this.getFromProjectNumber()).append("', backgroundImageLayout=").append(this.getBackgroundImageLayout()).append(", collapseId='").append(this.getCollapseId());
        stringBuilder.append("', priority=").append(this.getPriority()).append(", rawPayload='").append(this.getRawPayload()).append("'}");
        return stringBuilder.toString();
    }

    public void display() {
        this.displayWaiter.wake((Object)true);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B)\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u000b\u001a\u00020\fR\u0016\u0010\u0005\u001a\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0016\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\r"}, d2={"Lcom/onesignal/notifications/internal/Notification$ActionButton;", "Lcom/onesignal/notifications/IActionButton;", "id", "", "text", "icon", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getIcon", "()Ljava/lang/String;", "getId", "getText", "toJSONObject", "Lorg/json/JSONObject;", "com.onesignal.notifications"})
    public static final class ActionButton
    implements IActionButton {
        @Nullable
        private final String id;
        @Nullable
        private final String text;
        @Nullable
        private final String icon;

        public ActionButton(@Nullable String id, @Nullable String text, @Nullable String icon) {
            this.id = id;
            this.text = text;
            this.icon = icon;
        }

        public /* synthetic */ ActionButton(String string, String string2, String string3, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                string = null;
            }
            if ((n & 2) != 0) {
                string2 = null;
            }
            if ((n & 4) != 0) {
                string3 = null;
            }
            this(string, string2, string3);
        }

        @Nullable
        public String getId() {
            return this.id;
        }

        @Nullable
        public String getText() {
            return this.text;
        }

        @Nullable
        public String getIcon() {
            return this.icon;
        }

        @NotNull
        public final JSONObject toJSONObject() {
            JSONObject json = new JSONObject();
            try {
                json.put("id", (Object)this.getId());
                json.put("text", (Object)this.getText());
                json.put("icon", (Object)this.getIcon());
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            return json;
        }

        public ActionButton() {
            this(null, null, null, 7, null);
        }
    }
}

