/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal.core.internal.purchases.impl;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.IBinder;
import com.onesignal.core.internal.application.IApplicationLifecycleHandler;
import com.onesignal.core.internal.application.IApplicationService;
import com.onesignal.core.internal.config.ConfigModel;
import com.onesignal.core.internal.config.ConfigModelStore;
import com.onesignal.core.internal.operations.IOperationRepo;
import com.onesignal.core.internal.preferences.IPreferencesService;
import com.onesignal.core.internal.startup.IStartableService;
import com.onesignal.debug.internal.logging.Logging;
import com.onesignal.user.internal.identity.IdentityModel;
import com.onesignal.user.internal.identity.IdentityModelStore;
import com.onesignal.user.internal.operations.PurchaseInfo;
import com.onesignal.user.internal.operations.TrackPurchaseOperation;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 &2\u00020\u00012\u00020\u0002:\u0001&B-\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\b\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u001cH\u0016J\b\u0010\u001e\u001a\u00020\u001cH\u0002J8\u0010\u001f\u001a\u00020\u001c2\u0016\u0010 \u001a\u0012\u0012\u0004\u0012\u00020\u001a0!j\b\u0012\u0004\u0012\u00020\u001a`\"2\u0016\u0010#\u001a\u0012\u0012\u0004\u0012\u00020\u001a0!j\b\u0012\u0004\u0012\u00020\u001a`\"H\u0002J\b\u0010$\u001a\u00020\u001cH\u0016J\b\u0010%\u001a\u00020\u001cH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/onesignal/core/internal/purchases/impl/TrackGooglePurchase;", "Lcom/onesignal/core/internal/startup/IStartableService;", "Lcom/onesignal/core/internal/application/IApplicationLifecycleHandler;", "_applicationService", "Lcom/onesignal/core/internal/application/IApplicationService;", "_prefs", "Lcom/onesignal/core/internal/preferences/IPreferencesService;", "_operationRepo", "Lcom/onesignal/core/internal/operations/IOperationRepo;", "_configModelStore", "Lcom/onesignal/core/internal/config/ConfigModelStore;", "_identityModelStore", "Lcom/onesignal/user/internal/identity/IdentityModelStore;", "(Lcom/onesignal/core/internal/application/IApplicationService;Lcom/onesignal/core/internal/preferences/IPreferencesService;Lcom/onesignal/core/internal/operations/IOperationRepo;Lcom/onesignal/core/internal/config/ConfigModelStore;Lcom/onesignal/user/internal/identity/IdentityModelStore;)V", "getPurchasesMethod", "Ljava/lang/reflect/Method;", "getSkuDetailsMethod", "isWaitingForPurchasesRequest", "", "mIInAppBillingService", "", "mServiceConn", "Landroid/content/ServiceConnection;", "newAsExisting", "purchaseTokens", "", "", "onFocus", "", "onUnfocused", "queryBoughtItems", "sendPurchases", "skusToAdd", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "newPurchaseTokens", "start", "trackIAP", "Companion", "com.onesignal.core"})
public final class TrackGooglePurchase
implements IStartableService,
IApplicationLifecycleHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IApplicationService _applicationService;
    @NotNull
    private final IPreferencesService _prefs;
    @NotNull
    private final IOperationRepo _operationRepo;
    @NotNull
    private final ConfigModelStore _configModelStore;
    @NotNull
    private final IdentityModelStore _identityModelStore;
    @Nullable
    private ServiceConnection mServiceConn;
    @Nullable
    private Object mIInAppBillingService;
    @Nullable
    private Method getPurchasesMethod;
    @Nullable
    private Method getSkuDetailsMethod;
    @NotNull
    private final List<String> purchaseTokens;
    private boolean newAsExisting;
    private boolean isWaitingForPurchasesRequest;
    private static int iapEnabled = -99;
    @Nullable
    private static Class<?> iInAppBillingServiceClass;

    public TrackGooglePurchase(@NotNull IApplicationService _applicationService, @NotNull IPreferencesService _prefs, @NotNull IOperationRepo _operationRepo, @NotNull ConfigModelStore _configModelStore, @NotNull IdentityModelStore _identityModelStore) {
        Intrinsics.checkNotNullParameter((Object)_applicationService, (String)"_applicationService");
        Intrinsics.checkNotNullParameter((Object)_prefs, (String)"_prefs");
        Intrinsics.checkNotNullParameter((Object)_operationRepo, (String)"_operationRepo");
        Intrinsics.checkNotNullParameter((Object)_configModelStore, (String)"_configModelStore");
        Intrinsics.checkNotNullParameter((Object)_identityModelStore, (String)"_identityModelStore");
        this._applicationService = _applicationService;
        this._prefs = _prefs;
        this._operationRepo = _operationRepo;
        this._configModelStore = _configModelStore;
        this._identityModelStore = _identityModelStore;
        this.purchaseTokens = new ArrayList();
        this.newAsExisting = true;
    }

    @Override
    public void start() {
        if (!Companion.canTrack(this._applicationService.getAppContext())) {
            return;
        }
        try {
            String purchaseTokensString = this._prefs.getString("GTPlayerPurchases", "purchaseTokens", "[]");
            JSONArray jsonPurchaseTokens = new JSONArray(purchaseTokensString);
            int n = jsonPurchaseTokens.length();
            for (int i = 0; i < n; ++i) {
                this.purchaseTokens.add(jsonPurchaseTokens.get(i).toString());
            }
            boolean bl = this.newAsExisting = jsonPurchaseTokens.length() == 0;
            if (this.newAsExisting) {
                Boolean bl2 = this._prefs.getBool("GTPlayerPurchases", "ExistingPurchases", true);
                Intrinsics.checkNotNull((Object)bl2);
                this.newAsExisting = bl2;
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        this._applicationService.addApplicationLifecycleHandler(this);
        this.trackIAP();
    }

    @Override
    public void onFocus() {
        this.trackIAP();
    }

    @Override
    public void onUnfocused() {
    }

    private final void trackIAP() {
        if (this.mServiceConn == null) {
            ServiceConnection serviceConn2 = new ServiceConnection(this){
                final /* synthetic */ TrackGooglePurchase this$0;
                {
                    this.this$0 = $receiver;
                }

                public void onServiceDisconnected(@NotNull ComponentName name) {
                    Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                    TrackGooglePurchase.access$setIapEnabled$cp(-99);
                    TrackGooglePurchase.access$setMIInAppBillingService$p(this.this$0, null);
                }

                public void onServiceConnected(@NotNull ComponentName name, @NotNull IBinder service) {
                    Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                    Intrinsics.checkNotNullParameter((Object)service, (String)"service");
                    try {
                        Method asInterfaceMethod;
                        Class<?> stubClass = Class.forName("com.android.vending.billing.IInAppBillingService$Stub");
                        Intrinsics.checkNotNullExpressionValue(stubClass, (String)"stubClass");
                        Method method = asInterfaceMethod = com.onesignal.core.internal.purchases.impl.TrackGooglePurchase$Companion.access$getAsInterfaceMethod(TrackGooglePurchase.Companion, stubClass);
                        Intrinsics.checkNotNull((Object)method);
                        method.setAccessible(true);
                        Object[] objectArray = new Object[]{service};
                        TrackGooglePurchase.access$setMIInAppBillingService$p(this.this$0, asInterfaceMethod.invoke(null, objectArray));
                        TrackGooglePurchase.access$queryBoughtItems(this.this$0);
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
            };
            this.mServiceConn = serviceConn2;
            Intent serviceIntent = new Intent("com.android.vending.billing.InAppBillingService.BIND");
            serviceIntent.setPackage("com.android.vending");
            this._applicationService.getAppContext().getApplicationContext().bindService(serviceIntent, serviceConn2, 1);
        } else if (this.mIInAppBillingService != null) {
            this.queryBoughtItems();
        }
    }

    private final void queryBoughtItems() {
        if (this.isWaitingForPurchasesRequest) {
            return;
        }
        new Thread(() -> TrackGooglePurchase.queryBoughtItems$lambda-0(this)).start();
    }

    private final void sendPurchases(ArrayList<String> skusToAdd, ArrayList<String> newPurchaseTokens) {
        try {
            if (this.getSkuDetailsMethod == null) {
                Method method = this.getSkuDetailsMethod = TrackGooglePurchase.Companion.getGetSkuDetailsMethod(TrackGooglePurchase.iInAppBillingServiceClass);
                Intrinsics.checkNotNull((Object)method);
                method.setAccessible(true);
            }
            Bundle querySkus = new Bundle();
            querySkus.putStringArrayList("ITEM_ID_LIST", skusToAdd);
            Method method = this.getSkuDetailsMethod;
            Intrinsics.checkNotNull((Object)method);
            Object[] objectArray = new Object[]{3, this._applicationService.getAppContext().getPackageName(), "inapp", querySkus};
            Object object = method.invoke(this.mIInAppBillingService, objectArray);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.os.Bundle");
            Bundle skuDetails = (Bundle)object;
            int response = skuDetails.getInt("RESPONSE_CODE");
            if (response == 0) {
                ArrayList responseList = skuDetails.getStringArrayList("DETAILS_LIST");
                Map currentSkus = new LinkedHashMap();
                ArrayList arrayList = responseList;
                Intrinsics.checkNotNull((Object)arrayList);
                for (String thisResponse : arrayList) {
                    JSONObject responseObject = new JSONObject(thisResponse);
                    String sku = responseObject.getString("productId");
                    String iso = responseObject.getString("price_currency_code");
                    BigDecimal price = new BigDecimal(responseObject.getString("price_amount_micros"));
                    BigDecimal bigDecimal = price.divide(new BigDecimal(1000000));
                    Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"price.divide(BigDecimal(1000000))");
                    price = bigDecimal;
                    Intrinsics.checkNotNullExpressionValue((Object)sku, (String)"sku");
                    Intrinsics.checkNotNullExpressionValue((Object)iso, (String)"iso");
                    currentSkus.put(sku, new PurchaseInfo(sku, iso, price));
                }
                List purchasesToReport = new ArrayList();
                for (String sku : skusToAdd) {
                    if (!currentSkus.containsKey(sku)) continue;
                    Object v = currentSkus.get(sku);
                    Intrinsics.checkNotNull(v);
                    purchasesToReport.add(v);
                }
                if (!((Collection)purchasesToReport).isEmpty()) {
                    IOperationRepo.DefaultImpls.enqueue$default(this._operationRepo, new TrackPurchaseOperation(((ConfigModel)this._configModelStore.getModel()).getAppId(), ((IdentityModel)this._identityModelStore.getModel()).getOnesignalId(), this.newAsExisting, new BigDecimal(0), purchasesToReport), false, 2, null);
                    this.purchaseTokens.addAll((Collection<String>)newPurchaseTokens);
                    this._prefs.saveString("GTPlayerPurchases", "purchaseTokens", this.purchaseTokens.toString());
                    this._prefs.saveBool("GTPlayerPurchases", "ExistingPurchases", true);
                    this.newAsExisting = false;
                    this.isWaitingForPurchasesRequest = false;
                }
            }
        }
        catch (Throwable t) {
            Logging.warn("Failed to track IAP purchases", t);
        }
    }

    private static final void queryBoughtItems$lambda-0(TrackGooglePurchase this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.isWaitingForPurchasesRequest = true;
        try {
            if (this$0.getPurchasesMethod == null) {
                Method method = this$0.getPurchasesMethod = TrackGooglePurchase.Companion.getGetPurchasesMethod(TrackGooglePurchase.iInAppBillingServiceClass);
                Intrinsics.checkNotNull((Object)method);
                method.setAccessible(true);
            }
            Method method = this$0.getPurchasesMethod;
            Intrinsics.checkNotNull((Object)method);
            Object[] objectArray = new Object[]{3, this$0._applicationService.getAppContext().getPackageName(), "inapp", null};
            Object object = method.invoke(this$0.mIInAppBillingService, objectArray);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.os.Bundle");
            Bundle ownedItems = (Bundle)object;
            if (ownedItems.getInt("RESPONSE_CODE") == 0) {
                ArrayList<String> skusToAdd = new ArrayList<String>();
                ArrayList<String> newPurchaseTokens = new ArrayList<String>();
                ArrayList ownedSkus = ownedItems.getStringArrayList("INAPP_PURCHASE_ITEM_LIST");
                ArrayList purchaseDataList = ownedItems.getStringArrayList("INAPP_PURCHASE_DATA_LIST");
                ArrayList arrayList = purchaseDataList;
                Intrinsics.checkNotNull((Object)arrayList);
                int n = arrayList.size();
                for (int i = 0; i < n; ++i) {
                    String purchaseData = (String)purchaseDataList.get(i);
                    ArrayList arrayList2 = ownedSkus;
                    Intrinsics.checkNotNull((Object)arrayList2);
                    String sku = (String)arrayList2.get(i);
                    JSONObject itemPurchased = new JSONObject(purchaseData);
                    String purchaseToken = itemPurchased.getString("purchaseToken");
                    if (this$0.purchaseTokens.contains(purchaseToken) || newPurchaseTokens.contains(purchaseToken)) continue;
                    newPurchaseTokens.add(purchaseToken);
                    skusToAdd.add(sku);
                }
                if (skusToAdd.size() > 0) {
                    this$0.sendPurchases(skusToAdd, newPurchaseTokens);
                } else if (purchaseDataList.size() == 0) {
                    this$0.newAsExisting = false;
                    this$0._prefs.saveBool("GTPlayerPurchases", "ExistingPurchases", false);
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        this$0.isWaitingForPurchasesRequest = false;
    }

    public static final /* synthetic */ void access$setMIInAppBillingService$p(TrackGooglePurchase $this, Object object) {
        $this.mIInAppBillingService = object;
    }

    public static final /* synthetic */ void access$queryBoughtItems(TrackGooglePurchase $this) {
        $this.queryBoughtItems();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0016\u0010\u000b\u001a\u0004\u0018\u00010\f2\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u0004H\u0002J\u0018\u0010\u000e\u001a\u0004\u0018\u00010\f2\f\u0010\r\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0004H\u0002J\u0018\u0010\u000f\u001a\u0004\u0018\u00010\f2\f\u0010\r\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0004H\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/onesignal/core/internal/purchases/impl/TrackGooglePurchase$Companion;", "", "()V", "iInAppBillingServiceClass", "Ljava/lang/Class;", "iapEnabled", "", "canTrack", "", "context", "Landroid/content/Context;", "getAsInterfaceMethod", "Ljava/lang/reflect/Method;", "clazz", "getGetPurchasesMethod", "getGetSkuDetailsMethod", "com.onesignal.core"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean canTrack(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            if (iapEnabled == -99) {
                iapEnabled = context.checkCallingOrSelfPermission("com.android.vending.BILLING");
            }
            try {
                if (iapEnabled == 0) {
                    iInAppBillingServiceClass = Class.forName("com.android.vending.billing.IInAppBillingService");
                }
            }
            catch (Throwable t) {
                iapEnabled = 0;
                return false;
            }
            return iapEnabled == 0;
        }

        private final Method getAsInterfaceMethod(Class<?> clazz) {
            Method[] methodArray = clazz.getMethods();
            Intrinsics.checkNotNullExpressionValue((Object)methodArray, (String)"clazz.methods");
            for (Method method : methodArray) {
                Class<?>[] args = method.getParameterTypes();
                if (args.length != 1 || !Intrinsics.areEqual(args[0], IBinder.class)) continue;
                return method;
            }
            return null;
        }

        private final Method getGetPurchasesMethod(Class<?> clazz) {
            Class<?> clazz2 = clazz;
            Intrinsics.checkNotNull(clazz2);
            Method[] methodArray = clazz2.getMethods();
            Intrinsics.checkNotNullExpressionValue((Object)methodArray, (String)"clazz!!.methods");
            for (Method method : methodArray) {
                Class<?>[] args = method.getParameterTypes();
                if (args.length != 4 || !Intrinsics.areEqual(args[0], Integer.TYPE) || !Intrinsics.areEqual(args[1], String.class) || !Intrinsics.areEqual(args[2], String.class) || !Intrinsics.areEqual(args[3], String.class)) continue;
                return method;
            }
            return null;
        }

        private final Method getGetSkuDetailsMethod(Class<?> clazz) {
            Class<?> clazz2 = clazz;
            Intrinsics.checkNotNull(clazz2);
            Method[] methodArray = clazz2.getMethods();
            Intrinsics.checkNotNullExpressionValue((Object)methodArray, (String)"clazz!!.methods");
            for (Method method : methodArray) {
                Class<?>[] args = method.getParameterTypes();
                Class<?> returnType = method.getReturnType();
                if (args.length != 4 || !Intrinsics.areEqual(args[0], Integer.TYPE) || !Intrinsics.areEqual(args[1], String.class) || !Intrinsics.areEqual(args[2], String.class) || !Intrinsics.areEqual(args[3], Bundle.class) || !Intrinsics.areEqual(returnType, Bundle.class)) continue;
                return method;
            }
            return null;
        }

        public static final /* synthetic */ Method access$getAsInterfaceMethod(Companion $this, Class clazz) {
            return $this.getAsInterfaceMethod(clazz);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

