/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.networknt.schema.BaseJsonValidator;
import com.networknt.schema.CollectorContext;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.ValidationContext;
import com.networknt.schema.ValidationMessage;
import com.networknt.schema.ValidatorState;
import com.networknt.schema.ValidatorTypeCode;
import com.networknt.schema.regex.RegularExpression;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdditionalPropertiesValidator
extends BaseJsonValidator {
    private static final Logger logger = LoggerFactory.getLogger(AdditionalPropertiesValidator.class);
    private final boolean allowAdditionalProperties;
    private final JsonSchema additionalPropertiesSchema;
    private final Set<String> allowedProperties;
    private final List<RegularExpression> patternProperties = new ArrayList<RegularExpression>();

    public AdditionalPropertiesValidator(String schemaPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext) {
        super(schemaPath, schemaNode, parentSchema, ValidatorTypeCode.ADDITIONAL_PROPERTIES, validationContext);
        JsonNode patternPropertiesNode;
        if (schemaNode.isBoolean()) {
            this.allowAdditionalProperties = schemaNode.booleanValue();
            this.additionalPropertiesSchema = null;
        } else if (schemaNode.isObject()) {
            this.allowAdditionalProperties = true;
            this.additionalPropertiesSchema = validationContext.newSchema(this.getValidatorType().getValue(), schemaNode, parentSchema);
        } else {
            this.allowAdditionalProperties = false;
            this.additionalPropertiesSchema = null;
        }
        this.allowedProperties = new HashSet<String>();
        JsonNode propertiesNode = parentSchema.getSchemaNode().get("properties");
        if (propertiesNode != null) {
            Iterator it = propertiesNode.fieldNames();
            while (it.hasNext()) {
                this.allowedProperties.add((String)it.next());
            }
        }
        if ((patternPropertiesNode = parentSchema.getSchemaNode().get("patternProperties")) != null) {
            Iterator it = patternPropertiesNode.fieldNames();
            while (it.hasNext()) {
                this.patternProperties.add(RegularExpression.compile((String)it.next(), validationContext));
            }
        }
        this.parseErrorCode(this.getValidatorType().getErrorCodeKey());
    }

    @Override
    public Set<ValidationMessage> validate(JsonNode node, JsonNode rootNode, String at) {
        Iterator it;
        AdditionalPropertiesValidator.debug(logger, node, rootNode, at);
        CollectorContext collectorContext = CollectorContext.getInstance();
        LinkedHashSet<ValidationMessage> errors = new LinkedHashSet<ValidationMessage>();
        if (!node.isObject()) {
            return errors;
        }
        if (this.allowAdditionalProperties) {
            it = node.fieldNames();
            while (it.hasNext()) {
                collectorContext.getEvaluatedProperties().add(this.atPath(at, (String)it.next()));
            }
        }
        it = node.fieldNames();
        while (it.hasNext()) {
            String pname = (String)it.next();
            if (pname.startsWith("#")) continue;
            boolean handledByPatternProperties = false;
            for (RegularExpression pattern : this.patternProperties) {
                if (!pattern.matches(pname)) continue;
                handledByPatternProperties = true;
                break;
            }
            if (this.allowedProperties.contains(pname) || handledByPatternProperties) continue;
            if (!this.allowAdditionalProperties) {
                errors.add(this.buildValidationMessage(at, pname));
                continue;
            }
            if (this.additionalPropertiesSchema == null) continue;
            ValidatorState state = (ValidatorState)collectorContext.get("com.networknt.schema.ValidatorState");
            if (state != null && state.isWalkEnabled()) {
                errors.addAll(this.additionalPropertiesSchema.walk(node.get(pname), rootNode, this.atPath(at, pname), state.isValidationEnabled()));
                continue;
            }
            errors.addAll(this.additionalPropertiesSchema.validate(node.get(pname), rootNode, this.atPath(at, pname)));
        }
        return Collections.unmodifiableSet(errors);
    }

    @Override
    public Set<ValidationMessage> walk(JsonNode node, JsonNode rootNode, String at, boolean shouldValidateSchema) {
        if (shouldValidateSchema) {
            return this.validate(node, rootNode, at);
        }
        if (node == null || !node.isObject()) {
            return Collections.emptySet();
        }
        Iterator it = node.fieldNames();
        while (it.hasNext()) {
            ValidatorState state;
            String pname = (String)it.next();
            if (pname.startsWith("#")) continue;
            boolean handledByPatternProperties = false;
            for (RegularExpression pattern : this.patternProperties) {
                if (!pattern.matches(pname)) continue;
                handledByPatternProperties = true;
                break;
            }
            if (this.allowedProperties.contains(pname) || handledByPatternProperties || !this.allowAdditionalProperties || this.additionalPropertiesSchema == null || (state = (ValidatorState)CollectorContext.getInstance().get("com.networknt.schema.ValidatorState")) == null || !state.isWalkEnabled()) continue;
            this.additionalPropertiesSchema.walk(node.get(pname), rootNode, this.atPath(at, pname), state.isValidationEnabled());
        }
        return Collections.emptySet();
    }

    @Override
    public void preloadJsonSchema() {
        if (this.additionalPropertiesSchema != null) {
            this.additionalPropertiesSchema.initializeValidators();
        }
    }
}

