/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.adal4j;

import com.microsoft.aad.adal4j.UserInfo;
import java.io.Serializable;
import java.util.Date;

public final class AuthenticationResult
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String accessTokenType;
    private final long expiresIn;
    private final Date expiresOn;
    private final String idToken;
    private final UserInfo userInfo;
    private final String accessToken;
    private final String refreshToken;
    private final boolean isMultipleResourceRefreshToken;

    public AuthenticationResult(String accessTokenType, String accessToken, String refreshToken, long expiresIn, String idToken, UserInfo userInfo, boolean isMultipleResourceRefreshToken) {
        this.accessTokenType = accessTokenType;
        this.accessToken = accessToken;
        this.refreshToken = refreshToken;
        this.expiresIn = expiresIn;
        Date now = new Date();
        now.setTime(now.getTime() + expiresIn * 1000L);
        this.expiresOn = now;
        this.idToken = idToken;
        this.userInfo = userInfo;
        this.isMultipleResourceRefreshToken = isMultipleResourceRefreshToken;
    }

    public String getAccessTokenType() {
        return this.accessTokenType;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    @Deprecated
    public long getExpiresOn() {
        return this.expiresIn;
    }

    public long getExpiresAfter() {
        return this.expiresIn;
    }

    public Date getExpiresOnDate() {
        return this.expiresOn;
    }

    public String getIdToken() {
        return this.idToken;
    }

    public UserInfo getUserInfo() {
        return this.userInfo;
    }

    public boolean isMultipleResourceRefreshToken() {
        return this.isMultipleResourceRefreshToken;
    }
}

