/*
 * Decompiled with CFR 0.152.
 */
package com.kosprov.jargon2.internal;

import com.kosprov.jargon2.api.Jargon2;
import com.kosprov.jargon2.api.Jargon2Exception;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.text.Normalizer;
import java.util.Arrays;

public class ByteArrayImpl
implements Jargon2.ByteArray {
    private boolean cleared = false;
    Data data;
    private volatile FinalizationTrigger finalizationTrigger;

    private ByteArrayImpl(Data data) {
        this.data = data;
    }

    public ByteArrayImpl(InputStream value, int bufferSize) {
        this(new InputStreamConsumer(value, bufferSize));
    }

    @Override
    public byte[] getBytes() {
        return this.data.toByteArray();
    }

    @Override
    public void close() {
        this.clear();
    }

    @Override
    public void clear() {
        if (!this.cleared) {
            this.data.wipe();
            this.cleared = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteArrayImpl finalizable() {
        if (this.finalizationTrigger == null) {
            ByteArrayImpl byteArrayImpl = this;
            synchronized (byteArrayImpl) {
                if (this.finalizationTrigger == null) {
                    this.finalizationTrigger = new FinalizationTrigger();
                }
            }
        }
        return this;
    }

    static byte[] encode(char[] value, Charset encoding) {
        CharsetEncoder encoder = encoding.newEncoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
        byte[] bytes = new byte[(int)encoder.maxBytesPerChar() * value.length];
        encoder.reset();
        ByteBuffer bytesBuffer = ByteBuffer.wrap(bytes);
        CharBuffer charBuffer = CharBuffer.wrap(value);
        try {
            byte[] output;
            CoderResult result = encoder.encode(charBuffer, bytesBuffer, true);
            if (!result.isUnderflow()) {
                result.throwException();
            }
            if (!(result = encoder.flush(bytesBuffer)).isUnderflow()) {
                result.throwException();
            }
            if (bytes.length == bytesBuffer.position()) {
                output = bytes;
            } else {
                output = Arrays.copyOf(bytes, bytesBuffer.position());
                Arrays.fill(bytes, (byte)0);
            }
            return output;
        }
        catch (CharacterCodingException e) {
            Arrays.fill(bytes, (byte)0);
            throw new Jargon2Exception("Failed to encode value to " + encoding.displayName());
        }
    }

    public static class ClearableSourceCharSeqByteArrayImpl
    extends CharSeqByteArrayImpl
    implements Jargon2.ClearableSourceCharSeqByteArray {
        boolean clearSource;
        char[] chars;

        public ClearableSourceCharSeqByteArrayImpl(char[] value, Charset encoding) {
            super(Arrays.copyOf(value, value.length), encoding);
            this.chars = value;
        }

        @Override
        public ClearableSourceCharSeqByteArrayImpl clearSource() {
            return this.clearSource(true);
        }

        @Override
        public ClearableSourceCharSeqByteArrayImpl clearSource(boolean clear) {
            this.clearSource = clear;
            return this;
        }

        @Override
        public void clear() {
            if (this.clearSource) {
                Arrays.fill(this.chars, '\u0000');
            }
            super.clear();
        }

        @Override
        public ClearableSourceCharSeqByteArrayImpl encoding(String encoding) {
            return (ClearableSourceCharSeqByteArrayImpl)super.encoding(encoding);
        }

        @Override
        public ClearableSourceCharSeqByteArrayImpl encoding(Charset encoding) {
            return (ClearableSourceCharSeqByteArrayImpl)super.encoding(encoding);
        }

        @Override
        public ClearableSourceCharSeqByteArrayImpl normalize() {
            return (ClearableSourceCharSeqByteArrayImpl)super.normalize();
        }

        @Override
        public ClearableSourceCharSeqByteArrayImpl normalize(Jargon2.Normalization normalization) {
            return (ClearableSourceCharSeqByteArrayImpl)super.normalize(normalization);
        }

        @Override
        public ClearableSourceCharSeqByteArrayImpl finalizable() {
            return (ClearableSourceCharSeqByteArrayImpl)super.finalizable();
        }
    }

    public static class ClearableSourceByteArrayImpl
    extends ByteArrayImpl
    implements Jargon2.ClearableSourceByteArray {
        boolean clearSource;
        byte[] bytes;

        public ClearableSourceByteArrayImpl(byte[] value) {
            super(new ByteArrayData(Arrays.copyOf(value, value.length)));
            this.bytes = value;
        }

        @Override
        public ClearableSourceByteArrayImpl clearSource() {
            return this.clearSource(true);
        }

        @Override
        public ClearableSourceByteArrayImpl clearSource(boolean clear) {
            this.clearSource = clear;
            return this;
        }

        @Override
        public void clear() {
            if (this.clearSource) {
                Arrays.fill(this.bytes, (byte)0);
            }
            super.clear();
        }

        @Override
        public ClearableSourceByteArrayImpl finalizable() {
            return (ClearableSourceByteArrayImpl)super.finalizable();
        }
    }

    public static class CharSeqByteArrayImpl
    extends ByteArrayImpl
    implements Jargon2.CharSeqByteArray {
        public CharSeqByteArrayImpl(char[] value, Charset encoding) {
            super(new CharArrayData(value, encoding, null));
        }

        public CharSeqByteArrayImpl(String value, Charset encoding) {
            this(value.toCharArray(), encoding);
        }

        public CharSeqByteArrayImpl(Reader value, int bufferSize, Charset encoding) {
            super(new ReaderConsumer(value, bufferSize, encoding, null));
        }

        @Override
        public CharSeqByteArrayImpl encoding(String encoding) {
            return this.encoding(Charset.forName(encoding));
        }

        @Override
        public CharSeqByteArrayImpl encoding(Charset encoding) {
            this.data = ((CharSeqData)this.data).withEncoding(encoding);
            return this;
        }

        @Override
        public CharSeqByteArrayImpl normalize() {
            return this.normalize(Jargon2.DEFAULT_NORMALIZED_FORM);
        }

        @Override
        public CharSeqByteArrayImpl normalize(Jargon2.Normalization normalization) {
            this.data = ((CharSeqData)this.data).withNormalization(normalization);
            return this;
        }

        @Override
        public CharSeqByteArrayImpl finalizable() {
            return (CharSeqByteArrayImpl)super.finalizable();
        }
    }

    static class ReaderConsumer
    extends Consumer<Reader, CharArrayData>
    implements CharSeqData {
        Charset encoding;
        Jargon2.Normalization normalization;

        ReaderConsumer(Reader stream, int bufferSize, Charset encoding, Jargon2.Normalization normalization) {
            super(stream, bufferSize);
            this.encoding = encoding;
            this.normalization = normalization;
        }

        @Override
        int read(CharArrayData target, int offset) throws IOException {
            return ((Reader)this.stream).read(target.chars, offset, this.bufferSize);
        }

        @Override
        CharArrayData create(int length) {
            return new CharArrayData(new char[length], this.encoding, this.normalization);
        }

        @Override
        public CharSeqData withEncoding(Charset encoding) {
            return new ReaderConsumer((Reader)this.stream, this.bufferSize, encoding, this.normalization);
        }

        @Override
        public CharSeqData withNormalization(Jargon2.Normalization normalization) {
            return new ReaderConsumer((Reader)this.stream, this.bufferSize, this.encoding, normalization);
        }
    }

    static class InputStreamConsumer
    extends Consumer<InputStream, ByteArrayData> {
        InputStreamConsumer(InputStream stream, int bufferSize) {
            super(stream, bufferSize);
        }

        @Override
        int read(ByteArrayData target, int offset) throws IOException {
            return ((InputStream)this.stream).read(target.bytes, offset, this.bufferSize);
        }

        @Override
        ByteArrayData create(int length) {
            return new ByteArrayData(new byte[length]);
        }
    }

    static abstract class Consumer<T, E extends ExtendedData<E>>
    implements Data {
        T stream;
        int bufferSize;
        byte[] bytes;

        Consumer(T stream, int bufferSize) {
            this.stream = stream;
            this.bufferSize = bufferSize;
        }

        abstract int read(E var1, int var2) throws IOException;

        abstract E create(int var1);

        @Override
        public byte[] toByteArray() {
            if (this.bytes == null) {
                Object copy;
                E data = this.create(this.bufferSize);
                int offset = 0;
                int total = 0;
                do {
                    try {
                        int dataRead = this.read(data, offset);
                        if (dataRead != -1) {
                            total += dataRead;
                        }
                        if (dataRead < this.bufferSize) {
                            if (total > 0) {
                                copy = (ExtendedData)data.copyAndWipe(total);
                                continue;
                            }
                            copy = this.create(0);
                            continue;
                        }
                        copy = (ExtendedData)data.copyAndWipe(data.length() + this.bufferSize);
                        offset += this.bufferSize;
                    }
                    catch (IOException e) {
                        data.wipe();
                        throw new Jargon2Exception("Could not consume stream");
                    }
                } while ((data = copy).length() != total);
                this.bytes = data.toByteArray();
            }
            return this.bytes;
        }

        @Override
        public void wipe() {
            if (this.bytes != null) {
                Arrays.fill(this.bytes, (byte)0);
            }
        }
    }

    static class CharArrayData
    implements ExtendedData<CharArrayData>,
    CharSeqData {
        char[] chars;
        byte[] bytes;
        Charset encoding;
        Jargon2.Normalization normalization;

        CharArrayData(char[] chars, Charset encoding, Jargon2.Normalization normalization) {
            this.chars = chars;
            this.encoding = encoding;
            this.normalization = normalization;
        }

        @Override
        public int length() {
            return this.chars.length;
        }

        @Override
        public CharArrayData copyAndWipe(int length) {
            try {
                CharArrayData charArrayData = new CharArrayData(Arrays.copyOf(this.chars, length), this.encoding, this.normalization);
                return charArrayData;
            }
            finally {
                this.wipe();
            }
        }

        @Override
        public void wipe() {
            Arrays.fill(this.chars, '\u0000');
            if (this.bytes != null) {
                Arrays.fill(this.bytes, (byte)0);
            }
        }

        @Override
        public byte[] toByteArray() {
            if (this.bytes == null) {
                char[] c = this.chars;
                if (this.normalization != null) {
                    c = Normalizer.normalize(CharBuffer.wrap(this.chars), Normalizer.Form.valueOf(this.normalization.name())).toCharArray();
                }
                this.bytes = ByteArrayImpl.encode(c, this.encoding);
            }
            return this.bytes;
        }

        @Override
        public CharSeqData withEncoding(Charset encoding) {
            return new CharArrayData(this.chars, encoding, this.normalization);
        }

        @Override
        public CharSeqData withNormalization(Jargon2.Normalization normalization) {
            return new CharArrayData(this.chars, this.encoding, normalization);
        }
    }

    static class ByteArrayData
    implements ExtendedData<ByteArrayData> {
        byte[] bytes;

        ByteArrayData(byte[] bytes) {
            this.bytes = bytes;
        }

        @Override
        public int length() {
            return this.bytes.length;
        }

        @Override
        public ByteArrayData copyAndWipe(int length) {
            try {
                ByteArrayData byteArrayData = new ByteArrayData(Arrays.copyOf(this.bytes, length));
                return byteArrayData;
            }
            finally {
                this.wipe();
            }
        }

        @Override
        public void wipe() {
            Arrays.fill(this.bytes, (byte)0);
        }

        @Override
        public byte[] toByteArray() {
            return this.bytes;
        }
    }

    static interface ExtendedData<E>
    extends Data {
        public int length();

        public E copyAndWipe(int var1);
    }

    static interface CharSeqData
    extends Data {
        public CharSeqData withEncoding(Charset var1);

        public CharSeqData withNormalization(Jargon2.Normalization var1);
    }

    static interface Data {
        public void wipe();

        public byte[] toByteArray();
    }

    private class FinalizationTrigger {
        private FinalizationTrigger() {
        }

        protected void finalize() {
            ByteArrayImpl.this.clear();
        }
    }
}

