/*
 * Decompiled with CFR 0.152.
 */
package kong.unirest.core;

import java.io.File;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import kong.unirest.core.BaseRequest;
import kong.unirest.core.Body;
import kong.unirest.core.Config;
import kong.unirest.core.ContentType;
import kong.unirest.core.HttpMethod;
import kong.unirest.core.HttpRequestMultiPart;
import kong.unirest.core.HttpRequestUniBody;
import kong.unirest.core.HttpRequestWithBody;
import kong.unirest.core.JsonNode;
import kong.unirest.core.MultipartBody;
import kong.unirest.core.RequestBodyEntity;
import kong.unirest.core.json.JSONElement;

class HttpRequestBody
extends BaseRequest<HttpRequestWithBody>
implements HttpRequestWithBody {
    private Charset charSet = StandardCharsets.UTF_8;

    public HttpRequestBody(Config config, HttpMethod method, String url) {
        super(config, method, url);
    }

    public HttpRequestBody(HttpRequestBody baseRequest) {
        super(baseRequest);
        this.charSet = baseRequest.getCharset();
    }

    @Override
    public MultipartBody field(String name, Collection<?> value) {
        return new HttpRequestMultiPart(this).field(name, value);
    }

    @Override
    public MultipartBody field(String name, File file) {
        return this.field(name, file, null);
    }

    @Override
    public MultipartBody field(String name, File file, String contentType) {
        return new HttpRequestMultiPart(this).field(name, file, contentType);
    }

    @Override
    public MultipartBody field(String name, Object value) {
        return this.field(name, value, null);
    }

    @Override
    public MultipartBody field(String name, Object value, String contentType) {
        return new HttpRequestMultiPart(this).field(name, value, contentType);
    }

    @Override
    public MultipartBody fields(Map<String, Object> parameters) {
        return new HttpRequestMultiPart(this).fields(parameters);
    }

    @Override
    public MultipartBody field(String name, InputStream stream, ContentType contentType, String fileName) {
        return new HttpRequestMultiPart(this).field(name, stream, contentType, fileName);
    }

    @Override
    public MultipartBody multiPartContent() {
        return new HttpRequestMultiPart(this).forceMultiPart(true);
    }

    @Override
    public MultipartBody field(String name, InputStream stream, String fileName) {
        return this.field(name, stream, ContentType.APPLICATION_OCTET_STREAM, fileName);
    }

    @Override
    public HttpRequestBody charset(Charset charset) {
        this.charSet = charset;
        return this;
    }

    @Override
    public RequestBodyEntity body(JsonNode body) {
        return this.body(body.toString());
    }

    @Override
    public RequestBodyEntity body(String body) {
        return new HttpRequestUniBody(this).body(body);
    }

    @Override
    public RequestBodyEntity body(InputStream body) {
        return new HttpRequestUniBody(this).body(body);
    }

    @Override
    public RequestBodyEntity body(Object body) {
        return new HttpRequestUniBody(this).body(body);
    }

    @Override
    public RequestBodyEntity body(byte[] body) {
        return new HttpRequestUniBody(this).body(body);
    }

    @Override
    public RequestBodyEntity body(JSONElement body) {
        return this.body(body.toString());
    }

    @Override
    public Charset getCharset() {
        return this.charSet;
    }

    @Override
    public HttpRequestWithBody contentType(String type) {
        this.headers.add("Content-Type", type);
        return this;
    }

    @Override
    public Optional<Body> getBody() {
        return Optional.empty();
    }
}

