/*
 * Decompiled with CFR 0.152.
 */
package kong.unirest.core;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import kong.unirest.core.BaseResponse;
import kong.unirest.core.MonitoringInputStream;
import kong.unirest.core.ProgressMonitor;
import kong.unirest.core.RawResponse;
import kong.unirest.core.UnirestException;

public class ByteResponse
extends BaseResponse<byte[]> {
    private final byte[] body;

    public ByteResponse(RawResponse r, ProgressMonitor downloadMonitor) {
        super(r);
        if (downloadMonitor == null) {
            this.body = r.getContentAsBytes();
        } else {
            MonitoringInputStream ip = new MonitoringInputStream(r.getContent(), downloadMonitor, (String)null, r);
            try {
                this.body = ByteResponse.getBytes(ip);
            }
            catch (IOException e) {
                throw new UnirestException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getBytes(InputStream is) throws IOException {
        try {
            byte[] buf;
            int size = 1024;
            if (is instanceof ByteArrayInputStream) {
                size = is.available();
                buf = new byte[size];
                int len = is.read(buf, 0, size);
            } else {
                int len;
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                buf = new byte[size];
                while ((len = is.read(buf, 0, size)) != -1) {
                    bos.write(buf, 0, len);
                }
                buf = bos.toByteArray();
            }
            byte[] byArray = buf;
            return byArray;
        }
        finally {
            is.close();
        }
    }

    public static boolean isGzipped(String value) {
        return "gzip".equalsIgnoreCase(value.toLowerCase().trim());
    }

    @Override
    public byte[] getBody() {
        return this.body;
    }

    @Override
    protected String getRawBody() {
        return null;
    }
}

