/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.hickory.prism.internal;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import net.java.dev.hickory.prism.internal.GeneratePrismPrism;
import net.java.dev.hickory.prism.internal.GeneratePrismsPrism;

@SupportedAnnotationTypes(value={"net.java.dev.hickory.prism.GeneratePrism", "net.java.dev.hickory.prism.GeneratePrisms"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_6)
public class PrismGenerator
extends AbstractProcessor {
    private Map<String, TypeMirror> generated = new HashMap<String, TypeMirror>();
    List<DeclaredType> inners = new ArrayList<DeclaredType>();

    @Override
    public boolean process(Set<? extends TypeElement> tes, RoundEnvironment renv) {
        Object ann;
        if (renv.processingOver()) {
            return true;
        }
        TypeElement a = this.processingEnv.getElementUtils().getTypeElement("net.java.dev.hickory.prism.GeneratePrism");
        TypeElement as = this.processingEnv.getElementUtils().getTypeElement("net.java.dev.hickory.prism.GeneratePrisms");
        for (Element element : renv.getElementsAnnotatedWith(a)) {
            ann = GeneratePrismPrism.getInstanceOn(element);
            if (!((GeneratePrismPrism)ann).isValid) continue;
            this.generateIfNew((GeneratePrismPrism)ann, element, Collections.<DeclaredType, String>emptyMap());
        }
        for (Element element : renv.getElementsAnnotatedWith(as)) {
            ann = GeneratePrismsPrism.getInstanceOn(element);
            if (!((GeneratePrismsPrism)ann).isValid) continue;
            HashMap<DeclaredType, String> otherPrisms = new HashMap<DeclaredType, String>();
            for (GeneratePrismPrism inner : ((GeneratePrismsPrism)ann).value()) {
                String name = this.getPrismName(inner);
                otherPrisms.put((DeclaredType)inner.value(), this.getPrismName(inner));
            }
            for (GeneratePrismPrism inner : ((GeneratePrismsPrism)ann).value()) {
                this.generateIfNew(inner, element, otherPrisms);
            }
        }
        return false;
    }

    private String getPrismName(GeneratePrismPrism ann) {
        String name = ann.name();
        if (name.equals("")) {
            name = ((DeclaredType)ann.value()).asElement().getSimpleName() + "Prism";
        }
        return name;
    }

    private void generateIfNew(GeneratePrismPrism ann, Element e, Map<DeclaredType, String> otherPrisms) {
        String prismFqn;
        String name = this.getPrismName(ann);
        String packageName = this.getPackageName(e);
        if ("unnamed package".equals(packageName)) {
            packageName = "";
        }
        String string = prismFqn = packageName.equals("") ? name : packageName + "." + name;
        if (this.generated.containsKey(prismFqn)) {
            if (((Object)this.generated.get(prismFqn)).equals(ann.value())) {
                return;
            }
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, String.format("%s has already been generated for %s", prismFqn, this.generated.get(prismFqn)), e, ann.mirror);
            return;
        }
        this.generatePrism(name, packageName, (DeclaredType)ann.value(), ann.publicAccess() != false ? "public " : "", otherPrisms);
        this.generated.put(prismFqn, ann.value());
    }

    private String getPackageName(Element e) {
        while (e.getKind() != ElementKind.PACKAGE) {
            e = e.getEnclosingElement();
        }
        return ((PackageElement)e).getQualifiedName().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generatePrism(String name, String packageName, DeclaredType typeMirror, String access, Map<DeclaredType, String> otherPrisms) {
        this.inners.clear();
        String prismFqn = packageName.equals("") ? name : packageName + "." + name;
        PrintWriter out = null;
        try {
            out = new PrintWriter(this.processingEnv.getFiler().createSourceFile(prismFqn, new Element[0]).openWriter());
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        try {
            if (!packageName.equals("")) {
                out.format("package %s;%n", packageName);
            }
            out.format("import java.util.ArrayList;%n", new Object[0]);
            out.format("import java.util.List;%n", new Object[0]);
            out.format("import java.util.Map;%n", new Object[0]);
            out.format("import javax.lang.model.element.AnnotationMirror;%n", new Object[0]);
            out.format("import javax.lang.model.element.Element;%n", new Object[0]);
            out.format("import javax.lang.model.element.VariableElement;%n", new Object[0]);
            out.format("import javax.lang.model.element.AnnotationValue;%n", new Object[0]);
            out.format("import javax.lang.model.type.TypeMirror;%n", new Object[0]);
            out.format("import net.java.dev.hickory.prism.internal.*;%n", new Object[0]);
            out.format("import java.util.HashMap;%n", new Object[0]);
            out.format("import javax.lang.model.element.ExecutableElement;%n", new Object[0]);
            out.format("import javax.lang.model.element.TypeElement;%n", new Object[0]);
            out.format("import javax.lang.model.util.ElementFilter;%n", new Object[0]);
            String annName = ((TypeElement)typeMirror.asElement()).getQualifiedName().toString();
            out.format("/** A Prism representing an {@code @%s} annotation. %n", annName);
            out.format("  */ %n", new Object[0]);
            out.format("%sclass %s {%n", access, name);
            this.generateClassBody("", out, name, name, typeMirror, access, otherPrisms);
            for (int n = 0; n < this.inners.size(); ++n) {
                DeclaredType next = this.inners.get(n);
                String innerName = next.asElement().getSimpleName().toString();
                String forName = ((TypeElement)typeMirror.asElement()).getQualifiedName().toString();
                out.format("    %sstatic class %s {%n", access, innerName);
                this.generateClassBody("    ", out, name, innerName, next, access, otherPrisms);
                out.format("    }%n", new Object[0]);
            }
            this.generateStaticMembers(out);
            out.format("}%n", new Object[0]);
        }
        finally {
            out.close();
        }
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, String.format("Generated prism %s for @%s", prismFqn, typeMirror));
    }

    private void generateClassBody(String indent, PrintWriter out, String outerName, String name, DeclaredType typeMirror, String access, Map<DeclaredType, String> otherPrisms) {
        boolean inner;
        ArrayList<PrismWriter> writers = new ArrayList<PrismWriter>();
        for (ExecutableElement m : ElementFilter.methodsIn(typeMirror.asElement().getEnclosedElements())) {
            writers.add(this.getWriter(m, access, otherPrisms));
        }
        for (PrismWriter w : writers) {
            w.writeField(indent, out);
        }
        String annName = ((TypeElement)typeMirror.asElement()).getQualifiedName().toString();
        out.format("%s    /**%n", indent);
        out.format("%s      * An instance of the Values inner class whose%n", indent);
        out.format("%s      * methods return the AnnotationValues used to build this prism. %n", indent);
        out.format("%s      * Primarily intended to support using Messager.%n", indent);
        out.format("%s      */%n", indent);
        out.format("%s    %sfinal Values values;\n", indent, access);
        boolean bl = inner = !indent.equals("");
        if (!inner) {
            out.format("%s    /** Return a prism representing the {@code @%s} annotation on 'e'. %n", indent, annName);
            out.format("%s      * similar to {@code e.getAnnotation(%s.class)} except that %n", indent, annName);
            out.format("%s      * an instance of this class rather than an instance of {@code %s}%n", indent, annName);
            out.format("%s      * is returned.%n", indent);
            out.format("%s      */%n", indent);
            out.format("%s    %sstatic %s getInstanceOn(Element e) {%n", indent, access, name);
            out.format("%s        AnnotationMirror m = getMirror(\"%s\",e);%n", indent, ((TypeElement)typeMirror.asElement()).getQualifiedName());
            out.format("%s        if(m == null) return null;%n", indent);
            out.format("%s        return getInstance(m);%n", indent);
            out.format("%s   }%n%n", indent);
        }
        out.format("%s    /** Return a prism of the {@code @%s} annotation whose mirror is mirror. %n", indent, annName);
        out.format("%s      */%n", indent);
        out.format("%s    %sstatic %s getInstance(AnnotationMirror mirror) {%n", indent, inner ? "private " : access, name);
        out.format("%s        return new %s(mirror);%n", indent, name);
        out.format("%s    }%n%n", indent);
        out.format("%s    private %s(AnnotationMirror mirror) {%n", indent, name);
        out.print("        for(ExecutableElement key : mirror.getElementValues().keySet()) {\n            memberValues.put(key.getSimpleName().toString(),mirror.getElementValues().get(key));\n        }\n        for(ExecutableElement member : ElementFilter.methodsIn(mirror.getAnnotationType().asElement().getEnclosedElements())) {\n            defaults.put(member.getSimpleName().toString(),member.getDefaultValue());\n        }\n");
        for (PrismWriter w : writers) {
            w.writeInitializer(indent, out);
        }
        out.format("%s        this.values = new Values(memberValues);%n", indent);
        out.format("%s        this.mirror = mirror;%n", indent);
        out.format("%s        this.isValid = valid;%n", indent);
        out.format("%s    }%n%n", indent);
        for (PrismWriter w : writers) {
            w.writeMethod(indent, out);
        }
        out.format("%s    /**%n", indent);
        out.format("%s      * Determine whether the underlying AnnotationMirror has no errors.%n", indent);
        out.format("%s      * True if the underlying AnnotationMirror has no errors.%n", indent);
        out.format("%s      * When true is returned, none of the methods will return null.%n", indent);
        out.format("%s      * When false is returned, a least one member will either return null, or another%n", indent);
        out.format("%s      * prism that is not valid.%n", indent);
        out.format("%s      */%n", indent);
        out.format("%s    %sfinal boolean isValid;%n", indent, access);
        out.format("%s    %n", indent);
        out.format("%s    /**%n", indent);
        out.format("%s      * The underlying AnnotationMirror of the annotation%n", indent);
        out.format("%s      * represented by this Prism. %n", indent);
        out.format("%s      * Primarily intended to support using Messager.%n", indent);
        out.format("%s      */%n", indent);
        out.format("%s    %sfinal AnnotationMirror mirror;%n", indent, access);
        out.format("%s    /**%n", indent);
        out.format("%s      * A class whose members corespond to those of %s%n", indent, annName);
        out.format("%s      * but which each return the AnnotationValue corresponding to%n", indent);
        out.format("%s      * that member in the model of the annotations. Returns null for%n", indent);
        out.format("%s      * defaulted members. Used for Messager, so default values are not useful.%n", indent);
        out.format("%s      */%n", indent);
        out.format("%s    %sstatic class Values {%n", indent, access);
        out.format("%s       private Map<String,AnnotationValue> values;%n", indent);
        out.format("%s       private Values(Map<String,AnnotationValue> values) {%n", indent);
        out.format("%s           this.values = values;%n", indent);
        out.format("%s       }    %n", indent);
        for (PrismWriter w : writers) {
            out.format("%s       /** Return the AnnotationValue corresponding to the %s() %n", indent, w.name);
            out.format("%s         * member of the annotation, or null when the default value is implied.%n", indent);
            out.format("%s         */%n", indent);
            out.format("%s       %sAnnotationValue %s(){ return values.get(\"%s\");}%n", indent, access, w.name, w.name);
        }
        out.format("%s    }%n", indent);
        this.generateFixedClassContent(indent, out, outerName);
    }

    private PrismWriter getWriter(ExecutableElement m, String access, Map<DeclaredType, String> otherPrisms) {
        Elements elements = this.processingEnv.getElementUtils();
        Types types = this.processingEnv.getTypeUtils();
        WildcardType q = types.getWildcardType(null, null);
        DeclaredType enumType = types.getDeclaredType(elements.getTypeElement("java.lang.Enum"), q);
        TypeMirror typem = m.getReturnType();
        PrismWriter result = null;
        if (typem.getKind() == TypeKind.ARRAY) {
            typem = ((ArrayType)typem).getComponentType();
            result = new PrismWriter(m, true, access);
        } else {
            result = new PrismWriter(m, false, access);
        }
        if (typem.getKind().isPrimitive()) {
            String typeName = types.boxedClass((PrimitiveType)typem).getSimpleName().toString();
            result.setMirrorType(typeName);
            result.setPrismType(typeName);
        } else if (typem.getKind() == TypeKind.DECLARED) {
            DeclaredType type = (DeclaredType)typem;
            if (types.isSameType(type, elements.getTypeElement("java.lang.String").asType())) {
                result.setMirrorType("String");
                result.setPrismType("String");
            } else if (((Object)type.asElement()).equals(elements.getTypeElement("java.lang.Class"))) {
                result.setMirrorType("TypeMirror");
                result.setPrismType("TypeMirror");
            } else if (types.isSubtype(type, enumType)) {
                result.setMirrorType("VariableElement");
                result.setPrismType("String");
                result.setM2pFormat("%s.getSimpleName().toString()");
            } else if (types.isSubtype(type, elements.getTypeElement("java.lang.annotation.Annotation").asType())) {
                result.setMirrorType("AnnotationMirror");
                DeclaredType annType = type;
                String prismName = null;
                for (DeclaredType other : otherPrisms.keySet()) {
                    if (!types.isSameType(other, annType)) continue;
                    prismName = otherPrisms.get(other);
                    break;
                }
                if (prismName != null) {
                    result.setPrismType(prismName);
                    result.setM2pFormat(prismName + ".getInstance(%s)");
                } else {
                    String prismType = annType.asElement().getSimpleName().toString();
                    result.setPrismType(prismType);
                    result.setM2pFormat(prismType + ".getInstance(%s)");
                    if (!this.inners.contains(type)) {
                        this.inners.add(type);
                    }
                }
            } else {
                System.out.format("Unprocessed type %s", type);
            }
        }
        return result;
    }

    private void generateStaticMembers(PrintWriter out) {
        out.print("    private static AnnotationMirror getMirror(String fqn, Element target) {\n        for (AnnotationMirror m :target.getAnnotationMirrors()) {\n            CharSequence mfqn = ((TypeElement)m.getAnnotationType().asElement()).getQualifiedName();\n            if(fqn.contentEquals(mfqn)) return m;\n        }\n        return null;\n    }\n    private static <T> T getValue(Map<String,AnnotationValue> memberValues, Map<String,AnnotationValue> defaults, String name, Class<T> clazz) {\n        AnnotationValue av = memberValues.get(name);\n        if(av == null) av = defaults.get(name);\n        if(av == null) {\n            return null;\n        }\n        if(clazz.isInstance(av.getValue())) return clazz.cast(av.getValue());\n        return null;\n    }\n    private static <T> List<T> getArrayValues(Map<String,AnnotationValue> memberValues, Map<String,AnnotationValue> defaults, String name, final Class<T> clazz) {\n        AnnotationValue av = memberValues.get(name);\n        if(av == null) av = defaults.get(name);\n        if(av == null) {\n            return null;\n        }\n        if(av.getValue() instanceof List) {\n            List<T> result = new ArrayList<T>();\n            for(AnnotationValue v : getValueAsList(av)) {\n                if(clazz.isInstance(v.getValue())) {\n                    result.add(clazz.cast(v.getValue()));\n                } else{\n                    return null;\n                }\n            }\n            return result;\n        } else {\n            return null;\n        }\n    }\n    @SuppressWarnings(\"unchecked\")\n    private static List<AnnotationValue> getValueAsList(AnnotationValue av) {\n        return (List<AnnotationValue>)av.getValue();\n    }\n");
    }

    private void generateFixedClassContent(String indent, PrintWriter out, String outerName) {
        out.format("%s    private Map<String,AnnotationValue> defaults = new HashMap<String,AnnotationValue>(10);%n", indent);
        out.format("%s    private Map<String,AnnotationValue> memberValues = new HashMap<String,AnnotationValue>(10);%n", indent);
        out.format("%s    private boolean valid = true;%n", indent);
        out.format("%n", new Object[0]);
        out.format("%s    private <T> T getValue(String name, Class<T> clazz) {%n", indent);
        out.format("%s        T result = %s.getValue(memberValues,defaults,name,clazz);%n", indent, outerName);
        out.format("%s        if(result == null) valid = false;%n", indent);
        out.format("%s        return result;%n", indent);
        out.format("%s    } %n", indent);
        out.format("%n", new Object[0]);
        out.format("%s    private <T> List<T> getArrayValues(String name, final Class<T> clazz) {%n", indent);
        out.format("%s        List<T> result = %s.getArrayValues(memberValues,defaults,name,clazz);%n", indent, outerName);
        out.format("%s        if(result == null) valid = false;%n", indent);
        out.format("%s        return result;%n", indent);
        out.format("%s    }%n", indent);
    }

    private class PrismWriter {
        String name;
        String mirrorType;
        String prismType;
        boolean arrayed;
        ExecutableElement m;
        String access;
        String m2pFormat = "undefinedConverter(%s)";

        PrismWriter(ExecutableElement m, boolean arrayed, String access) {
            this.m = m;
            this.arrayed = arrayed;
            this.access = access;
            this.name = m.getSimpleName().toString();
        }

        public void setPrismType(String prismType) {
            this.prismType = prismType;
        }

        public void setMirrorType(String mirrorType) {
            this.mirrorType = mirrorType;
        }

        void writeField(String indent, PrintWriter out) {
            out.format("%s    /** store prism value of %s */%n", indent, this.name);
            if (this.arrayed) {
                out.format("%s    private List<%s> _%s;%n%n", indent, this.prismType, this.name);
            } else {
                out.format("%s    private %s _%s;%n%n", indent, this.prismType, this.name);
            }
        }

        String mirror2prism(String expr) {
            return String.format(this.m2pFormat, expr);
        }

        public void setM2pFormat(String m2pFormat) {
            this.m2pFormat = m2pFormat;
        }

        void writeInitializer(String indent, PrintWriter out) {
            if (this.arrayed) {
                if (this.mirrorType.equals(this.prismType)) {
                    out.format("%s        _%s = getArrayValues(\"%s\",%s.class);%n", indent, this.name, this.name, this.prismType);
                } else {
                    out.format("%s        List<%s> %sMirrors = getArrayValues(\"%s\",%s.class);%n", indent, this.mirrorType, this.name, this.name, this.mirrorType);
                    out.format("%s         _%s = new ArrayList<%s>(%sMirrors.size());%n", indent, this.name, this.prismType, this.name);
                    out.format("%s        for(%s %sMirror : %sMirrors) {%n", indent, this.mirrorType, this.name, this.name);
                    out.format("%s            _%s.add(%s);%n", indent, this.name, this.mirror2prism(this.name + "Mirror"));
                    out.format("%s        }%n", indent);
                }
            } else if (this.mirrorType.equals(this.prismType)) {
                out.format("%s        _%s = getValue(\"%s\",%s.class);%n", indent, this.name, this.name, this.prismType);
            } else {
                out.format("%s        %s %sMirror = getValue(\"%s\",%s.class);%n", indent, this.mirrorType, this.name, this.name, this.mirrorType);
                out.format("%s        valid = valid && %sMirror != null;%n", indent, this.name);
                out.format("%s        _%s = %sMirror == null ? null : %s;%n", indent, this.name, this.name, this.mirror2prism(this.name + "Mirror"));
            }
        }

        void writeMethod(String indent, PrintWriter out) {
            if (this.arrayed) {
                out.format("%s    /** %n", indent);
                out.format("%s      * Returns a List<%s> representing the value of the {@code %s} member of the Annotation.%n", indent, this.prismType, this.m);
                out.format("%s      * @see %s#%s()%n", indent, ((TypeElement)this.m.getEnclosingElement()).getQualifiedName(), this.name);
                out.format("%s      */ %n", indent);
                out.format("%s    %sList<%s> %s() { return _%s; }%n%n", indent, this.access, this.prismType, this.name, this.name);
            } else {
                out.format("%s    /** %n", indent);
                out.format("%s      * Returns a %s representing the value of the {@code %s %s} member of the Annotation.%n", indent, this.prismType, this.m.getReturnType(), this.m);
                out.format("%s      * @see %s#%s()%n", indent, ((TypeElement)this.m.getEnclosingElement()).getQualifiedName(), this.name);
                out.format("%s      */ %n", indent);
                out.format("%s    %s%s %s() { return _%s; }%n%n", indent, this.access, this.prismType, this.name, this.name);
            }
        }
    }
}

