/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.svg.renderers.impl;

import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.kernel.font.PdfFont;
import com.itextpdf.kernel.geom.AffineTransform;
import com.itextpdf.kernel.geom.Point;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.layout.Canvas;
import com.itextpdf.layout.element.IBlockElement;
import com.itextpdf.layout.element.IElement;
import com.itextpdf.layout.element.ILeafElement;
import com.itextpdf.layout.element.Paragraph;
import com.itextpdf.layout.element.Text;
import com.itextpdf.layout.font.FontProvider;
import com.itextpdf.layout.font.FontSet;
import com.itextpdf.layout.properties.BaseDirection;
import com.itextpdf.layout.properties.IBeforeTextRestoreExecutor;
import com.itextpdf.layout.properties.RenderingMode;
import com.itextpdf.layout.properties.TextAnchor;
import com.itextpdf.layout.properties.UnitValue;
import com.itextpdf.layout.renderer.IRenderer;
import com.itextpdf.layout.renderer.LineRenderer;
import com.itextpdf.layout.renderer.ParagraphRenderer;
import com.itextpdf.styledxmlparser.css.util.CssDimensionParsingUtils;
import com.itextpdf.styledxmlparser.css.util.CssUtils;
import com.itextpdf.styledxmlparser.exceptions.StyledXMLParserException;
import com.itextpdf.svg.css.SvgStrokeParameterConverter;
import com.itextpdf.svg.renderers.ISvgNodeRenderer;
import com.itextpdf.svg.renderers.SvgDrawContext;
import com.itextpdf.svg.renderers.impl.AbstractSvgNodeRenderer;
import com.itextpdf.svg.renderers.impl.ClipPathSvgNodeRenderer;
import com.itextpdf.svg.renderers.impl.ISvgTextNodeRenderer;
import com.itextpdf.svg.utils.SvgCssUtils;
import com.itextpdf.svg.utils.SvgTextProperties;
import com.itextpdf.svg.utils.SvgTextUtil;
import com.itextpdf.svg.utils.TextRectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class TextSvgBranchRenderer
extends AbstractSvgNodeRenderer
implements ISvgTextNodeRenderer {
    protected static final AffineTransform TEXTFLIP = new AffineTransform(1.0, 0.0, 0.0, -1.0, 0.0, 0.0);
    private final List<ISvgTextNodeRenderer> children = new ArrayList<ISvgTextNodeRenderer>();
    @Deprecated
    protected boolean performRootTransformations = true;
    private Paragraph paragraph;
    private Rectangle objectBoundingBox;
    private boolean moveResolved = false;
    private float xMove;
    private float yMove;
    private boolean posResolved = false;
    private float[] xPos;
    private float[] yPos;
    private boolean whiteSpaceProcessed = false;

    @Override
    public ISvgNodeRenderer createDeepCopy() {
        TextSvgBranchRenderer copy = new TextSvgBranchRenderer();
        this.fillCopy(copy);
        return copy;
    }

    void fillCopy(TextSvgBranchRenderer copy) {
        this.deepCopyAttributesAndStyles(copy);
        this.deepCopyChildren(copy);
    }

    public final void addChild(ISvgTextNodeRenderer child) {
        if (child != null) {
            this.children.add(child);
        }
    }

    public final List<ISvgTextNodeRenderer> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    @Override
    @Deprecated
    public float getTextContentLength(float parentFontSize, PdfFont font) {
        return 0.0f;
    }

    @Override
    @Deprecated
    public float[] getRelativeTranslation() {
        return this.getRelativeTranslation(new SvgDrawContext(null, null));
    }

    public float[] getRelativeTranslation(SvgDrawContext context) {
        if (!this.moveResolved) {
            this.resolveRelativeTextMove(context);
        }
        return new float[]{this.xMove, this.yMove};
    }

    @Override
    @Deprecated
    public boolean containsRelativeMove() {
        return this.containsRelativeMove(new SvgDrawContext(null, null));
    }

    public boolean containsRelativeMove(SvgDrawContext context) {
        if (!this.moveResolved) {
            this.resolveRelativeTextMove(context);
        }
        boolean isNullMove = CssUtils.compareFloats((float)0.0f, (float)this.xMove) && CssUtils.compareFloats((float)0.0f, (float)this.yMove);
        return !isNullMove;
    }

    @Override
    public boolean containsAbsolutePositionChange() {
        return this.containsAbsolutePositionChange(new SvgDrawContext(null, null));
    }

    public boolean containsAbsolutePositionChange(SvgDrawContext context) {
        if (!this.posResolved) {
            this.resolveAbsoluteTextPosition(context);
        }
        return this.xPos != null && this.xPos.length > 0 || this.yPos != null && this.yPos.length > 0;
    }

    @Override
    public float[][] getAbsolutePositionChanges() {
        return this.getAbsolutePositionChanges(new SvgDrawContext(null, null));
    }

    public float[][] getAbsolutePositionChanges(SvgDrawContext context) {
        if (!this.posResolved) {
            this.resolveAbsoluteTextPosition(context);
        }
        return new float[][]{this.xPos, this.yPos};
    }

    public void markWhiteSpaceProcessed() {
        this.whiteSpaceProcessed = true;
    }

    @Override
    public TextRectangle getTextRectangle(SvgDrawContext context, Point startPoint) {
        if (this.attributesAndStyles == null) {
            return null;
        }
        startPoint = this.getStartPoint(context, startPoint);
        Rectangle commonRect = null;
        Rectangle textChunkRect = null;
        ArrayList<ISvgTextNodeRenderer> children = new ArrayList<ISvgTextNodeRenderer>();
        this.collectChildren(children);
        float rootX = (float)startPoint.getX();
        String textAnchorValue = this.getAttribute("text-anchor");
        for (ISvgTextNodeRenderer child : children) {
            if (child instanceof TextSvgBranchRenderer) {
                TextSvgBranchRenderer childText = (TextSvgBranchRenderer)child;
                startPoint = childText.getStartPoint(context, startPoint);
                if (!childText.containsAbsolutePositionChange(context) || textChunkRect == null) continue;
                commonRect = TextSvgBranchRenderer.getCommonRectangleWithAnchor(commonRect, textChunkRect, rootX, textAnchorValue);
                textChunkRect = null;
                textAnchorValue = childText.getAttribute("text-anchor");
                rootX = (float)startPoint.getX();
                continue;
            }
            TextRectangle rectangle = child.getTextRectangle(context, startPoint);
            startPoint = rectangle.getTextBaseLineRightPoint();
            textChunkRect = Rectangle.getCommonRectangle((Rectangle[])new Rectangle[]{textChunkRect, rectangle});
        }
        if (textChunkRect != null) {
            commonRect = TextSvgBranchRenderer.getCommonRectangleWithAnchor(commonRect, textChunkRect, rootX, textAnchorValue);
            return new TextRectangle(commonRect.getX(), commonRect.getY(), commonRect.getWidth(), commonRect.getHeight(), (float)startPoint.getY());
        }
        return null;
    }

    @Override
    public Rectangle getObjectBoundingBox(SvgDrawContext context) {
        if (this.getParent() instanceof TextSvgBranchRenderer) {
            return this.getParent().getObjectBoundingBox(context);
        }
        if (this.objectBoundingBox == null) {
            if (!this.whiteSpaceProcessed) {
                SvgTextUtil.processWhiteSpace(this, true, context);
            }
            this.objectBoundingBox = this.getTextRectangle(context, null);
        }
        return this.objectBoundingBox;
    }

    @Override
    void preDraw(SvgDrawContext context) {
        super.preDraw(context);
        SvgTextUtil.applyTextDecoration(this, this.doFill, this.doStroke, context);
    }

    @Override
    protected void doDraw(SvgDrawContext context) {
        if (this.getChildren().isEmpty() || this.attributesAndStyles == null) {
            return;
        }
        if (!this.whiteSpaceProcessed) {
            SvgTextUtil.processWhiteSpace(this, true, context);
        }
        this.paragraph = new Paragraph();
        this.paragraph.setProperty(26, (Object)Boolean.TRUE);
        this.paragraph.setProperty(123, (Object)RenderingMode.SVG_MODE);
        this.paragraph.setProperty(118, (Object)true);
        if (this.getParentClipPath() != null) {
            this.paragraph.setProperty(157, (Object)new ClippedElementDrawer(this.getParentClipPath(), context));
        }
        this.paragraph.setMargin(0.0f);
        String direction = (String)this.attributesAndStyles.get("direction");
        boolean isRtl = "rtl".equals(direction);
        if (isRtl) {
            this.paragraph.setProperty(7, (Object)BaseDirection.RIGHT_TO_LEFT);
        } else {
            this.paragraph.setProperty(7, (Object)BaseDirection.LEFT_TO_RIGHT);
        }
        this.applyTextRenderingMode((IElement)this.paragraph);
        this.applyFontProperties((IElement)this.paragraph, context);
        this.startNewTextChunk(context, TEXTFLIP);
        this.performDrawing(context);
        this.drawLastTextChunk(context);
        context.setSvgTextProperties(new SvgTextProperties());
    }

    void applyFontProperties(IElement element, SvgDrawContext context) {
        element.setProperty(24, (Object)UnitValue.createPointValue((float)this.getCurrentFontSize(context)));
        FontProvider provider = context.getFontProvider();
        element.setProperty(91, (Object)provider);
        FontSet tempFonts = context.getTempFonts();
        element.setProperty(98, (Object)tempFonts);
        String fontFamily = (String)this.attributesAndStyles.get("font-family");
        String fontWeight = (String)this.attributesAndStyles.get("font-weight");
        String fontStyle = (String)this.attributesAndStyles.get("font-style");
        element.setProperty(20, (Object)new String[]{fontFamily == null ? "" : fontFamily.trim()});
        element.setProperty(95, (Object)fontWeight);
        element.setProperty(94, (Object)fontStyle);
    }

    void applyTextRenderingMode(IElement element) {
        if (this.getParentClipPath() != null) {
            element.setProperty(71, (Object)7);
        } else if (this.doStroke && this.doFill) {
            element.setProperty(71, (Object)2);
        } else if (this.doStroke) {
            element.setProperty(71, (Object)1);
        } else {
            element.setProperty(71, (Object)0);
        }
    }

    void addTextChild(Text text, SvgDrawContext drawContext) {
        if (this.getParent() instanceof TextSvgBranchRenderer) {
            ((TextSvgBranchRenderer)this.getParent()).addTextChild(text, drawContext);
            return;
        }
        text.setProperty(52, (Object)2);
        text.setProperty(34, (Object)Float.valueOf(drawContext.getRelativePosition()[0]));
        text.setProperty(14, (Object)Float.valueOf(drawContext.getRelativePosition()[1]));
        this.paragraph.add((ILeafElement)text);
    }

    void performDrawing(SvgDrawContext context) {
        if (this.containsAbsolutePositionChange(context)) {
            this.drawLastTextChunk(context);
            float[][] absolutePositions = this.getAbsolutePositionChanges(context);
            AffineTransform newTransform = TextSvgBranchRenderer.getTextTransform(absolutePositions, context);
            this.startNewTextChunk(context, newTransform);
        }
        if (this.containsRelativeMove(context)) {
            float[] rootMove = this.getRelativeTranslation(context);
            context.addTextMove(rootMove[0], rootMove[1]);
            context.moveRelativePosition(rootMove[0], rootMove[1]);
        }
        for (ISvgTextNodeRenderer child : this.children) {
            SvgTextProperties textProperties = new SvgTextProperties(context.getSvgTextProperties());
            child.setParent(this);
            child.draw(context);
            context.setSvgTextProperties(textProperties);
        }
    }

    private void startNewTextChunk(SvgDrawContext context, AffineTransform newTransform) {
        this.applyTextAnchor();
        context.setRootTransform(newTransform);
        context.resetTextMove();
        context.resetRelativePosition();
    }

    private void drawLastTextChunk(SvgDrawContext context) {
        if (this.getParent() instanceof TextSvgBranchRenderer) {
            ((TextSvgBranchRenderer)this.getParent()).drawLastTextChunk(context);
            return;
        }
        if (this.paragraph.getChildren().isEmpty()) {
            return;
        }
        ParagraphRenderer paragraphRenderer = new ParagraphRenderer(this.paragraph);
        this.paragraph.setNextRenderer((IRenderer)paragraphRenderer);
        try (Canvas canvas = new Canvas(context.getCurrentCanvas(), new Rectangle((float)context.getRootTransform().getTranslateX(), (float)context.getRootTransform().getTranslateY(), 1000000.0f, 0.0f));){
            canvas.add((IBlockElement)this.paragraph);
        }
        float textLength = ((LineRenderer)paragraphRenderer.getLines().get(0)).getOccupiedAreaBBox().getWidth();
        context.addTextMove(textLength, 0.0f);
        this.paragraph.getChildren().clear();
    }

    @Override
    void applyFillAndStrokeProperties(AbstractSvgNodeRenderer.FillProperties fillProperties, AbstractSvgNodeRenderer.StrokeProperties strokeProperties, SvgDrawContext context) {
        if (fillProperties != null) {
            context.getSvgTextProperties().setFillColor(fillProperties.getColor());
            if (!CssUtils.compareFloats((float)fillProperties.getOpacity(), (float)1.0f)) {
                context.getSvgTextProperties().setFillOpacity(fillProperties.getOpacity());
            }
        }
        if (strokeProperties != null) {
            if (strokeProperties.getLineDashParameters() != null) {
                SvgStrokeParameterConverter.PdfLineDashParameters lineDashParameters = strokeProperties.getLineDashParameters();
                context.getSvgTextProperties().setDashPattern(lineDashParameters.getDashArray(), lineDashParameters.getDashPhase());
            }
            if (strokeProperties.getColor() != null) {
                context.getSvgTextProperties().setStrokeColor(strokeProperties.getColor());
            }
            context.getSvgTextProperties().setLineWidth(strokeProperties.getWidth());
            if (!CssUtils.compareFloats((float)strokeProperties.getOpacity(), (float)1.0f)) {
                context.getSvgTextProperties().setStrokeOpacity(strokeProperties.getOpacity());
            }
        }
    }

    private void resolveRelativeTextMove(SvgDrawContext context) {
        if (this.attributesAndStyles != null) {
            String xRawValue = (String)this.attributesAndStyles.get("dx");
            String yRawValue = (String)this.attributesAndStyles.get("dy");
            List<String> xValuesList = SvgCssUtils.splitValueList(xRawValue);
            List<String> yValuesList = SvgCssUtils.splitValueList(yRawValue);
            this.xMove = 0.0f;
            this.yMove = 0.0f;
            if (!xValuesList.isEmpty()) {
                this.xMove = this.parseHorizontalLength(xValuesList.get(0), context);
            }
            if (!yValuesList.isEmpty()) {
                this.yMove = this.parseVerticalLength(yValuesList.get(0), context);
            }
            this.moveResolved = true;
        }
    }

    private void resolveAbsoluteTextPosition(SvgDrawContext context) {
        if (this.attributesAndStyles != null) {
            String xRawValue = (String)this.attributesAndStyles.get("x");
            String yRawValue = (String)this.attributesAndStyles.get("y");
            this.xPos = this.getPositionsFromString(xRawValue, context, true);
            this.yPos = this.getPositionsFromString(yRawValue, context, false);
            this.posResolved = true;
        }
    }

    private float[] getPositionsFromString(String rawValuesString, SvgDrawContext context, boolean isHorizontal) {
        float[] result = null;
        List<String> valuesList = SvgCssUtils.splitValueList(rawValuesString);
        if (!valuesList.isEmpty()) {
            result = new float[valuesList.size()];
            for (int i = 0; i < valuesList.size(); ++i) {
                String value = valuesList.get(i);
                if (CssDimensionParsingUtils.determinePositionBetweenValueAndUnit((String)value) == 0) {
                    throw new StyledXMLParserException(MessageFormatUtil.format((String)"The passed value (@{0}) is not a number", (Object[])new Object[]{value}));
                }
                result[i] = isHorizontal ? this.parseHorizontalLength(value, context) : this.parseVerticalLength(value, context);
            }
        }
        return result;
    }

    private static AffineTransform getTextTransform(float[][] absolutePositions, SvgDrawContext context) {
        AffineTransform tf = new AffineTransform();
        if (absolutePositions[0] == null && absolutePositions[1] != null) {
            absolutePositions[0] = new float[]{(float)context.getRootTransform().getTranslateX() + context.getTextMove()[0]};
        }
        if (absolutePositions[1] == null) {
            absolutePositions[1] = new float[]{(float)context.getRootTransform().getTranslateY() + context.getTextMove()[1]};
        }
        tf.concatenate(TEXTFLIP);
        tf.concatenate(AffineTransform.getTranslateInstance((double)absolutePositions[0][0], (double)(-absolutePositions[1][0])));
        return tf;
    }

    private static Rectangle getCommonRectangleWithAnchor(Rectangle commonRect, Rectangle textChunkRect, float absoluteX, String textAnchorValue) {
        textChunkRect.moveRight(absoluteX - textChunkRect.getX());
        if ("middle".equals(textAnchorValue)) {
            textChunkRect.moveRight(-textChunkRect.getWidth() / 2.0f);
        }
        if ("end".equals(textAnchorValue)) {
            textChunkRect.moveRight(-textChunkRect.getWidth());
        }
        return Rectangle.getCommonRectangle((Rectangle[])new Rectangle[]{commonRect, textChunkRect});
    }

    private void deepCopyChildren(TextSvgBranchRenderer deepCopy) {
        for (ISvgTextNodeRenderer child : this.children) {
            ISvgTextNodeRenderer newChild = (ISvgTextNodeRenderer)child.createDeepCopy();
            newChild.setParent(deepCopy);
            deepCopy.addChild(newChild);
        }
    }

    private void applyTextAnchor() {
        if (this.attributesAndStyles != null && (this.attributesAndStyles.containsKey("text-anchor") || this.attributesAndStyles.containsKey("direction"))) {
            String textAnchorValue = this.getAttributeOrDefault("text-anchor", "start");
            String direction = (String)this.attributesAndStyles.get("direction");
            boolean isRtl = "rtl".equals(direction);
            this.applyTextAnchor(textAnchorValue, isRtl);
        }
    }

    private void applyTextAnchor(String textAnchorValue, boolean isRtl) {
        if (this.getParent() instanceof TextSvgBranchRenderer) {
            ((TextSvgBranchRenderer)this.getParent()).applyTextAnchor(textAnchorValue, isRtl);
            return;
        }
        if ("middle".equals(textAnchorValue)) {
            this.paragraph.setProperty(155, (Object)TextAnchor.MIDDLE);
            return;
        }
        if ("end".equals(textAnchorValue) && !isRtl || !"end".equals(textAnchorValue) && isRtl) {
            this.paragraph.setProperty(155, (Object)TextAnchor.END);
            return;
        }
        this.paragraph.setProperty(155, (Object)TextAnchor.START);
    }

    private Point getStartPoint(SvgDrawContext context, Point basePoint) {
        double x = 0.0;
        double y = 0.0;
        float[][] absolutePosition = this.getAbsolutePositionChanges(context);
        if (absolutePosition[0] != null) {
            x = absolutePosition[0][0];
        } else if (basePoint != null) {
            x = basePoint.getX();
        }
        if (absolutePosition[1] != null) {
            y = absolutePosition[1][0];
        } else if (basePoint != null) {
            y = basePoint.getY();
        }
        basePoint = new Point(x, y);
        basePoint.move((double)this.getRelativeTranslation(context)[0], (double)this.getRelativeTranslation(context)[1]);
        return basePoint;
    }

    private void collectChildren(List<ISvgTextNodeRenderer> children) {
        for (ISvgTextNodeRenderer child : this.getChildren()) {
            children.add(child);
            if (!(child instanceof TextSvgBranchRenderer)) continue;
            ((TextSvgBranchRenderer)child).collectChildren(children);
        }
    }

    private static final class ClippedElementDrawer
    implements IBeforeTextRestoreExecutor {
        private final ClipPathSvgNodeRenderer clipPathSvgNodeRenderer;
        private final SvgDrawContext context;

        public ClippedElementDrawer(ClipPathSvgNodeRenderer clipPathSvgNodeRenderer, SvgDrawContext context) {
            this.clipPathSvgNodeRenderer = clipPathSvgNodeRenderer;
            this.context = context;
        }

        public void execute() {
            this.clipPathSvgNodeRenderer.drawClippedRenderer(this.context);
        }
    }
}

