/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.svg.renderers.impl;

import com.itextpdf.kernel.geom.AffineTransform;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfStream;
import com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import com.itextpdf.layout.properties.TransparentColor;
import com.itextpdf.styledxmlparser.css.util.CssDimensionParsingUtils;
import com.itextpdf.svg.exceptions.SvgProcessingException;
import com.itextpdf.svg.renderers.ISvgNodeRenderer;
import com.itextpdf.svg.renderers.SvgDrawContext;
import java.util.Map;

public class PdfRootSvgNodeRenderer
implements ISvgNodeRenderer {
    ISvgNodeRenderer subTreeRoot;

    public PdfRootSvgNodeRenderer(ISvgNodeRenderer subTreeRoot) {
        this.subTreeRoot = subTreeRoot;
        subTreeRoot.setParent(this);
    }

    @Override
    public void setParent(ISvgNodeRenderer parent) {
    }

    @Override
    public ISvgNodeRenderer getParent() {
        return null;
    }

    @Override
    public void draw(SvgDrawContext context) {
        context.addViewPort(PdfRootSvgNodeRenderer.calculateViewPort(context));
        PdfCanvas currentCanvas = context.getCurrentCanvas();
        currentCanvas.concatMatrix(this.calculateTransformation(context));
        currentCanvas.writeLiteral("% svg root\n");
        this.applyBackgroundColor(context);
        this.subTreeRoot.draw(context);
    }

    @Override
    public void setAttributesAndStyles(Map<String, String> attributesAndStyles) {
    }

    @Override
    public String getAttribute(String key) {
        return null;
    }

    @Override
    public void setAttribute(String key, String value) {
    }

    @Override
    public Map<String, String> getAttributeMapCopy() {
        return null;
    }

    @Override
    public Rectangle getObjectBoundingBox(SvgDrawContext context) {
        return null;
    }

    AffineTransform calculateTransformation(SvgDrawContext context) {
        Rectangle viewPort = context.getCurrentViewPort();
        float horizontal = viewPort.getX();
        float vertical = viewPort.getY() + viewPort.getHeight();
        AffineTransform transform = AffineTransform.getTranslateInstance((double)0.0, (double)0.0);
        transform.concatenate(AffineTransform.getTranslateInstance((double)horizontal, (double)vertical));
        transform.concatenate(new AffineTransform(1.0, 0.0, 0.0, -1.0, 0.0, 0.0));
        return transform;
    }

    static Rectangle calculateViewPort(SvgDrawContext context) {
        float portX = 0.0f;
        float portY = 0.0f;
        float portWidth = 0.0f;
        float portHeight = 0.0f;
        PdfStream contentStream = context.getCurrentCanvas().getContentStream();
        if (!contentStream.containsKey(PdfName.BBox)) {
            throw new SvgProcessingException("The root svg tag needs to have a bounding box defined.");
        }
        PdfArray bboxArray = contentStream.getAsArray(PdfName.BBox);
        portX = bboxArray.getAsNumber(0).floatValue();
        portY = bboxArray.getAsNumber(1).floatValue();
        portWidth = bboxArray.getAsNumber(2).floatValue() - portX;
        portHeight = bboxArray.getAsNumber(3).floatValue() - portY;
        return new Rectangle(portX, portY, portWidth, portHeight);
    }

    @Override
    public ISvgNodeRenderer createDeepCopy() {
        PdfRootSvgNodeRenderer copy = new PdfRootSvgNodeRenderer(this.subTreeRoot.createDeepCopy());
        return copy;
    }

    private void applyBackgroundColor(SvgDrawContext context) {
        String backgroundColorStr = this.subTreeRoot.getAttribute("background-color");
        if (backgroundColorStr != null && !"transparent".equals(backgroundColorStr)) {
            Rectangle backgroundArea = context.getCurrentViewPort();
            TransparentColor color = CssDimensionParsingUtils.parseColor((String)backgroundColorStr);
            context.getCurrentCanvas().saveState().setFillColor(color.getColor());
            color.applyFillTransparency(context.getCurrentCanvas());
            context.getCurrentCanvas().rectangle((double)backgroundArea.getX(), (double)backgroundArea.getY(), (double)backgroundArea.getWidth(), (double)backgroundArea.getHeight()).fill().restoreState();
        }
    }
}

