/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.svg.renderers.impl;

import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.svg.renderers.SvgDrawContext;
import com.itextpdf.svg.renderers.impl.AbstractBranchSvgNodeRenderer;
import com.itextpdf.svg.renderers.impl.AbstractSvgNodeRenderer;
import com.itextpdf.svg.renderers.impl.PdfRootSvgNodeRenderer;
import com.itextpdf.svg.utils.SvgCssUtils;

public abstract class AbstractContainerSvgNodeRenderer
extends AbstractBranchSvgNodeRenderer {
    @Override
    public boolean canConstructViewPort() {
        return true;
    }

    @Override
    protected boolean canElementFill() {
        return false;
    }

    @Override
    protected void doDraw(SvgDrawContext context) {
        context.addViewPort(this.calculateViewPort(context));
        super.doDraw(context);
    }

    Rectangle calculateViewPort(SvgDrawContext context) {
        if (this.getParent() instanceof PdfRootSvgNodeRenderer || !(this.getParent() instanceof AbstractSvgNodeRenderer)) {
            return context.getCurrentViewPort().clone();
        }
        Rectangle percentBaseBox = ((AbstractSvgNodeRenderer)this.getParent()).getCurrentViewBox(context);
        float portX = 0.0f;
        float portY = 0.0f;
        float portWidth = percentBaseBox.getWidth();
        float portHeight = percentBaseBox.getHeight();
        if (this.attributesAndStyles != null) {
            portX = SvgCssUtils.parseAbsoluteLength(this, (String)this.attributesAndStyles.get("x"), percentBaseBox.getWidth(), 0.0f, context);
            portY = SvgCssUtils.parseAbsoluteLength(this, (String)this.attributesAndStyles.get("y"), percentBaseBox.getHeight(), 0.0f, context);
            String widthStr = (String)this.attributesAndStyles.get("width");
            portWidth = SvgCssUtils.parseAbsoluteLength(this, widthStr, percentBaseBox.getWidth(), percentBaseBox.getWidth(), context);
            String heightStr = (String)this.attributesAndStyles.get("height");
            portHeight = SvgCssUtils.parseAbsoluteLength(this, heightStr, percentBaseBox.getHeight(), percentBaseBox.getHeight(), context);
        }
        return new Rectangle(portX, portY, portWidth, portHeight);
    }
}

