/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.signatures.validation;

import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.signatures.IssuingCertificateRetriever;
import com.itextpdf.signatures.validation.RevocationDataValidator;
import com.itextpdf.signatures.validation.SafeCalling;
import com.itextpdf.signatures.validation.SignatureValidationProperties;
import com.itextpdf.signatures.validation.TrustedCertificatesStore;
import com.itextpdf.signatures.validation.ValidatorChainBuilder;
import com.itextpdf.signatures.validation.context.CertificateSource;
import com.itextpdf.signatures.validation.context.ValidationContext;
import com.itextpdf.signatures.validation.context.ValidatorContext;
import com.itextpdf.signatures.validation.extensions.CertificateExtension;
import com.itextpdf.signatures.validation.extensions.DynamicCertificateExtension;
import com.itextpdf.signatures.validation.report.CertificateReportItem;
import com.itextpdf.signatures.validation.report.ReportItem;
import com.itextpdf.signatures.validation.report.ValidationReport;
import java.security.GeneralSecurityException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.List;

public class CertificateChainValidator {
    static final String CERTIFICATE_CHECK = "Certificate check.";
    static final String VALIDITY_CHECK = "Certificate validity period check.";
    static final String EXTENSIONS_CHECK = "Required certificate extensions check.";
    static final String CERTIFICATE_TRUSTED = "Certificate {0} is trusted, revocation data checks are not required.";
    static final String CERTIFICATE_TRUSTED_FOR_DIFFERENT_CONTEXT = "Certificate {0} is trusted for {1}, but it is not used in this context. Validation will continue as usual.";
    static final String EXTENSION_MISSING = "Required extension validation failed: {0}";
    static final String ISSUER_MISSING = "Certificate {0} isn't trusted and issuer certificate isn't provided.";
    static final String EXPIRED_CERTIFICATE = "Certificate {0} is expired.";
    static final String NOT_YET_VALID_CERTIFICATE = "Certificate {0} is not yet valid.";
    static final String ISSUER_CANNOT_BE_VERIFIED = "Issuer certificate {0} for subject certificate {1} cannot be mathematically verified.";
    static final String ISSUER_VERIFICATION_FAILED = "Unexpected exception occurred while verifying issuer certificate.";
    static final String ISSUER_RETRIEVAL_FAILED = "Unexpected exception occurred while retrieving certificate issuer from IssuingCertificateRetriever.";
    static final String TRUSTSTORE_RETRIEVAL_FAILED = "Unexpected exception occurred while retrieving trust store from IssuingCertificateRetriever.";
    static final String REVOCATION_VALIDATION_FAILED = "Unexpected exception occurred while validating certificate revocation.";
    static final String VALIDITY_PERIOD_CHECK_FAILED = "Unexpected exception occurred while validating certificate validity period.";
    private final SignatureValidationProperties properties;
    private final IssuingCertificateRetriever certificateRetriever;
    private final RevocationDataValidator revocationDataValidator;

    protected CertificateChainValidator(ValidatorChainBuilder builder) {
        this.certificateRetriever = builder.getCertificateRetriever();
        this.properties = builder.getProperties();
        this.revocationDataValidator = builder.getRevocationDataValidator();
    }

    public ValidationReport validateCertificate(ValidationContext context, X509Certificate certificate, Date validationDate) {
        ValidationReport result = new ValidationReport();
        return this.validate(result, context, certificate, validationDate);
    }

    public ValidationReport validate(ValidationReport result, ValidationContext context, X509Certificate certificate, Date validationDate) {
        return this.validate(result, context, certificate, validationDate, 0);
    }

    private ValidationReport validate(ValidationReport result, ValidationContext context, X509Certificate certificate, Date validationDate, int certificateChainSize) {
        ValidationContext localContext = context.setValidatorContext(ValidatorContext.CERTIFICATE_CHAIN_VALIDATOR);
        this.validateValidityPeriod(result, certificate, validationDate);
        this.validateRequiredExtensions(result, localContext, certificate, certificateChainSize);
        if (this.stopValidation(result, localContext)) {
            return result;
        }
        if (SafeCalling.onExceptionLog(() -> this.checkIfCertIsTrusted(result, localContext, certificate), Boolean.FALSE, result, e -> new CertificateReportItem(certificate, CERTIFICATE_CHECK, TRUSTSTORE_RETRIEVAL_FAILED, (Exception)e, ReportItem.ReportItemStatus.INFO)).booleanValue()) {
            return result;
        }
        this.validateRevocationData(result, localContext, certificate, validationDate);
        if (this.stopValidation(result, localContext)) {
            return result;
        }
        this.validateChain(result, localContext, certificate, validationDate, certificateChainSize);
        return result;
    }

    private boolean checkIfCertIsTrusted(ValidationReport result, ValidationContext context, X509Certificate certificate) {
        if (CertificateSource.TRUSTED == context.getCertificateSource()) {
            result.addReportItem(new CertificateReportItem(certificate, CERTIFICATE_CHECK, MessageFormatUtil.format((String)CERTIFICATE_TRUSTED, (Object[])new Object[]{certificate.getSubjectX500Principal()}), ReportItem.ReportItemStatus.INFO));
            return true;
        }
        TrustedCertificatesStore store = this.certificateRetriever.getTrustedCertificatesStore();
        if (store.isCertificateGenerallyTrusted(certificate)) {
            result.addReportItem(new CertificateReportItem(certificate, CERTIFICATE_CHECK, MessageFormatUtil.format((String)CERTIFICATE_TRUSTED, (Object[])new Object[]{certificate.getSubjectX500Principal()}), ReportItem.ReportItemStatus.INFO));
            return true;
        }
        if (store.isCertificateTrustedForCA(certificate)) {
            if (CertificateSource.CERT_ISSUER == context.getCertificateSource()) {
                result.addReportItem(new CertificateReportItem(certificate, CERTIFICATE_CHECK, MessageFormatUtil.format((String)CERTIFICATE_TRUSTED, (Object[])new Object[]{certificate.getSubjectX500Principal()}), ReportItem.ReportItemStatus.INFO));
                return true;
            }
            result.addReportItem(new CertificateReportItem(certificate, CERTIFICATE_CHECK, MessageFormatUtil.format((String)CERTIFICATE_TRUSTED_FOR_DIFFERENT_CONTEXT, (Object[])new Object[]{certificate.getSubjectX500Principal(), "certificates generation"}), ReportItem.ReportItemStatus.INFO));
        }
        if (store.isCertificateTrustedForTimestamp(certificate)) {
            if (ValidationContext.checkIfContextChainContainsCertificateSource(context, CertificateSource.TIMESTAMP)) {
                result.addReportItem(new CertificateReportItem(certificate, CERTIFICATE_CHECK, MessageFormatUtil.format((String)CERTIFICATE_TRUSTED, (Object[])new Object[]{certificate.getSubjectX500Principal()}), ReportItem.ReportItemStatus.INFO));
                return true;
            }
            result.addReportItem(new CertificateReportItem(certificate, CERTIFICATE_CHECK, MessageFormatUtil.format((String)CERTIFICATE_TRUSTED_FOR_DIFFERENT_CONTEXT, (Object[])new Object[]{certificate.getSubjectX500Principal(), "timestamp generation"}), ReportItem.ReportItemStatus.INFO));
        }
        if (store.isCertificateTrustedForOcsp(certificate)) {
            if (ValidationContext.checkIfContextChainContainsCertificateSource(context, CertificateSource.OCSP_ISSUER)) {
                result.addReportItem(new CertificateReportItem(certificate, CERTIFICATE_CHECK, MessageFormatUtil.format((String)CERTIFICATE_TRUSTED, (Object[])new Object[]{certificate.getSubjectX500Principal()}), ReportItem.ReportItemStatus.INFO));
                return true;
            }
            result.addReportItem(new CertificateReportItem(certificate, CERTIFICATE_CHECK, MessageFormatUtil.format((String)CERTIFICATE_TRUSTED_FOR_DIFFERENT_CONTEXT, (Object[])new Object[]{certificate.getSubjectX500Principal(), "OCSP response generation"}), ReportItem.ReportItemStatus.INFO));
        }
        if (store.isCertificateTrustedForCrl(certificate)) {
            if (ValidationContext.checkIfContextChainContainsCertificateSource(context, CertificateSource.CRL_ISSUER)) {
                result.addReportItem(new CertificateReportItem(certificate, CERTIFICATE_CHECK, MessageFormatUtil.format((String)CERTIFICATE_TRUSTED, (Object[])new Object[]{certificate.getSubjectX500Principal()}), ReportItem.ReportItemStatus.INFO));
                return true;
            }
            result.addReportItem(new CertificateReportItem(certificate, CERTIFICATE_CHECK, MessageFormatUtil.format((String)CERTIFICATE_TRUSTED_FOR_DIFFERENT_CONTEXT, (Object[])new Object[]{certificate.getSubjectX500Principal(), "CRL generation"}), ReportItem.ReportItemStatus.INFO));
        }
        return false;
    }

    private boolean stopValidation(ValidationReport result, ValidationContext context) {
        return !this.properties.getContinueAfterFailure(context) && result.getValidationResult() == ValidationReport.ValidationResult.INVALID;
    }

    private void validateValidityPeriod(ValidationReport result, X509Certificate certificate, Date validationDate) {
        try {
            certificate.checkValidity(validationDate);
        }
        catch (CertificateExpiredException e) {
            result.addReportItem(new CertificateReportItem(certificate, VALIDITY_CHECK, MessageFormatUtil.format((String)EXPIRED_CERTIFICATE, (Object[])new Object[]{certificate.getSubjectX500Principal()}), e, ReportItem.ReportItemStatus.INVALID));
        }
        catch (CertificateNotYetValidException e) {
            result.addReportItem(new CertificateReportItem(certificate, VALIDITY_CHECK, MessageFormatUtil.format((String)NOT_YET_VALID_CERTIFICATE, (Object[])new Object[]{certificate.getSubjectX500Principal()}), e, ReportItem.ReportItemStatus.INVALID));
        }
        catch (RuntimeException e) {
            result.addReportItem(new CertificateReportItem(certificate, VALIDITY_CHECK, MessageFormatUtil.format((String)VALIDITY_PERIOD_CHECK_FAILED, (Object[])new Object[]{certificate.getSubjectX500Principal()}), e, ReportItem.ReportItemStatus.INVALID));
        }
    }

    private void validateRequiredExtensions(ValidationReport result, ValidationContext context, X509Certificate certificate, int certificateChainSize) {
        List<CertificateExtension> requiredExtensions = this.properties.getRequiredExtensions(context);
        if (requiredExtensions != null) {
            for (CertificateExtension requiredExtension : requiredExtensions) {
                if (requiredExtension instanceof DynamicCertificateExtension) {
                    ((DynamicCertificateExtension)requiredExtension).withCertificateChainSize(certificateChainSize);
                }
                if (requiredExtension.existsInCertificate(certificate)) continue;
                result.addReportItem(new CertificateReportItem(certificate, EXTENSIONS_CHECK, MessageFormatUtil.format((String)EXTENSION_MISSING, (Object[])new Object[]{requiredExtension.getMessage()}), ReportItem.ReportItemStatus.INVALID));
            }
        }
    }

    private void validateRevocationData(ValidationReport report, ValidationContext context, X509Certificate certificate, Date validationDate) {
        SafeCalling.onRuntimeExceptionLog(() -> this.revocationDataValidator.validate(report, context, certificate, validationDate), report, e -> new CertificateReportItem(certificate, CERTIFICATE_CHECK, REVOCATION_VALIDATION_FAILED, (Exception)e, ReportItem.ReportItemStatus.INDETERMINATE));
    }

    private void validateChain(ValidationReport result, ValidationContext context, X509Certificate certificate, Date validationDate, int certificateChainSize) {
        List<X509Certificate> issuerCertificates;
        try {
            issuerCertificates = this.certificateRetriever.retrieveIssuerCertificate(certificate);
        }
        catch (RuntimeException e) {
            result.addReportItem(new CertificateReportItem(certificate, CERTIFICATE_CHECK, ISSUER_RETRIEVAL_FAILED, e, ReportItem.ReportItemStatus.INDETERMINATE));
            return;
        }
        if (issuerCertificates.isEmpty()) {
            result.addReportItem(new CertificateReportItem(certificate, CERTIFICATE_CHECK, MessageFormatUtil.format((String)ISSUER_MISSING, (Object[])new Object[]{certificate.getSubjectX500Principal()}), ReportItem.ReportItemStatus.INDETERMINATE));
            return;
        }
        ValidationReport[] candidateReports = new ValidationReport[issuerCertificates.size()];
        for (int i = 0; i < issuerCertificates.size(); ++i) {
            candidateReports[i] = new ValidationReport();
            try {
                certificate.verify(issuerCertificates.get(i).getPublicKey());
            }
            catch (GeneralSecurityException e) {
                candidateReports[i].addReportItem(new CertificateReportItem(certificate, CERTIFICATE_CHECK, MessageFormatUtil.format((String)ISSUER_CANNOT_BE_VERIFIED, (Object[])new Object[]{issuerCertificates.get(i).getSubjectX500Principal(), certificate.getSubjectX500Principal()}), e, ReportItem.ReportItemStatus.INVALID));
                continue;
            }
            catch (RuntimeException e) {
                candidateReports[i].addReportItem(new CertificateReportItem(certificate, CERTIFICATE_CHECK, MessageFormatUtil.format((String)ISSUER_VERIFICATION_FAILED, (Object[])new Object[]{issuerCertificates.get(i).getSubjectX500Principal(), certificate.getSubjectX500Principal()}), e, ReportItem.ReportItemStatus.INVALID));
                continue;
            }
            this.validate(candidateReports[i], context.setCertificateSource(CertificateSource.CERT_ISSUER), issuerCertificates.get(i), validationDate, certificateChainSize + 1);
            if (candidateReports[i].getValidationResult() != ValidationReport.ValidationResult.VALID) continue;
            result.merge(candidateReports[i]);
            return;
        }
        for (ValidationReport candidateReport : candidateReports) {
            result.merge(candidateReport);
        }
    }
}

