/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.layout.tagging;

import com.itextpdf.layout.element.Cell;
import com.itextpdf.layout.element.Div;
import com.itextpdf.layout.element.Table;
import com.itextpdf.layout.properties.CaptionSide;
import com.itextpdf.layout.tagging.ITaggingRule;
import com.itextpdf.layout.tagging.LayoutTaggingHelper;
import com.itextpdf.layout.tagging.TaggingDummyElement;
import com.itextpdf.layout.tagging.TaggingHintKey;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TreeMap;

class TableTaggingRule
implements ITaggingRule {
    TableTaggingRule() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean onTagFinish(LayoutTaggingHelper taggingHelper, TaggingHintKey tableHintKey) {
        List<TaggingHintKey> kidKeys = taggingHelper.getAccessibleKidsHint(tableHintKey);
        TreeMap tableTags = new TreeMap();
        ArrayList<TaggingHintKey> tableCellTagsUnindexed = new ArrayList<TaggingHintKey>();
        ArrayList<TaggingHintKey> nonCellKids = new ArrayList<TaggingHintKey>();
        for (TaggingHintKey taggingHintKey : kidKeys) {
            boolean bl;
            String string = TableTaggingRule.getKidRole(taggingHintKey, taggingHelper);
            boolean bl2 = bl = "TD".equals(string) || "TH".equals(string);
            if (bl && taggingHintKey.getAccessibleElement() instanceof Cell) {
                void var14_31;
                Cell cell = (Cell)taggingHintKey.getAccessibleElement();
                int rowInd = cell.getRow();
                int colInd = cell.getCol();
                TreeMap treeMap = (TreeMap)tableTags.get(rowInd);
                if (treeMap == null) {
                    TreeMap treeMap2 = new TreeMap();
                    tableTags.put(rowInd, treeMap2);
                }
                var14_31.put(colInd, taggingHintKey);
                continue;
            }
            if (bl) {
                tableCellTagsUnindexed.add(taggingHintKey);
                continue;
            }
            nonCellKids.add(taggingHintKey);
        }
        TaggingDummyElement tbodyTag = TableTaggingRule.getTbodyTag(tableHintKey);
        for (TaggingHintKey taggingHintKey : nonCellKids) {
            String string = TableTaggingRule.getKidRole(taggingHintKey, taggingHelper);
            if ("THead".equals(string) || "TFoot".equals(string) || "Caption".equals(string)) continue;
            taggingHelper.moveKidHint(taggingHintKey, tableHintKey);
        }
        for (TaggingHintKey taggingHintKey : nonCellKids) {
            if (!"THead".equals(TableTaggingRule.getKidRole(taggingHintKey, taggingHelper))) continue;
            taggingHelper.moveKidHint(taggingHintKey, tableHintKey);
        }
        taggingHelper.addKidsHint(tableHintKey, Collections.singletonList(LayoutTaggingHelper.getOrCreateHintKey(tbodyTag)), -1);
        for (TaggingHintKey taggingHintKey : nonCellKids) {
            if (!"TFoot".equals(TableTaggingRule.getKidRole(taggingHintKey, taggingHelper))) continue;
            taggingHelper.moveKidHint(taggingHintKey, tableHintKey);
        }
        ArrayList<TaggingDummyElement> arrayList = new ArrayList<TaggingDummyElement>();
        for (TreeMap treeMap : tableTags.values()) {
            TaggingDummyElement row = new TaggingDummyElement("TR");
            TaggingHintKey rowTagHint = LayoutTaggingHelper.getOrCreateHintKey(row);
            for (TaggingHintKey taggingHintKey : treeMap.values()) {
                taggingHelper.moveKidHint(taggingHintKey, rowTagHint);
            }
            if (tableCellTagsUnindexed != null) {
                for (TaggingHintKey taggingHintKey : tableCellTagsUnindexed) {
                    taggingHelper.moveKidHint(taggingHintKey, rowTagHint);
                }
                tableCellTagsUnindexed = null;
            }
            arrayList.add(row);
        }
        taggingHelper.addKidsHint(tbodyTag, arrayList, -1);
        for (TaggingHintKey taggingHintKey : nonCellKids) {
            if (!"Caption".equals(TableTaggingRule.getKidRole(taggingHintKey, taggingHelper))) continue;
            TableTaggingRule.moveCaption(taggingHelper, taggingHintKey, tableHintKey);
        }
        return true;
    }

    private static String getKidRole(TaggingHintKey kidKey, LayoutTaggingHelper helper) {
        return helper.getPdfDocument().getTagStructureContext().resolveMappingToStandardOrDomainSpecificRole(kidKey.getAccessibilityProperties().getRole(), null).getRole();
    }

    private static TaggingDummyElement getTbodyTag(TaggingHintKey tableHintKey) {
        boolean createTBody = true;
        if (tableHintKey.getAccessibleElement() instanceof Table) {
            Table modelElement = (Table)tableHintKey.getAccessibleElement();
            createTBody = modelElement.getHeader() != null && !modelElement.isSkipFirstHeader() || modelElement.getFooter() != null && !modelElement.isSkipLastFooter();
        }
        return new TaggingDummyElement(createTBody ? "TBody" : null);
    }

    private static void moveCaption(LayoutTaggingHelper taggingHelper, TaggingHintKey caption, TaggingHintKey tableHintKey) {
        if (!(tableHintKey.getAccessibleElement() instanceof Table)) {
            return;
        }
        Table tableElem = (Table)tableHintKey.getAccessibleElement();
        Div captionDiv = tableElem.getCaption();
        if (captionDiv == null) {
            return;
        }
        CaptionSide captionSide = captionDiv.getProperty(119) == null ? CaptionSide.TOP : (CaptionSide)((Object)captionDiv.getProperty(119));
        if (CaptionSide.TOP.equals((Object)captionSide)) {
            taggingHelper.moveKidHint(caption, tableHintKey, 0);
        } else {
            taggingHelper.moveKidHint(caption, tableHintKey);
        }
    }
}

