/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.layout.font;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class Range {
    private SubRange[] ranges;

    private Range() {
    }

    Range(List<SubRange> ranges) {
        if (ranges.size() == 0) {
            throw new IllegalArgumentException("Ranges shall not be empty");
        }
        this.ranges = Range.normalizeSubRanges(ranges);
    }

    public boolean contains(int n) {
        int low = 0;
        int high = this.ranges.length - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            if (this.ranges[mid].compareTo(n) < 0) {
                low = mid + 1;
                continue;
            }
            if (this.ranges[mid].compareTo(n) > 0) {
                high = mid - 1;
                continue;
            }
            return true;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Range range = (Range)o;
        return Arrays.equals(this.ranges, range.ranges);
    }

    public int hashCode() {
        return Arrays.hashCode(this.ranges);
    }

    public String toString() {
        return Arrays.toString(this.ranges);
    }

    private static SubRange[] normalizeSubRanges(List<SubRange> ranges) {
        Collections.sort(ranges);
        ArrayList<SubRange> union = new ArrayList<SubRange>(ranges.size());
        assert (ranges.size() > 0);
        SubRange curr = ranges.get(0);
        union.add(curr);
        for (int i = 1; i < ranges.size(); ++i) {
            SubRange next = ranges.get(i);
            if (next.low <= curr.high) {
                if (next.high <= curr.high) continue;
                curr.high = next.high;
                continue;
            }
            curr = next;
            union.add(curr);
        }
        return union.toArray(new SubRange[0]);
    }

    static class FullRange
    extends Range {
        FullRange() {
        }

        @Override
        public boolean contains(int uni) {
            return true;
        }

        @Override
        public boolean equals(Object o) {
            return this == o;
        }

        @Override
        public int hashCode() {
            return 1;
        }

        @Override
        public String toString() {
            return "[FullRange]";
        }
    }

    static class SubRange
    implements Comparable<SubRange> {
        int low;
        int high;

        SubRange(int low, int high) {
            this.low = low;
            this.high = high;
        }

        @Override
        public int compareTo(SubRange o) {
            return this.low - o.low;
        }

        @Override
        public int compareTo(int n) {
            if (n < this.low) {
                return 1;
            }
            if (n > this.high) {
                return -1;
            }
            return 0;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SubRange subRange = (SubRange)o;
            return this.low == subRange.low && this.high == subRange.high;
        }

        public int hashCode() {
            return 31 * this.low + this.high;
        }

        public String toString() {
            return "(" + this.low + "; " + this.high + ')';
        }
    }
}

