/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.pdf.canvas.wmf;

import com.itextpdf.kernel.colors.Color;
import com.itextpdf.kernel.colors.ColorConstants;
import com.itextpdf.kernel.geom.Point;
import com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import com.itextpdf.kernel.pdf.canvas.wmf.MetaBrush;
import com.itextpdf.kernel.pdf.canvas.wmf.MetaFont;
import com.itextpdf.kernel.pdf.canvas.wmf.MetaObject;
import com.itextpdf.kernel.pdf.canvas.wmf.MetaPen;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

public class MetaState {
    public static final int TA_NOUPDATECP = 0;
    public static final int TA_UPDATECP = 1;
    public static final int TA_LEFT = 0;
    public static final int TA_RIGHT = 2;
    public static final int TA_CENTER = 6;
    public static final int TA_TOP = 0;
    public static final int TA_BOTTOM = 8;
    public static final int TA_BASELINE = 24;
    public static final int TRANSPARENT = 1;
    public static final int OPAQUE = 2;
    public static final int ALTERNATE = 1;
    public static final int WINDING = 2;
    private Stack<MetaState> savedStates;
    private List<MetaObject> metaObjects;
    private Point currentPoint;
    private MetaPen currentPen;
    private MetaBrush currentBrush;
    private MetaFont currentFont;
    private Color currentBackgroundColor = ColorConstants.WHITE;
    private Color currentTextColor = ColorConstants.BLACK;
    private int backgroundMode = 2;
    private int polyFillMode = 1;
    private int lineJoin = 1;
    private int textAlign;
    private int offsetWx;
    private int offsetWy;
    private int extentWx;
    private int extentWy;
    private float scalingX;
    private float scalingY;

    public MetaState() {
        this.savedStates = new Stack();
        this.metaObjects = new ArrayList<MetaObject>();
        this.currentPoint = new Point(0.0, 0.0);
        this.currentPen = new MetaPen();
        this.currentBrush = new MetaBrush();
        this.currentFont = new MetaFont();
    }

    public MetaState(MetaState state) {
        this.setMetaState(state);
    }

    public void setMetaState(MetaState state) {
        this.savedStates = state.savedStates;
        this.metaObjects = state.metaObjects;
        this.currentPoint = state.currentPoint;
        this.currentPen = state.currentPen;
        this.currentBrush = state.currentBrush;
        this.currentFont = state.currentFont;
        this.currentBackgroundColor = state.currentBackgroundColor;
        this.currentTextColor = state.currentTextColor;
        this.backgroundMode = state.backgroundMode;
        this.polyFillMode = state.polyFillMode;
        this.textAlign = state.textAlign;
        this.lineJoin = state.lineJoin;
        this.offsetWx = state.offsetWx;
        this.offsetWy = state.offsetWy;
        this.extentWx = state.extentWx;
        this.extentWy = state.extentWy;
        this.scalingX = state.scalingX;
        this.scalingY = state.scalingY;
    }

    public void addMetaObject(MetaObject object) {
        for (int k = 0; k < this.metaObjects.size(); ++k) {
            if (this.metaObjects.get(k) != null) continue;
            this.metaObjects.set(k, object);
            return;
        }
        this.metaObjects.add(object);
    }

    public void selectMetaObject(int index, PdfCanvas cb) {
        MetaObject obj = this.metaObjects.get(index);
        if (obj == null) {
            return;
        }
        block0 : switch (obj.getType()) {
            case 2: {
                this.currentBrush = (MetaBrush)obj;
                int style = this.currentBrush.getStyle();
                if (style == 0) {
                    Color color = this.currentBrush.getColor();
                    cb.setFillColor(color);
                    break;
                }
                if (style != 2) break;
                Color color = this.currentBackgroundColor;
                cb.setFillColor(color);
                break;
            }
            case 1: {
                this.currentPen = (MetaPen)obj;
                int style = this.currentPen.getStyle();
                if (style == 5) break;
                Color color = this.currentPen.getColor();
                cb.setStrokeColor(color);
                cb.setLineWidth(Math.abs((float)this.currentPen.getPenWidth() * this.scalingX / (float)this.extentWx));
                switch (style) {
                    case 1: {
                        cb.setLineDash(18.0f, 6.0f, 0.0f);
                        break block0;
                    }
                    case 3: {
                        cb.writeLiteral("[9 6 3 6]0 d\n");
                        break block0;
                    }
                    case 4: {
                        cb.writeLiteral("[9 3 3 3 3 3]0 d\n");
                        break block0;
                    }
                    case 2: {
                        cb.setLineDash(3.0f, 0.0f);
                        break block0;
                    }
                }
                cb.setLineDash(0.0f);
                break;
            }
            case 3: {
                this.currentFont = (MetaFont)obj;
            }
        }
    }

    public void deleteMetaObject(int index) {
        this.metaObjects.set(index, null);
    }

    public void saveState(PdfCanvas cb) {
        cb.saveState();
        MetaState state = new MetaState(this);
        this.savedStates.push(state);
    }

    public void restoreState(int index, PdfCanvas cb) {
        int pops = index < 0 ? Math.min(-index, this.savedStates.size()) : Math.max(this.savedStates.size() - index, 0);
        if (pops == 0) {
            return;
        }
        MetaState state = null;
        while (pops-- != 0) {
            cb.restoreState();
            state = this.savedStates.pop();
        }
        this.setMetaState(state);
    }

    public void cleanup(PdfCanvas cb) {
        int k = this.savedStates.size();
        while (k-- > 0) {
            cb.restoreState();
        }
    }

    public float transformX(int x) {
        return ((float)x - (float)this.offsetWx) * this.scalingX / (float)this.extentWx;
    }

    public float transformY(int y) {
        return (1.0f - ((float)y - (float)this.offsetWy) / (float)this.extentWy) * this.scalingY;
    }

    public void setScalingX(float scalingX) {
        this.scalingX = scalingX;
    }

    public void setScalingY(float scalingY) {
        this.scalingY = scalingY;
    }

    public void setOffsetWx(int offsetWx) {
        this.offsetWx = offsetWx;
    }

    public void setOffsetWy(int offsetWy) {
        this.offsetWy = offsetWy;
    }

    public void setExtentWx(int extentWx) {
        this.extentWx = extentWx;
    }

    public void setExtentWy(int extentWy) {
        this.extentWy = extentWy;
    }

    public float transformAngle(float angle) {
        float ta = this.scalingY < 0.0f ? -angle : angle;
        return (float)(this.scalingX < 0.0f ? Math.PI - (double)ta : (double)ta);
    }

    public void setCurrentPoint(Point p) {
        this.currentPoint = p;
    }

    public Point getCurrentPoint() {
        return this.currentPoint;
    }

    public MetaBrush getCurrentBrush() {
        return this.currentBrush;
    }

    public MetaPen getCurrentPen() {
        return this.currentPen;
    }

    public MetaFont getCurrentFont() {
        return this.currentFont;
    }

    public Color getCurrentBackgroundColor() {
        return this.currentBackgroundColor;
    }

    public void setCurrentBackgroundColor(Color currentBackgroundColor) {
        this.currentBackgroundColor = currentBackgroundColor;
    }

    public Color getCurrentTextColor() {
        return this.currentTextColor;
    }

    public void setCurrentTextColor(Color currentTextColor) {
        this.currentTextColor = currentTextColor;
    }

    public int getBackgroundMode() {
        return this.backgroundMode;
    }

    public void setBackgroundMode(int backgroundMode) {
        this.backgroundMode = backgroundMode;
    }

    public int getTextAlign() {
        return this.textAlign;
    }

    public void setTextAlign(int textAlign) {
        this.textAlign = textAlign;
    }

    public int getPolyFillMode() {
        return this.polyFillMode;
    }

    public void setPolyFillMode(int polyFillMode) {
        this.polyFillMode = polyFillMode;
    }

    public void setLineJoinRectangle(PdfCanvas cb) {
        if (this.lineJoin != 0) {
            this.lineJoin = 0;
            cb.setLineJoinStyle(0);
        }
    }

    public void setLineJoinPolygon(PdfCanvas cb) {
        if (this.lineJoin == 0) {
            this.lineJoin = 1;
            cb.setLineJoinStyle(1);
        }
    }

    public boolean getLineNeutral() {
        return this.lineJoin == 0;
    }
}

