/*
 * Decompiled with CFR 0.152.
 */
package com.himanshoe.charty.radar.config;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.graphics.Color;
import androidx.compose.ui.graphics.ColorKt;
import com.himanshoe.charty.color.ChartyColor;
import com.himanshoe.charty.radar.config.RadarGridStyle;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b \n\u0002\u0010\u000e\n\u0000\b\u0087\b\u0018\u00002\u00020\u0001Ba\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\n\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u0012\b\b\u0002\u0010\u000e\u001a\u00020\r\u0012\b\b\u0002\u0010\u000f\u001a\u00020\n\u00a2\u0006\u0004\b\u0010\u0010\u0011J\t\u0010 \u001a\u00020\u0003H\u00c6\u0003J\t\u0010!\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\"\u001a\u00020\u0007H\u00c6\u0003J\t\u0010#\u001a\u00020\u0007H\u00c6\u0003J\t\u0010$\u001a\u00020\nH\u00c6\u0003J\t\u0010%\u001a\u00020\nH\u00c6\u0003J\t\u0010&\u001a\u00020\rH\u00c6\u0003J\t\u0010'\u001a\u00020\rH\u00c6\u0003J\t\u0010(\u001a\u00020\nH\u00c6\u0003Jc\u0010)\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u00072\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\n2\b\b\u0002\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\r2\b\b\u0002\u0010\u000f\u001a\u00020\nH\u00c6\u0001J\u0013\u0010*\u001a\u00020\u00072\b\u0010+\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010,\u001a\u00020\u0005H\u00d6\u0001J\t\u0010-\u001a\u00020.H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0017R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u000b\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001aR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u000e\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001dR\u0011\u0010\u000f\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u001a\u00a8\u0006/"}, d2={"Lcom/himanshoe/charty/radar/config/RadarGridConfig;", "", "gridStyle", "Lcom/himanshoe/charty/radar/config/RadarGridStyle;", "numberOfGridLevels", "", "showGridLines", "", "showAxisLines", "gridLineWidth", "", "axisLineWidth", "gridLineColor", "Lcom/himanshoe/charty/color/ChartyColor;", "axisLineColor", "gridLineAlpha", "<init>", "(Lcom/himanshoe/charty/radar/config/RadarGridStyle;IZZFFLcom/himanshoe/charty/color/ChartyColor;Lcom/himanshoe/charty/color/ChartyColor;F)V", "getGridStyle", "()Lcom/himanshoe/charty/radar/config/RadarGridStyle;", "getNumberOfGridLevels", "()I", "getShowGridLines", "()Z", "getShowAxisLines", "getGridLineWidth", "()F", "getAxisLineWidth", "getGridLineColor", "()Lcom/himanshoe/charty/color/ChartyColor;", "getAxisLineColor", "getGridLineAlpha", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "equals", "other", "hashCode", "toString", "", "charty_release"})
@StabilityInferred(parameters=1)
@SourceDebugExtension(value={"SMAP\nRadarChartConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RadarChartConfig.kt\ncom/himanshoe/charty/radar/config/RadarGridConfig\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,154:1\n1#2:155\n*E\n"})
public final class RadarGridConfig {
    @NotNull
    private final RadarGridStyle gridStyle;
    private final int numberOfGridLevels;
    private final boolean showGridLines;
    private final boolean showAxisLines;
    private final float gridLineWidth;
    private final float axisLineWidth;
    @NotNull
    private final ChartyColor gridLineColor;
    @NotNull
    private final ChartyColor axisLineColor;
    private final float gridLineAlpha;
    public static final int $stable;

    public RadarGridConfig(@NotNull RadarGridStyle gridStyle, int numberOfGridLevels, boolean showGridLines, boolean showAxisLines, float gridLineWidth, float axisLineWidth, @NotNull ChartyColor gridLineColor, @NotNull ChartyColor axisLineColor, float gridLineAlpha) {
        Intrinsics.checkNotNullParameter((Object)((Object)gridStyle), (String)"gridStyle");
        Intrinsics.checkNotNullParameter((Object)gridLineColor, (String)"gridLineColor");
        Intrinsics.checkNotNullParameter((Object)axisLineColor, (String)"axisLineColor");
        this.gridStyle = gridStyle;
        this.numberOfGridLevels = numberOfGridLevels;
        this.showGridLines = showGridLines;
        this.showAxisLines = showAxisLines;
        this.gridLineWidth = gridLineWidth;
        this.axisLineWidth = axisLineWidth;
        this.gridLineColor = gridLineColor;
        this.axisLineColor = axisLineColor;
        this.gridLineAlpha = gridLineAlpha;
        if (!(this.numberOfGridLevels > 0)) {
            boolean $i$a$-require-RadarGridConfig$52 = false;
            String $i$a$-require-RadarGridConfig$52 = "Number of grid levels must be positive";
            throw new IllegalArgumentException($i$a$-require-RadarGridConfig$52.toString());
        }
        if (!(this.gridLineWidth > 0.0f)) {
            boolean $i$a$-require-RadarGridConfig$62 = false;
            String $i$a$-require-RadarGridConfig$62 = "Grid line width must be positive";
            throw new IllegalArgumentException($i$a$-require-RadarGridConfig$62.toString());
        }
        if (!(this.axisLineWidth > 0.0f)) {
            boolean $i$a$-require-RadarGridConfig$72 = false;
            String $i$a$-require-RadarGridConfig$72 = "Axis line width must be positive";
            throw new IllegalArgumentException($i$a$-require-RadarGridConfig$72.toString());
        }
        float f = this.gridLineAlpha;
        if (!(0.0f <= f ? f <= 1.0f : false)) {
            boolean bl = false;
            String string2 = "Grid line alpha must be between 0 and 1";
            throw new IllegalArgumentException(string2.toString());
        }
    }

    public /* synthetic */ RadarGridConfig(RadarGridStyle radarGridStyle, int n, boolean bl, boolean bl2, float f, float f2, ChartyColor chartyColor, ChartyColor chartyColor2, float f3, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            radarGridStyle = RadarGridStyle.POLYGON;
        }
        if ((n2 & 2) != 0) {
            n = 5;
        }
        if ((n2 & 4) != 0) {
            bl = true;
        }
        if ((n2 & 8) != 0) {
            bl2 = true;
        }
        if ((n2 & 0x10) != 0) {
            f = 1.0f;
        }
        if ((n2 & 0x20) != 0) {
            f2 = 1.0f;
        }
        if ((n2 & 0x40) != 0) {
            chartyColor = new ChartyColor.Solid(Color.copy-wmQWz5c$default((long)ColorKt.Color((long)0xFFBDBDBDL), (float)0.5f, (float)0.0f, (float)0.0f, (float)0.0f, (int)14, null), null);
        }
        if ((n2 & 0x80) != 0) {
            chartyColor2 = new ChartyColor.Solid(Color.copy-wmQWz5c$default((long)ColorKt.Color((long)0xFF9E9E9EL), (float)0.6f, (float)0.0f, (float)0.0f, (float)0.0f, (int)14, null), null);
        }
        if ((n2 & 0x100) != 0) {
            f3 = 0.5f;
        }
        this(radarGridStyle, n, bl, bl2, f, f2, chartyColor, chartyColor2, f3);
    }

    @NotNull
    public final RadarGridStyle getGridStyle() {
        return this.gridStyle;
    }

    public final int getNumberOfGridLevels() {
        return this.numberOfGridLevels;
    }

    public final boolean getShowGridLines() {
        return this.showGridLines;
    }

    public final boolean getShowAxisLines() {
        return this.showAxisLines;
    }

    public final float getGridLineWidth() {
        return this.gridLineWidth;
    }

    public final float getAxisLineWidth() {
        return this.axisLineWidth;
    }

    @NotNull
    public final ChartyColor getGridLineColor() {
        return this.gridLineColor;
    }

    @NotNull
    public final ChartyColor getAxisLineColor() {
        return this.axisLineColor;
    }

    public final float getGridLineAlpha() {
        return this.gridLineAlpha;
    }

    @NotNull
    public final RadarGridStyle component1() {
        return this.gridStyle;
    }

    public final int component2() {
        return this.numberOfGridLevels;
    }

    public final boolean component3() {
        return this.showGridLines;
    }

    public final boolean component4() {
        return this.showAxisLines;
    }

    public final float component5() {
        return this.gridLineWidth;
    }

    public final float component6() {
        return this.axisLineWidth;
    }

    @NotNull
    public final ChartyColor component7() {
        return this.gridLineColor;
    }

    @NotNull
    public final ChartyColor component8() {
        return this.axisLineColor;
    }

    public final float component9() {
        return this.gridLineAlpha;
    }

    @NotNull
    public final RadarGridConfig copy(@NotNull RadarGridStyle gridStyle, int numberOfGridLevels, boolean showGridLines, boolean showAxisLines, float gridLineWidth, float axisLineWidth, @NotNull ChartyColor gridLineColor, @NotNull ChartyColor axisLineColor, float gridLineAlpha) {
        Intrinsics.checkNotNullParameter((Object)((Object)gridStyle), (String)"gridStyle");
        Intrinsics.checkNotNullParameter((Object)gridLineColor, (String)"gridLineColor");
        Intrinsics.checkNotNullParameter((Object)axisLineColor, (String)"axisLineColor");
        return new RadarGridConfig(gridStyle, numberOfGridLevels, showGridLines, showAxisLines, gridLineWidth, axisLineWidth, gridLineColor, axisLineColor, gridLineAlpha);
    }

    public static /* synthetic */ RadarGridConfig copy$default(RadarGridConfig radarGridConfig, RadarGridStyle radarGridStyle, int n, boolean bl, boolean bl2, float f, float f2, ChartyColor chartyColor, ChartyColor chartyColor2, float f3, int n2, Object object) {
        if ((n2 & 1) != 0) {
            radarGridStyle = radarGridConfig.gridStyle;
        }
        if ((n2 & 2) != 0) {
            n = radarGridConfig.numberOfGridLevels;
        }
        if ((n2 & 4) != 0) {
            bl = radarGridConfig.showGridLines;
        }
        if ((n2 & 8) != 0) {
            bl2 = radarGridConfig.showAxisLines;
        }
        if ((n2 & 0x10) != 0) {
            f = radarGridConfig.gridLineWidth;
        }
        if ((n2 & 0x20) != 0) {
            f2 = radarGridConfig.axisLineWidth;
        }
        if ((n2 & 0x40) != 0) {
            chartyColor = radarGridConfig.gridLineColor;
        }
        if ((n2 & 0x80) != 0) {
            chartyColor2 = radarGridConfig.axisLineColor;
        }
        if ((n2 & 0x100) != 0) {
            f3 = radarGridConfig.gridLineAlpha;
        }
        return radarGridConfig.copy(radarGridStyle, n, bl, bl2, f, f2, chartyColor, chartyColor2, f3);
    }

    @NotNull
    public String toString() {
        return "RadarGridConfig(gridStyle=" + this.gridStyle + ", numberOfGridLevels=" + this.numberOfGridLevels + ", showGridLines=" + this.showGridLines + ", showAxisLines=" + this.showAxisLines + ", gridLineWidth=" + this.gridLineWidth + ", axisLineWidth=" + this.axisLineWidth + ", gridLineColor=" + this.gridLineColor + ", axisLineColor=" + this.axisLineColor + ", gridLineAlpha=" + this.gridLineAlpha + ")";
    }

    public int hashCode() {
        int result = this.gridStyle.hashCode();
        result = result * 31 + Integer.hashCode(this.numberOfGridLevels);
        result = result * 31 + Boolean.hashCode(this.showGridLines);
        result = result * 31 + Boolean.hashCode(this.showAxisLines);
        result = result * 31 + Float.hashCode(this.gridLineWidth);
        result = result * 31 + Float.hashCode(this.axisLineWidth);
        result = result * 31 + this.gridLineColor.hashCode();
        result = result * 31 + this.axisLineColor.hashCode();
        result = result * 31 + Float.hashCode(this.gridLineAlpha);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof RadarGridConfig)) {
            return false;
        }
        RadarGridConfig radarGridConfig = (RadarGridConfig)other;
        if (this.gridStyle != radarGridConfig.gridStyle) {
            return false;
        }
        if (this.numberOfGridLevels != radarGridConfig.numberOfGridLevels) {
            return false;
        }
        if (this.showGridLines != radarGridConfig.showGridLines) {
            return false;
        }
        if (this.showAxisLines != radarGridConfig.showAxisLines) {
            return false;
        }
        if (Float.compare(this.gridLineWidth, radarGridConfig.gridLineWidth) != 0) {
            return false;
        }
        if (Float.compare(this.axisLineWidth, radarGridConfig.axisLineWidth) != 0) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.gridLineColor, (Object)radarGridConfig.gridLineColor)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.axisLineColor, (Object)radarGridConfig.axisLineColor)) {
            return false;
        }
        return Float.compare(this.gridLineAlpha, radarGridConfig.gridLineAlpha) == 0;
    }

    public RadarGridConfig() {
        this(null, 0, false, false, 0.0f, 0.0f, null, null, 0.0f, 511, null);
    }
}

