/*
 * Decompiled with CFR 0.152.
 */
package com.himanshoe.charty.combo.internal;

import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.geometry.Rect;
import com.himanshoe.charty.combo.config.ComboChartConfig;
import com.himanshoe.charty.combo.data.ComboChartData;
import com.himanshoe.charty.combo.internal.BarDimensions;
import com.himanshoe.charty.common.ChartContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000D\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\u001a \u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00050\u0001H\u0000\u001aJ\u0010\u0006\u001a\u00020\u0007*\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00050\t0\b2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00050\u00012\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0000\u001a(\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u000fH\u0000\u00a8\u0006\u0016"}, d2={"calculateLinePointPositions", "", "Landroidx/compose/ui/geometry/Offset;", "Lcom/himanshoe/charty/common/ChartContext;", "dataList", "Lcom/himanshoe/charty/combo/data/ComboChartData;", "addPointHitAreas", "", "", "Lkotlin/Pair;", "Landroidx/compose/ui/geometry/Rect;", "pointPositions", "comboConfig", "Lcom/himanshoe/charty/combo/config/ComboChartConfig;", "animationProgress", "", "calculateAnimatedBarDimensions", "Lcom/himanshoe/charty/combo/internal/BarDimensions;", "barValueY", "baselineY", "isNegative", "", "charty_release"})
@SourceDebugExtension(value={"SMAP\nComboChartHelpers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ComboChartHelpers.kt\ncom/himanshoe/charty/combo/internal/ComboChartHelpersKt\n+ 2 ListUtils.kt\nandroidx/compose/ui/util/ListUtilsKt\n+ 3 Offset.kt\nandroidx/compose/ui/geometry/OffsetKt\n+ 4 InlineClassHelper.kt\nandroidx/compose/ui/util/InlineClassHelperKt\n+ 5 Offset.kt\nandroidx/compose/ui/geometry/Offset\n+ 6 InlineClassHelper.jvm.kt\nandroidx/compose/ui/util/InlineClassHelper_jvmKt\n*L\n1#1,80:1\n287#2,2:81\n71#2,3:83\n75#2:90\n289#2:91\n71#2,3:92\n75#2:107\n30#3:86\n53#4,3:87\n60#4:96\n70#4:99\n60#4:102\n70#4:105\n65#5:95\n69#5:98\n65#5:101\n69#5:104\n22#6:97\n22#6:100\n22#6:103\n22#6:106\n*S KotlinDebug\n*F\n+ 1 ComboChartHelpers.kt\ncom/himanshoe/charty/combo/internal/ComboChartHelpersKt\n*L\n17#1:81,2\n17#1:83,3\n17#1:90\n17#1:91\n34#1:92,3\n34#1:107\n18#1:86\n18#1:87,3\n40#1:96\n41#1:99\n42#1:102\n43#1:105\n40#1:95\n41#1:98\n42#1:101\n43#1:104\n40#1:97\n41#1:100\n42#1:103\n43#1:106\n*E\n"})
public final class ComboChartHelpersKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Offset> calculateLinePointPositions(@NotNull ChartContext $this$calculateLinePointPositions, @NotNull List<ComboChartData> dataList) {
        Intrinsics.checkNotNullParameter((Object)$this$calculateLinePointPositions, (String)"<this>");
        Intrinsics.checkNotNullParameter(dataList, (String)"dataList");
        List<ComboChartData> $this$fastMapIndexed$iv = dataList;
        boolean $i$f$fastMapIndexed = false;
        ArrayList target$iv = new ArrayList($this$fastMapIndexed$iv.size());
        List<ComboChartData> $this$fastForEachIndexed$iv$iv = $this$fastMapIndexed$iv;
        boolean $i$f$fastForEachIndexed = false;
        int index$iv$iv = 0;
        int n = ((Collection)$this$fastForEachIndexed$iv$iv).size();
        while (index$iv$iv < n) {
            void y$iv;
            void x$iv;
            void comboData;
            void index;
            void e$iv;
            ComboChartData item$iv$iv;
            ComboChartData comboChartData = item$iv$iv = $this$fastForEachIndexed$iv$iv.get(index$iv$iv);
            int index$iv = index$iv$iv++;
            boolean bl = false;
            ComboChartData comboChartData2 = (ComboChartData)e$iv;
            int n2 = index$iv;
            Collection collection = target$iv;
            boolean bl2 = false;
            float f = $this$calculateLinePointPositions.calculateCenteredXPosition((int)index, dataList.size());
            float f2 = $this$calculateLinePointPositions.convertValueToYPosition(comboData.getLineValue());
            boolean $i$f$Offset = false;
            boolean $i$f$packFloats = false;
            long v1$iv$iv = Float.floatToRawIntBits((float)x$iv);
            long v2$iv$iv = Float.floatToRawIntBits((float)y$iv);
            collection.add(Offset.box-impl((long)Offset.constructor-impl((long)(v1$iv$iv << 32 | v2$iv$iv & 0xFFFFFFFFL))));
        }
        return target$iv;
    }

    /*
     * WARNING - void declaration
     */
    public static final void addPointHitAreas(@NotNull List<Pair<Rect, ComboChartData>> $this$addPointHitAreas, @NotNull List<Offset> pointPositions, @NotNull List<ComboChartData> dataList, @NotNull ComboChartConfig comboConfig, float animationProgress) {
        Intrinsics.checkNotNullParameter($this$addPointHitAreas, (String)"<this>");
        Intrinsics.checkNotNullParameter(pointPositions, (String)"pointPositions");
        Intrinsics.checkNotNullParameter(dataList, (String)"dataList");
        Intrinsics.checkNotNullParameter((Object)comboConfig, (String)"comboConfig");
        List<Offset> $this$fastForEachIndexed$iv = pointPositions;
        boolean $i$f$fastForEachIndexed = false;
        int n = ((Collection)$this$fastForEachIndexed$iv).size();
        for (int index$iv = 0; index$iv < n; ++index$iv) {
            void position;
            Offset item$iv = $this$fastForEachIndexed$iv.get(index$iv);
            long l = item$iv.unbox-impl();
            int index = index$iv;
            boolean bl = false;
            float pointProgress = (float)index / (float)(pointPositions.size() - 1);
            if (!(pointProgress <= animationProgress)) continue;
            float hitRadius = comboConfig.getPointRadius() * 2.0f;
            void arg0$iv = position;
            boolean bl2 = false;
            void value$iv$iv = arg0$iv;
            boolean $i$f$unpackFloat1 = false;
            int bits$iv$iv$iv = (int)(value$iv$iv >> 32);
            boolean $i$f$floatFromBits = false;
            float f = Float.intBitsToFloat(bits$iv$iv$iv) - hitRadius;
            arg0$iv = position;
            boolean bl3 = false;
            value$iv$iv = arg0$iv;
            boolean $i$f$unpackFloat2 = false;
            bits$iv$iv$iv = (int)(value$iv$iv & 0xFFFFFFFFL);
            $i$f$floatFromBits = false;
            float f2 = Float.intBitsToFloat(bits$iv$iv$iv) - hitRadius;
            arg0$iv = position;
            bl2 = false;
            value$iv$iv = arg0$iv;
            $i$f$unpackFloat1 = false;
            bits$iv$iv$iv = (int)(value$iv$iv >> 32);
            $i$f$floatFromBits = false;
            float f3 = Float.intBitsToFloat(bits$iv$iv$iv) + hitRadius;
            arg0$iv = position;
            bl3 = false;
            value$iv$iv = arg0$iv;
            $i$f$unpackFloat2 = false;
            bits$iv$iv$iv = (int)(value$iv$iv & 0xFFFFFFFFL);
            $i$f$floatFromBits = false;
            $this$addPointHitAreas.add((Pair<Rect, ComboChartData>)TuplesKt.to((Object)new Rect(f, f2, f3, Float.intBitsToFloat(bits$iv$iv$iv) + hitRadius), (Object)dataList.get(index)));
        }
    }

    @NotNull
    public static final BarDimensions calculateAnimatedBarDimensions(float barValueY, float baselineY, boolean isNegative, float animationProgress) {
        BarDimensions barDimensions;
        if (isNegative) {
            float fullBarHeight = barValueY - baselineY;
            barDimensions = new BarDimensions(baselineY, fullBarHeight * animationProgress);
        } else {
            float fullBarHeight = baselineY - barValueY;
            float animatedBarHeight = fullBarHeight * animationProgress;
            barDimensions = new BarDimensions(baselineY - animatedBarHeight, animatedBarHeight);
        }
        return barDimensions;
    }
}

