/*
 * Decompiled with CFR 0.152.
 */
package com.himanshoe.charty.circular.internal;

import kotlin.Metadata;
import kotlin.ranges.RangesKt;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u0012\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\u001a(\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u001a(\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\u0001H\u0000\u00a8\u0006\n"}, d2={"calculateStrokeWidth", "", "radius", "centerHoleRatio", "gapBetweenRings", "ringCount", "", "calculateRingRadius", "index", "strokeWidth", "charty_release"})
public final class CircularProgressHelpersKt {
    public static final float calculateStrokeWidth(float radius, float centerHoleRatio, float gapBetweenRings, int ringCount) {
        if (ringCount == 0) {
            return 0.0f;
        }
        float centerHoleSize = radius * centerHoleRatio;
        float availableRadius = radius - centerHoleSize;
        float totalGapSpace = gapBetweenRings * (float)(ringCount - 1);
        float availableForStrokes = availableRadius - totalGapSpace;
        return RangesKt.coerceAtLeast((float)(availableForStrokes / (float)ringCount), (float)1.0f);
    }

    public static final float calculateRingRadius(int index, float radius, float gapBetweenRings, float strokeWidth) {
        float accumulatedWidth = (float)index * (strokeWidth + gapBetweenRings);
        return radius - accumulatedWidth - strokeWidth / 2.0f;
    }
}

