package com.himanshoe.charty.line.internal.area

import androidx.compose.ui.Modifier
import androidx.compose.ui.geometry.Offset
import com.himanshoe.charty.common.gesture.createPointTooltipState
import com.himanshoe.charty.common.gesture.pointChartClickHandler
import com.himanshoe.charty.common.tooltip.TooltipState
import com.himanshoe.charty.line.config.LineChartConfig
import com.himanshoe.charty.line.data.LineData
import com.himanshoe.charty.line.internal.line.LineChartConstants

/**
 * Creates a modifier with click handling for area chart.
 */
internal fun createAreaChartModifier(
    onPointClick: ((LineData) -> Unit)?,
    dataList: List<LineData>,
    lineConfig: LineChartConfig,
    pointBounds: List<Pair<Offset, LineData>>,
    onTooltipUpdate: (TooltipState?) -> Unit,
    modifier: Modifier = Modifier,
): Modifier {
    return if (onPointClick != null) {
        modifier.pointChartClickHandler(
            dataList = dataList,
            pointBounds = pointBounds,
            tapRadius = lineConfig.pointRadius * LineChartConstants.TAP_RADIUS_MULTIPLIER,
            onPointClick = onPointClick,
            onTooltipStateChange = onTooltipUpdate,
            createTooltipContent = { lineData, position ->
                createPointTooltipState(
                    content = lineConfig.tooltipFormatter(lineData),
                    position = position,
                    pointRadius = lineConfig.pointRadius,
                    tooltipPosition = lineConfig.tooltipPosition,
                    pointRadiusMultiplier = LineChartConstants.POINT_RADIUS_MULTIPLIER,
                )
            },
        )
    } else {
        modifier
    }
}


