/*
 * Decompiled with CFR 0.152.
 */
package com.himanshoe.charty.radar.data;

import androidx.compose.runtime.internal.StabilityInferred;
import com.himanshoe.charty.color.ChartyColor;
import com.himanshoe.charty.radar.data.RadarAxisData;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0087\b\u0018\u0000  2\u00020\u0001:\u0001 B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\bH\u00c6\u0003J\t\u0010\u0018\u001a\u00020\nH\u00c6\u0003J7\u0010\u0019\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\nH\u00c6\u0001J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001J\t\u0010\u001f\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006!"}, d2={"Lcom/himanshoe/charty/radar/data/RadarDataSet;", "", "label", "", "axes", "", "Lcom/himanshoe/charty/radar/data/RadarAxisData;", "color", "Lcom/himanshoe/charty/color/ChartyColor;", "fillAlpha", "", "<init>", "(Ljava/lang/String;Ljava/util/List;Lcom/himanshoe/charty/color/ChartyColor;F)V", "getLabel", "()Ljava/lang/String;", "getAxes", "()Ljava/util/List;", "getColor", "()Lcom/himanshoe/charty/color/ChartyColor;", "getFillAlpha", "()F", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "Companion", "charty_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nRadarData.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RadarData.kt\ncom/himanshoe/charty/radar/data/RadarDataSet\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,62:1\n1#2:63\n*E\n"})
public final class RadarDataSet {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String label;
    @NotNull
    private final List<RadarAxisData> axes;
    @NotNull
    private final ChartyColor color;
    private final float fillAlpha;
    public static final int $stable = 8;
    private static final int MIN_AXES = 3;
    private static final float DEFAULT_FILL_ALPHA = 0.3f;

    public RadarDataSet(@NotNull String label, @NotNull List<RadarAxisData> axes, @NotNull ChartyColor color, float fillAlpha) {
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        Intrinsics.checkNotNullParameter(axes, (String)"axes");
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        this.label = label;
        this.axes = axes;
        this.color = color;
        this.fillAlpha = fillAlpha;
        if (!(!StringsKt.isBlank((CharSequence)this.label))) {
            boolean $i$a$-require-RadarDataSet$52 = false;
            String $i$a$-require-RadarDataSet$52 = "Dataset label cannot be blank";
            throw new IllegalArgumentException($i$a$-require-RadarDataSet$52.toString());
        }
        if (!(!((Collection)this.axes).isEmpty())) {
            boolean $i$a$-require-RadarDataSet$62 = false;
            String $i$a$-require-RadarDataSet$62 = "Dataset must have at least one axis";
            throw new IllegalArgumentException($i$a$-require-RadarDataSet$62.toString());
        }
        if (!(this.axes.size() >= 3)) {
            boolean $i$a$-require-RadarDataSet$72 = false;
            String $i$a$-require-RadarDataSet$72 = "Radar chart requires at least 3 axes, got: " + this.axes.size();
            throw new IllegalArgumentException($i$a$-require-RadarDataSet$72.toString());
        }
        float f = this.fillAlpha;
        if (!(0.0f <= f ? f <= 1.0f : false)) {
            boolean bl = false;
            String string2 = "Fill alpha must be between 0 and 1, got: " + this.fillAlpha;
            throw new IllegalArgumentException(string2.toString());
        }
    }

    public /* synthetic */ RadarDataSet(String string2, List list, ChartyColor chartyColor, float f, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            f = 0.3f;
        }
        this(string2, list, chartyColor, f);
    }

    @NotNull
    public final String getLabel() {
        return this.label;
    }

    @NotNull
    public final List<RadarAxisData> getAxes() {
        return this.axes;
    }

    @NotNull
    public final ChartyColor getColor() {
        return this.color;
    }

    public final float getFillAlpha() {
        return this.fillAlpha;
    }

    @NotNull
    public final String component1() {
        return this.label;
    }

    @NotNull
    public final List<RadarAxisData> component2() {
        return this.axes;
    }

    @NotNull
    public final ChartyColor component3() {
        return this.color;
    }

    public final float component4() {
        return this.fillAlpha;
    }

    @NotNull
    public final RadarDataSet copy(@NotNull String label, @NotNull List<RadarAxisData> axes, @NotNull ChartyColor color, float fillAlpha) {
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        Intrinsics.checkNotNullParameter(axes, (String)"axes");
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        return new RadarDataSet(label, axes, color, fillAlpha);
    }

    public static /* synthetic */ RadarDataSet copy$default(RadarDataSet radarDataSet, String string2, List list, ChartyColor chartyColor, float f, int n, Object object) {
        if ((n & 1) != 0) {
            string2 = radarDataSet.label;
        }
        if ((n & 2) != 0) {
            list = radarDataSet.axes;
        }
        if ((n & 4) != 0) {
            chartyColor = radarDataSet.color;
        }
        if ((n & 8) != 0) {
            f = radarDataSet.fillAlpha;
        }
        return radarDataSet.copy(string2, list, chartyColor, f);
    }

    @NotNull
    public String toString() {
        return "RadarDataSet(label=" + this.label + ", axes=" + this.axes + ", color=" + this.color + ", fillAlpha=" + this.fillAlpha + ")";
    }

    public int hashCode() {
        int result = this.label.hashCode();
        result = result * 31 + ((Object)this.axes).hashCode();
        result = result * 31 + this.color.hashCode();
        result = result * 31 + Float.hashCode(this.fillAlpha);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof RadarDataSet)) {
            return false;
        }
        RadarDataSet radarDataSet = (RadarDataSet)other;
        if (!Intrinsics.areEqual((Object)this.label, (Object)radarDataSet.label)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.axes, radarDataSet.axes)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.color, (Object)radarDataSet.color)) {
            return false;
        }
        return Float.compare(this.fillAlpha, radarDataSet.fillAlpha) == 0;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/himanshoe/charty/radar/data/RadarDataSet$Companion;", "", "<init>", "()V", "MIN_AXES", "", "DEFAULT_FILL_ALPHA", "", "charty_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

