/*
 * Decompiled with CFR 0.152.
 */
package com.himanshoe.charty.bar.internal.bar.stacked;

import androidx.compose.ui.geometry.CornerRadius;
import androidx.compose.ui.geometry.Rect;
import androidx.compose.ui.geometry.RoundRect;
import androidx.compose.ui.graphics.AndroidPath_androidKt;
import androidx.compose.ui.graphics.Brush;
import androidx.compose.ui.graphics.Path;
import androidx.compose.ui.graphics.drawscope.DrawScope;
import androidx.compose.ui.text.TextMeasurer;
import com.himanshoe.charty.bar.config.StackedBarChartConfig;
import com.himanshoe.charty.bar.config.StackedBarSegment;
import com.himanshoe.charty.bar.data.BarGroup;
import com.himanshoe.charty.bar.internal.bar.stacked.StackedBarDrawParams;
import com.himanshoe.charty.color.ChartyColor;
import com.himanshoe.charty.common.ChartContext;
import com.himanshoe.charty.common.ChartOrientation;
import com.himanshoe.charty.common.draw.ChartDrawUtilsKt;
import com.himanshoe.charty.common.tooltip.TooltipState;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000D\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u001aD\u0010\u0005\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001a$\u0010\u0010\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0000\u001a.\u0010\u0017\u001a\u00020\u0001*\u00020\u00022\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u0014H\u0000\u00a8\u0006\u001a"}, d2={"drawStackedBars", "", "Landroidx/compose/ui/graphics/drawscope/DrawScope;", "params", "Lcom/himanshoe/charty/bar/internal/bar/stacked/StackedBarDrawParams;", "drawStackedSegment", "brush", "Landroidx/compose/ui/graphics/Brush;", "x", "", "y", "width", "height", "cornerRadius", "isTopSegment", "", "drawStackedReferenceLineIfNeeded", "stackedConfig", "Lcom/himanshoe/charty/bar/config/StackedBarChartConfig;", "chartContext", "Lcom/himanshoe/charty/common/ChartContext;", "textMeasurer", "Landroidx/compose/ui/text/TextMeasurer;", "drawStackedTooltipIfNeeded", "tooltipState", "Lcom/himanshoe/charty/common/tooltip/TooltipState;", "charty_release"})
@SourceDebugExtension(value={"SMAP\nStackedBarChartDrawer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StackedBarChartDrawer.kt\ncom/himanshoe/charty/bar/internal/bar/stacked/StackedBarChartDrawerKt\n+ 2 ListUtils.kt\nandroidx/compose/ui/util/ListUtilsKt\n+ 3 CornerRadius.kt\nandroidx/compose/ui/geometry/CornerRadiusKt\n+ 4 InlineClassHelper.kt\nandroidx/compose/ui/util/InlineClassHelperKt\n*L\n1#1,161:1\n71#2,3:162\n71#2,5:165\n75#2:170\n33#3:171\n33#3:175\n53#4,3:172\n53#4,3:176\n*S KotlinDebug\n*F\n+ 1 StackedBarChartDrawer.kt\ncom/himanshoe/charty/bar/internal/bar/stacked/StackedBarChartDrawerKt\n*L\n22#1:162,3\n34#1:165,5\n22#1:170\n108#1:171\n109#1:175\n108#1:172,3\n109#1:176,3\n*E\n"})
public final class StackedBarChartDrawerKt {
    /*
     * WARNING - void declaration
     */
    public static final void drawStackedBars(@NotNull DrawScope $this$drawStackedBars, @NotNull StackedBarDrawParams params) {
        Intrinsics.checkNotNullParameter((Object)$this$drawStackedBars, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        List<BarGroup> $this$fastForEachIndexed$iv = params.getDataList();
        boolean $i$f$fastForEachIndexed = false;
        int n = ((Collection)$this$fastForEachIndexed$iv).size();
        for (int index$iv = 0; index$iv < n; ++index$iv) {
            void barGroup;
            BarGroup item$iv;
            BarGroup barGroup2 = item$iv = $this$fastForEachIndexed$iv.get(index$iv);
            int groupIndex = index$iv;
            boolean bl = false;
            float barX = params.getChartContext().calculateBarLeftPosition(groupIndex, params.getDataList().size(), params.getStackedConfig().getBarWidthFraction());
            float barWidth = params.getChartContext().calculateBarWidth(params.getDataList().size(), params.getStackedConfig().getBarWidthFraction());
            float cumulativeValue = 0.0f;
            List<Float> $this$fastForEachIndexed$iv2 = barGroup.getValues();
            boolean $i$f$fastForEachIndexed2 = false;
            int n2 = ((Collection)$this$fastForEachIndexed$iv2).size();
            for (int index$iv2 = 0; index$iv2 < n2; ++index$iv2) {
                void value;
                float segmentTopValue;
                Float item$iv2 = $this$fastForEachIndexed$iv2.get(index$iv2);
                float f = ((Number)item$iv2).floatValue();
                int segmentIndex = index$iv2;
                boolean bl2 = false;
                float segmentBottomValue = cumulativeValue;
                cumulativeValue = segmentTopValue = cumulativeValue + value;
                float segmentBottomY = params.getChartContext().convertValueToYPosition(segmentBottomValue);
                float segmentTopY = params.getChartContext().convertValueToYPosition(segmentTopValue);
                float fullSegmentHeight = segmentBottomY - segmentTopY;
                float animatedHeight = fullSegmentHeight * params.getAnimationProgress();
                float animatedTopY = segmentBottomY - animatedHeight;
                if (params.getOnSegmentClick() != null && animatedHeight > 0.0f) {
                    params.getSegmentBounds().add((Pair<Rect, StackedBarSegment>)TuplesKt.to((Object)new Rect(barX, animatedTopY, barX + barWidth, segmentBottomY), (Object)new StackedBarSegment((BarGroup)barGroup, segmentIndex, (float)value)));
                }
                ChartyColor segmentChartyColor = barGroup.getColors() != null && segmentIndex < barGroup.getColors().size() ? barGroup.getColors().get(segmentIndex) : (ChartyColor)new ChartyColor.Solid(params.getColorList().get(segmentIndex % params.getColorList().size()).unbox-impl(), null);
                boolean isTopSegment = segmentIndex == barGroup.getValues().size() - 1;
                Brush segmentBrush = Brush.Companion.verticalGradient-8A-3gB4$default((Brush.Companion)Brush.Companion, segmentChartyColor.getValue(), (float)animatedTopY, (float)(animatedTopY + animatedHeight), (int)0, (int)8, null);
                StackedBarChartDrawerKt.drawStackedSegment($this$drawStackedBars, segmentBrush, barX, animatedTopY, barWidth, animatedHeight, isTopSegment ? params.getStackedConfig().getTopCornerRadius().getValue() : 0.0f, isTopSegment);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void drawStackedSegment(DrawScope $this$drawStackedSegment, Brush brush, float x, float y, float width, float height, float cornerRadius, boolean isTopSegment) {
        Path path;
        Path $this$drawStackedSegment_u24lambda_u240 = path = AndroidPath_androidKt.Path();
        boolean bl = false;
        if (isTopSegment && cornerRadius > 0.0f) {
            void x$iv;
            void x$iv2;
            float f = x + width;
            float f2 = y + height;
            float f3 = cornerRadius;
            float y$iv = cornerRadius;
            boolean $i$f$CornerRadius22 = false;
            boolean $i$f$packFloats = false;
            long v1$iv$iv = Float.floatToRawIntBits((float)x$iv2);
            long v2$iv$iv = Float.floatToRawIntBits(y$iv);
            long l = CornerRadius.constructor-impl((long)(v1$iv$iv << 32 | v2$iv$iv & 0xFFFFFFFFL));
            float $i$f$CornerRadius22 = cornerRadius;
            float y$iv2 = cornerRadius;
            boolean $i$f$CornerRadius = false;
            boolean $i$f$packFloats2 = false;
            long v1$iv$iv2 = Float.floatToRawIntBits((float)x$iv);
            long v2$iv$iv2 = Float.floatToRawIntBits(y$iv2);
            long l2 = CornerRadius.constructor-impl((long)(v1$iv$iv2 << 32 | v2$iv$iv2 & 0xFFFFFFFFL));
            long l3 = CornerRadius.Companion.getZero-kKHJgLs();
            long l4 = CornerRadius.Companion.getZero-kKHJgLs();
            Path.addRoundRect$default((Path)$this$drawStackedSegment_u24lambda_u240, (RoundRect)new RoundRect(x, y, f, f2, l, l2, l4, l3, null), null, (int)2, null);
        } else {
            float f = x + width;
            float f4 = y + height;
            long l = CornerRadius.Companion.getZero-kKHJgLs();
            long l5 = CornerRadius.Companion.getZero-kKHJgLs();
            long l6 = CornerRadius.Companion.getZero-kKHJgLs();
            long l7 = CornerRadius.Companion.getZero-kKHJgLs();
            Path.addRoundRect$default((Path)$this$drawStackedSegment_u24lambda_u240, (RoundRect)new RoundRect(x, y, f, f4, l, l5, l7, l6, null), null, (int)2, null);
        }
        Path path2 = path;
        DrawScope.drawPath-GBMwjPU$default((DrawScope)$this$drawStackedSegment, (Path)path2, (Brush)brush, (float)0.0f, null, null, (int)0, (int)60, null);
    }

    public static final void drawStackedReferenceLineIfNeeded(@NotNull DrawScope $this$drawStackedReferenceLineIfNeeded, @NotNull StackedBarChartConfig stackedConfig, @NotNull ChartContext chartContext, @NotNull TextMeasurer textMeasurer) {
        Intrinsics.checkNotNullParameter((Object)$this$drawStackedReferenceLineIfNeeded, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)stackedConfig, (String)"stackedConfig");
        Intrinsics.checkNotNullParameter((Object)chartContext, (String)"chartContext");
        Intrinsics.checkNotNullParameter((Object)textMeasurer, (String)"textMeasurer");
        ChartDrawUtilsKt.drawReferenceLineIfNeeded($this$drawStackedReferenceLineIfNeeded, stackedConfig.getReferenceLine(), chartContext, ChartOrientation.VERTICAL, textMeasurer);
    }

    public static final void drawStackedTooltipIfNeeded(@NotNull DrawScope $this$drawStackedTooltipIfNeeded, @Nullable TooltipState tooltipState, @NotNull StackedBarChartConfig stackedConfig, @NotNull TextMeasurer textMeasurer, @NotNull ChartContext chartContext) {
        Intrinsics.checkNotNullParameter((Object)$this$drawStackedTooltipIfNeeded, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)stackedConfig, (String)"stackedConfig");
        Intrinsics.checkNotNullParameter((Object)textMeasurer, (String)"textMeasurer");
        Intrinsics.checkNotNullParameter((Object)chartContext, (String)"chartContext");
        ChartDrawUtilsKt.drawTooltipIfNeeded($this$drawStackedTooltipIfNeeded, tooltipState, stackedConfig.getTooltipConfig(), textMeasurer, chartContext);
    }
}

