/*
 * Decompiled with CFR 0.152.
 */
package com.himanshoe.charty.bar.internal.bar.barchart;

import androidx.compose.ui.geometry.CornerRadius;
import androidx.compose.ui.geometry.Rect;
import androidx.compose.ui.geometry.RoundRect;
import androidx.compose.ui.graphics.AndroidPath_androidKt;
import androidx.compose.ui.graphics.Brush;
import androidx.compose.ui.graphics.Path;
import androidx.compose.ui.graphics.drawscope.DrawScope;
import androidx.compose.ui.text.TextMeasurer;
import com.himanshoe.charty.bar.config.BarChartConfig;
import com.himanshoe.charty.bar.config.NegativeValuesDrawMode;
import com.himanshoe.charty.bar.data.BarData;
import com.himanshoe.charty.color.ChartyColor;
import com.himanshoe.charty.common.ChartContext;
import com.himanshoe.charty.common.ChartOrientation;
import com.himanshoe.charty.common.draw.ChartDrawUtilsKt;
import com.himanshoe.charty.common.tooltip.TooltipState;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000f\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\u001ar\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0014\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u00102\u0018\u0010\u0011\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00050\u00130\u0012H\u0000\u001a$\u0010\u0015\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0017H\u0000\u001a.\u0010\u0018\u001a\u00020\u0001*\u00020\u00022\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001aL\u0010\u001b\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\u001f\u001a\u00020\u000b2\u0006\u0010 \u001a\u00020\u000b2\u0006\u0010!\u001a\u00020\u000b2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020#2\u0006\u0010%\u001a\u00020\u000bH\u0002\u00a8\u0006&"}, d2={"drawBars", "", "Landroidx/compose/ui/graphics/drawscope/DrawScope;", "dataList", "", "Lcom/himanshoe/charty/bar/data/BarData;", "chartContext", "Lcom/himanshoe/charty/common/ChartContext;", "barConfig", "Lcom/himanshoe/charty/bar/config/BarChartConfig;", "baselineY", "", "animationProgress", "color", "Lcom/himanshoe/charty/color/ChartyColor;", "onBarClick", "Lkotlin/Function1;", "barBounds", "", "Lkotlin/Pair;", "Landroidx/compose/ui/geometry/Rect;", "drawBarReferenceLineIfNeeded", "textMeasurer", "Landroidx/compose/ui/text/TextMeasurer;", "drawBarTooltipIfNeeded", "tooltipState", "Lcom/himanshoe/charty/common/tooltip/TooltipState;", "drawRoundedBar", "brush", "Landroidx/compose/ui/graphics/Brush;", "x", "y", "width", "height", "isNegative", "", "isBelowAxisMode", "cornerRadius", "charty_release"})
@SourceDebugExtension(value={"SMAP\nBarChartDrawer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BarChartDrawer.kt\ncom/himanshoe/charty/bar/internal/bar/barchart/BarChartDrawerKt\n+ 2 ListUtils.kt\nandroidx/compose/ui/util/ListUtilsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 CornerRadius.kt\nandroidx/compose/ui/geometry/CornerRadiusKt\n+ 5 InlineClassHelper.kt\nandroidx/compose/ui/util/InlineClassHelperKt\n*L\n1#1,156:1\n71#2,3:157\n75#2:161\n1#3:160\n33#4:162\n33#4:166\n33#4:170\n33#4:174\n53#5,3:163\n53#5,3:167\n53#5,3:171\n53#5,3:175\n*S KotlinDebug\n*F\n+ 1 BarChartDrawer.kt\ncom/himanshoe/charty/bar/internal/bar/barchart/BarChartDrawerKt\n*L\n35#1:157,3\n35#1:161\n134#1:162\n135#1:166\n145#1:170\n146#1:174\n134#1:163,3\n135#1:167,3\n145#1:171,3\n146#1:175,3\n*E\n"})
public final class BarChartDrawerKt {
    /*
     * WARNING - void declaration
     */
    public static final void drawBars(@NotNull DrawScope $this$drawBars, @NotNull List<BarData> dataList, @NotNull ChartContext chartContext, @NotNull BarChartConfig barConfig, float baselineY, float animationProgress, @NotNull ChartyColor color, @Nullable Function1<? super BarData, Unit> onBarClick, @NotNull List<Pair<Rect, BarData>> barBounds) {
        Intrinsics.checkNotNullParameter((Object)$this$drawBars, (String)"<this>");
        Intrinsics.checkNotNullParameter(dataList, (String)"dataList");
        Intrinsics.checkNotNullParameter((Object)chartContext, (String)"chartContext");
        Intrinsics.checkNotNullParameter((Object)barConfig, (String)"barConfig");
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        Intrinsics.checkNotNullParameter(barBounds, (String)"barBounds");
        List<BarData> $this$fastForEachIndexed$iv = dataList;
        boolean $i$f$fastForEachIndexed = false;
        int n = ((Collection)$this$fastForEachIndexed$iv).size();
        for (int index$iv = 0; index$iv < n; ++index$iv) {
            ChartyColor chartyColor;
            Pair pair;
            boolean isNegative;
            void bar;
            BarData item$iv;
            BarData barData = item$iv = $this$fastForEachIndexed$iv.get(index$iv);
            int index = index$iv;
            boolean bl = false;
            float barX = chartContext.calculateBarLeftPosition(index, dataList.size(), barConfig.getBarWidthFraction());
            float barWidth = chartContext.calculateBarWidth(dataList.size(), barConfig.getBarWidthFraction());
            float barValueY = chartContext.convertValueToYPosition(bar.getValue());
            boolean bl2 = isNegative = bar.getValue() < 0.0f;
            if (isNegative) {
                pair = TuplesKt.to((Object)Float.valueOf(baselineY), (Object)Float.valueOf((barValueY - baselineY) * animationProgress));
            } else {
                float animatedBarHeight = (baselineY - barValueY) * animationProgress;
                pair = TuplesKt.to((Object)Float.valueOf(baselineY - animatedBarHeight), (Object)Float.valueOf(animatedBarHeight));
            }
            Pair pair2 = pair;
            float barTop = ((Number)pair2.component1()).floatValue();
            float barHeight = ((Number)pair2.component2()).floatValue();
            if (onBarClick != null) {
                barBounds.add((Pair<Rect, BarData>)TuplesKt.to((Object)new Rect(barX, barTop, barX + barWidth, barTop + barHeight), (Object)bar));
            }
            if ((chartyColor = bar.getColor()) == null) {
                chartyColor = color;
            }
            ChartyColor barColor = chartyColor;
            ChartContext $this$drawBars_u24lambda_u240_u240 = chartContext;
            boolean bl3 = false;
            Brush brush = $this$drawBars_u24lambda_u240_u240.toVerticalGradientBrush(barColor);
            BarChartDrawerKt.drawRoundedBar($this$drawBars, brush, barX, barTop, barWidth, barHeight, isNegative, barConfig.getNegativeValuesDrawMode() == NegativeValuesDrawMode.BELOW_AXIS, barConfig.getCornerRadius().getValue());
        }
    }

    public static final void drawBarReferenceLineIfNeeded(@NotNull DrawScope $this$drawBarReferenceLineIfNeeded, @NotNull BarChartConfig barConfig, @NotNull ChartContext chartContext, @NotNull TextMeasurer textMeasurer) {
        Intrinsics.checkNotNullParameter((Object)$this$drawBarReferenceLineIfNeeded, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)barConfig, (String)"barConfig");
        Intrinsics.checkNotNullParameter((Object)chartContext, (String)"chartContext");
        Intrinsics.checkNotNullParameter((Object)textMeasurer, (String)"textMeasurer");
        ChartDrawUtilsKt.drawReferenceLineIfNeeded($this$drawBarReferenceLineIfNeeded, barConfig.getReferenceLine(), chartContext, ChartOrientation.VERTICAL, textMeasurer);
    }

    public static final void drawBarTooltipIfNeeded(@NotNull DrawScope $this$drawBarTooltipIfNeeded, @Nullable TooltipState tooltipState, @NotNull BarChartConfig barConfig, @NotNull TextMeasurer textMeasurer, @NotNull ChartContext chartContext) {
        Intrinsics.checkNotNullParameter((Object)$this$drawBarTooltipIfNeeded, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)barConfig, (String)"barConfig");
        Intrinsics.checkNotNullParameter((Object)textMeasurer, (String)"textMeasurer");
        Intrinsics.checkNotNullParameter((Object)chartContext, (String)"chartContext");
        ChartDrawUtilsKt.drawTooltipIfNeeded($this$drawBarTooltipIfNeeded, tooltipState, barConfig.getTooltipConfig(), textMeasurer, chartContext);
    }

    /*
     * WARNING - void declaration
     */
    private static final void drawRoundedBar(DrawScope $this$drawRoundedBar, Brush brush, float x, float y, float width, float height, boolean isNegative, boolean isBelowAxisMode, float cornerRadius) {
        Path path;
        Path $this$drawRoundedBar_u24lambda_u240 = path = AndroidPath_androidKt.Path();
        boolean bl = false;
        if (isNegative && isBelowAxisMode) {
            void x$iv;
            void x$iv2;
            float f = x + width;
            float f2 = y + height;
            long l = CornerRadius.Companion.getZero-kKHJgLs();
            long l2 = CornerRadius.Companion.getZero-kKHJgLs();
            float f3 = cornerRadius;
            float y$iv = cornerRadius;
            boolean $i$f$CornerRadius22 = false;
            boolean $i$f$packFloats = false;
            long v1$iv$iv = Float.floatToRawIntBits((float)x$iv2);
            long v2$iv$iv = Float.floatToRawIntBits(y$iv);
            long l3 = CornerRadius.constructor-impl((long)(v1$iv$iv << 32 | v2$iv$iv & 0xFFFFFFFFL));
            float $i$f$CornerRadius22 = cornerRadius;
            float y$iv2 = cornerRadius;
            boolean $i$f$CornerRadius = false;
            boolean $i$f$packFloats2 = false;
            long v1$iv$iv2 = Float.floatToRawIntBits((float)x$iv);
            long v2$iv$iv2 = Float.floatToRawIntBits(y$iv2);
            long l4 = CornerRadius.constructor-impl((long)(v1$iv$iv2 << 32 | v2$iv$iv2 & 0xFFFFFFFFL));
            Path.addRoundRect$default((Path)$this$drawRoundedBar_u24lambda_u240, (RoundRect)new RoundRect(x, y, f, f2, l, l2, l4, l3, null), null, (int)2, null);
        } else {
            void x$iv;
            void x$iv3;
            float f = x + width;
            float f4 = y + height;
            float f5 = cornerRadius;
            float y$iv = cornerRadius;
            boolean $i$f$CornerRadius32 = false;
            boolean $i$f$packFloats = false;
            long v1$iv$iv = Float.floatToRawIntBits((float)x$iv3);
            long v2$iv$iv = Float.floatToRawIntBits(y$iv);
            long l = CornerRadius.constructor-impl((long)(v1$iv$iv << 32 | v2$iv$iv & 0xFFFFFFFFL));
            float $i$f$CornerRadius32 = cornerRadius;
            float y$iv3 = cornerRadius;
            boolean $i$f$CornerRadius = false;
            boolean $i$f$packFloats3 = false;
            long v1$iv$iv3 = Float.floatToRawIntBits((float)x$iv);
            long v2$iv$iv3 = Float.floatToRawIntBits(y$iv3);
            long l5 = CornerRadius.constructor-impl((long)(v1$iv$iv3 << 32 | v2$iv$iv3 & 0xFFFFFFFFL));
            long l6 = CornerRadius.Companion.getZero-kKHJgLs();
            long l7 = CornerRadius.Companion.getZero-kKHJgLs();
            Path.addRoundRect$default((Path)$this$drawRoundedBar_u24lambda_u240, (RoundRect)new RoundRect(x, y, f, f4, l, l5, l7, l6, null), null, (int)2, null);
        }
        Path path2 = path;
        DrawScope.drawPath-GBMwjPU$default((DrawScope)$this$drawRoundedBar, (Path)path2, (Brush)brush, (float)0.0f, null, null, (int)0, (int)60, null);
    }
}

