/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xservlet.requesttrack;

import com.helger.annotation.Nonempty;
import com.helger.annotation.Nonnegative;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.diagnostics.error.level.EErrorLevel;
import com.helger.diagnostics.error.level.IErrorLevel;
import com.helger.diagnostics.log.LogHelper;
import com.helger.web.scope.IRequestWebScope;
import com.helger.xservlet.requesttrack.ILongRunningRequestCallback;
import jakarta.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingLongRunningRequestCallback
implements ILongRunningRequestCallback {
    public static final boolean DEFAULT_LOG_REMOTE_ADDR = true;
    private static final Logger LOGGER = LoggerFactory.getLogger(LoggingLongRunningRequestCallback.class);
    private IErrorLevel m_aErrorLevel;
    private boolean m_bLogRemoteAddr = true;

    public LoggingLongRunningRequestCallback() {
        this((IErrorLevel)EErrorLevel.WARN);
    }

    public LoggingLongRunningRequestCallback(@Nonnull IErrorLevel iErrorLevel) {
        this.setErrorLevel(iErrorLevel);
    }

    @Nonnull
    public final IErrorLevel getErrorLevel() {
        return this.m_aErrorLevel;
    }

    @Nonnull
    public final LoggingLongRunningRequestCallback setErrorLevel(@Nonnull IErrorLevel iErrorLevel) {
        this.m_aErrorLevel = (IErrorLevel)ValueEnforcer.notNull((Object)iErrorLevel, (String)"ErrorLevel");
        return this;
    }

    public final boolean isLogRemoteAddr() {
        return this.m_bLogRemoteAddr;
    }

    @Nonnull
    public final LoggingLongRunningRequestCallback setLogRemoteAddr(boolean bl) {
        this.m_bLogRemoteAddr = bl;
        return this;
    }

    @Override
    public void onLongRunningRequest(@Nonnull @Nonempty String string, @Nonnull IRequestWebScope iRequestWebScope, @Nonnegative long l) {
        LogHelper.log((Logger)LOGGER, (IErrorLevel)this.m_aErrorLevel, () -> "Long running request. ID=" + string + "; millisecs=" + l + (String)(this.m_bLogRemoteAddr ? "; Remote IP=" + iRequestWebScope.getRemoteAddr() : "") + "; URL=" + iRequestWebScope.getURLEncoded());
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("ErrorLevel", (Object)this.m_aErrorLevel).append("LogRemoteAddr", this.m_bLogRemoteAddr).getToString();
    }
}

