/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xservlet.exception;

import com.helger.base.io.stream.StreamHelper;
import com.helger.base.lang.clazz.ClassHelper;
import com.helger.base.state.EContinue;
import com.helger.web.scope.IRequestWebScope;
import com.helger.xservlet.exception.IXServletExceptionHandler;
import jakarta.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XServletLoggingExceptionHandler
implements IXServletExceptionHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(XServletLoggingExceptionHandler.class);

    @Override
    @Nonnull
    public EContinue onException(@Nonnull IRequestWebScope iRequestWebScope, @Nonnull Throwable throwable) {
        String string = "Internal error on " + iRequestWebScope.getHttpVersion().getName() + " " + iRequestWebScope.getMethod() + " on resource '" + iRequestWebScope.getURLEncoded() + "'";
        if (StreamHelper.isKnownEOFException((Throwable)throwable)) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(string + " - " + ClassHelper.getClassLocalName((Object)throwable) + " - " + throwable.getMessage());
            }
            return EContinue.BREAK;
        }
        LOGGER.error(string, throwable);
        return EContinue.CONTINUE;
    }
}

