/*
 * Decompiled with CFR 0.152.
 */
package com.helger.smtp.settings;

import com.helger.annotation.CheckForSigned;
import com.helger.base.string.StringHelper;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.nio.charset.Charset;

public interface ISMTPSettings {
    @Nonnull
    public String getHostName();

    public int getPort();

    default public boolean hasPort() {
        return this.getPort() > 0;
    }

    @Nullable
    public String getUserName();

    default public boolean hasUserName() {
        return StringHelper.isNotEmpty((String)this.getUserName());
    }

    @Nullable
    public String getPassword();

    default public boolean hasPassword() {
        return StringHelper.isNotEmpty((String)this.getPassword());
    }

    @Nullable
    public Charset getCharsetObj();

    @Nullable
    default public String getCharsetName() {
        Charset charset = this.getCharsetObj();
        return charset == null ? null : charset.name();
    }

    default public boolean hasCharset() {
        return this.getCharsetObj() != null;
    }

    public boolean isSSLEnabled();

    public boolean isSTARTTLSEnabled();

    @CheckForSigned
    public long getConnectionTimeoutMilliSecs();

    @CheckForSigned
    public long getTimeoutMilliSecs();

    public boolean isDebugSMTP();

    public boolean areRequiredFieldsSet();
}

