/*
 * Decompiled with CFR 0.152.
 */
package com.helger.smtp.scope;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.ThreadSafe;
import com.helger.annotation.style.UsedViaReflection;
import com.helger.base.state.ESuccess;
import com.helger.scope.IScope;
import com.helger.scope.singleton.AbstractGlobalSingleton;
import com.helger.smtp.data.IMutableEmailData;
import com.helger.smtp.failed.FailedMailQueue;
import com.helger.smtp.settings.ISMTPSettings;
import com.helger.smtp.transport.MailAPI;
import jakarta.annotation.Nonnull;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;

@ThreadSafe
public final class ScopedMailAPI
extends AbstractGlobalSingleton {
    public static final boolean DEFAULT_STOP_IMMEDIATLY = false;
    private final AtomicBoolean m_aStopImmediately = new AtomicBoolean(false);

    @Deprecated(forRemoval=false)
    @UsedViaReflection
    public ScopedMailAPI() {
    }

    @Nonnull
    public static ScopedMailAPI getInstance() {
        return (ScopedMailAPI)ScopedMailAPI.getGlobalSingleton(ScopedMailAPI.class);
    }

    @Nonnull
    public FailedMailQueue getFailedMailQueue() {
        return MailAPI.getFailedMailQueue();
    }

    public void setFailedMailQueue(@Nonnull FailedMailQueue failedMailQueue) {
        MailAPI.setFailedMailQueue(failedMailQueue);
    }

    @Nonnull
    public ESuccess queueMail(@Nonnull ISMTPSettings iSMTPSettings, @Nonnull IMutableEmailData iMutableEmailData) {
        return MailAPI.queueMail(iSMTPSettings, iMutableEmailData);
    }

    @Nonnegative
    public int queueMails(@Nonnull ISMTPSettings iSMTPSettings, @Nonnull Collection<? extends IMutableEmailData> collection) {
        return MailAPI.queueMails(iSMTPSettings, collection);
    }

    @Nonnegative
    public int getTotalQueueLength() {
        return MailAPI.getTotalQueueLength();
    }

    public boolean isStopImmediately() {
        return this.m_aStopImmediately.get();
    }

    public void setStopImmediatly(boolean bl) {
        this.m_aStopImmediately.set(bl);
    }

    protected void onDestroy(@Nonnull IScope iScope) {
        MailAPI.stop(this.isStopImmediately());
    }
}

