/*
 * Decompiled with CFR 0.152.
 */
package com.helger.smtp.data;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.style.ReturnsMutableObject;
import com.helger.base.email.IEmailAddress;
import com.helger.collection.commons.ICommonsList;
import com.helger.smtp.data.EEmailType;
import com.helger.smtp.data.IEmailAttachmentList;
import com.helger.typeconvert.collection.IStringMap;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.LocalDateTime;

public interface IEmailData {
    @Nonnull
    public EEmailType getEmailType();

    @Nullable
    public IEmailAddress getFrom();

    @Nonnull
    @ReturnsMutableObject
    public ICommonsList<IEmailAddress> replyTo();

    @Nonnull
    @ReturnsMutableObject
    public ICommonsList<IEmailAddress> to();

    @Nonnull
    @ReturnsMutableObject
    public ICommonsList<IEmailAddress> cc();

    @Nonnull
    @ReturnsMutableObject
    public ICommonsList<IEmailAddress> bcc();

    @Nullable
    public LocalDateTime getSentDateTime();

    @Nullable
    public String getSubject();

    @Nullable
    public String getBody();

    @Nullable
    public IEmailAttachmentList getAttachments();

    @Nonnegative
    default public int getAttachmentCount() {
        IEmailAttachmentList iEmailAttachmentList = this.getAttachments();
        return iEmailAttachmentList == null ? 0 : iEmailAttachmentList.size();
    }

    @Nonnull
    @ReturnsMutableObject
    public IStringMap attrs();
}

