/*
 * Decompiled with CFR 0.152.
 */
package com.helger.smtp.data;

import com.helger.annotation.Nonempty;
import com.helger.base.io.iface.IHasInputStream;
import com.helger.base.string.StringHelper;
import com.helger.smtp.data.EEmailAttachmentDisposition;
import com.helger.smtp.data.IEmailAttachmentDataSource;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.InputStream;
import java.nio.charset.Charset;

public interface IEmailAttachment
extends IHasInputStream {
    @Nonnull
    @Nonempty
    public String getFilename();

    @Nonnull
    public IHasInputStream getInputStreamProvider();

    @Nonnull
    default public InputStream getInputStream() {
        return this.getInputStreamProvider().getInputStream();
    }

    default public boolean isReadMultiple() {
        return this.getInputStreamProvider().isReadMultiple();
    }

    @Nullable
    public Charset getCharset();

    default public boolean hasCharset() {
        return this.getCharset() != null;
    }

    @Nullable
    public String getContentType();

    default public boolean hasContentType() {
        return StringHelper.isNotEmpty((String)this.getContentType());
    }

    @Nonnull
    public EEmailAttachmentDisposition getDisposition();

    @Nonnull
    public IEmailAttachmentDataSource getAsDataSource();
}

