/*
 * Decompiled with CFR 0.152.
 */
package com.helger.smtp.data;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.annotation.style.CodingStyleguideUnaware;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.annotation.style.ReturnsMutableObject;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.state.EChange;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.CommonsLinkedHashMap;
import com.helger.collection.commons.ICommonsList;
import com.helger.collection.commons.ICommonsOrderedMap;
import com.helger.collection.commons.ICommonsOrderedSet;
import com.helger.smtp.data.IEmailAttachment;
import com.helger.smtp.data.IEmailAttachmentDataSource;
import com.helger.smtp.data.IEmailAttachmentList;
import com.helger.smtp.data.IMutableEmailAttachmentList;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Collection;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class EmailAttachmentList
implements IMutableEmailAttachmentList {
    private static final Logger LOGGER = LoggerFactory.getLogger(EmailAttachmentList.class);
    private final ICommonsOrderedMap<String, IEmailAttachment> m_aMap = new CommonsLinkedHashMap();

    public EmailAttachmentList() {
    }

    public EmailAttachmentList(@Nullable IEmailAttachmentList iEmailAttachmentList) {
        if (iEmailAttachmentList != null) {
            Iterator iterator = iEmailAttachmentList.iterator();
            while (iterator.hasNext()) {
                IEmailAttachment iEmailAttachment = (IEmailAttachment)iterator.next();
                this.addAttachment(iEmailAttachment);
            }
        }
    }

    public EmailAttachmentList(IEmailAttachment ... iEmailAttachmentArray) {
        if (iEmailAttachmentArray != null) {
            for (IEmailAttachment iEmailAttachment : iEmailAttachmentArray) {
                this.addAttachment(iEmailAttachment);
            }
        }
    }

    @Nonnegative
    public int size() {
        return this.m_aMap.size();
    }

    public boolean isEmpty() {
        return this.m_aMap.isEmpty();
    }

    @Override
    public final void addAttachment(@Nonnull IEmailAttachment iEmailAttachment) {
        ValueEnforcer.notNull((Object)iEmailAttachment, (String)"Attachment");
        String string = iEmailAttachment.getFilename();
        if (this.m_aMap.containsKey((Object)string)) {
            LOGGER.warn("Overwriting email attachment with filename '" + string + "'");
        }
        this.m_aMap.put((Object)string, (Object)iEmailAttachment);
    }

    @Override
    @Nonnull
    public EChange removeAttachment(@Nullable String string) {
        return this.m_aMap.removeObject((Object)string);
    }

    @Nonnull
    public EChange removeAll() {
        return this.m_aMap.removeAll();
    }

    @Override
    public boolean containsAttachment(@Nullable String string) {
        return this.m_aMap.containsKey((Object)string);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsOrderedSet<String> getAllAttachmentFilenames() {
        return this.m_aMap.copyOfKeySet();
    }

    @Nonnull
    @ReturnsMutableObject(value="speed")
    @CodingStyleguideUnaware
    Collection<IEmailAttachment> directGetAllAttachments() {
        return this.m_aMap.values();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<IEmailAttachment> getAllAttachments() {
        return this.m_aMap.copyOfValues();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<IEmailAttachmentDataSource> getAsDataSourceList() {
        return new CommonsArrayList(this.m_aMap.values(), IEmailAttachment::getAsDataSource);
    }

    @Nonnull
    public Iterator<IEmailAttachment> iterator() {
        return this.m_aMap.values().iterator();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        EmailAttachmentList emailAttachmentList = (EmailAttachmentList)object;
        return this.m_aMap.equals(emailAttachmentList.m_aMap);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_aMap).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("map", this.m_aMap).getToString();
    }
}

