/*
 * Decompiled with CFR 0.152.
 */
package com.helger.network.port;

import com.helger.annotation.Nonempty;
import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.GuardedBy;
import com.helger.annotation.concurrent.ThreadSafe;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.concurrent.SimpleReadWriteLock;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.string.StringHelper;
import com.helger.collection.commons.CommonsHashMap;
import com.helger.collection.commons.ICommonsMap;
import com.helger.network.port.NetworkPortHelper;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

@ThreadSafe
public final class SchemeDefaultPortMapper {
    public static final String SCHEME_FTP = "ftp";
    public static final String SCHEME_HTTP = "http";
    public static final String SCHEME_HTTPS = "https";
    private static final SchemeDefaultPortMapper INSTANCE = new SchemeDefaultPortMapper();
    private static final SimpleReadWriteLock RW_LOCK = new SimpleReadWriteLock();
    @GuardedBy(value="RW_LOCK")
    private static final ICommonsMap<String, Integer> MAP = new CommonsHashMap();

    private SchemeDefaultPortMapper() {
    }

    public static void registerDefaultPort(@Nonnull @Nonempty String string, @Nonnegative int n) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"SchemeName");
        ValueEnforcer.isTrue((boolean)NetworkPortHelper.isValidPort(n), (String)"Invalid port provided");
        RW_LOCK.writeLocked(() -> {
            if (MAP.containsKey((Object)string)) {
                throw new IllegalArgumentException("A default port for scheme '" + string + "' is already registered!");
            }
            MAP.put((Object)string, (Object)n);
        });
    }

    public static int getDefaultPort(@Nullable String string, int n) {
        Integer n2;
        if (StringHelper.isNotEmpty((String)string) && (n2 = (Integer)RW_LOCK.readLockedGet(() -> (Integer)MAP.get((Object)string))) != null) {
            return n2;
        }
        return n;
    }

    public static int getDefaultPortOrInvalid(@Nullable String string) {
        return SchemeDefaultPortMapper.getDefaultPort(string, -1);
    }

    public static int getDefaultPortOrThrow(@Nullable String string) {
        int n = SchemeDefaultPortMapper.getDefaultPortOrInvalid(string);
        if (n == -1) {
            throw new IllegalArgumentException("No default port present for scheme '" + string + "'");
        }
        return n;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsMap<String, Integer> getAll() {
        return (ICommonsMap)RW_LOCK.readLockedGet(() -> MAP.getClone());
    }

    static {
        SchemeDefaultPortMapper.registerDefaultPort(SCHEME_FTP, 21);
        SchemeDefaultPortMapper.registerDefaultPort(SCHEME_HTTP, 80);
        SchemeDefaultPortMapper.registerDefaultPort(SCHEME_HTTPS, 443);
    }
}

