/*
 * Decompiled with CFR 0.152.
 */
package com.helger.httpclient.response;

import com.helger.annotation.Nonempty;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.annotation.style.ReturnsMutableObject;
import com.helger.base.array.ArrayHelper;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.httpclient.HttpClientHelper;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.nio.charset.Charset;
import org.apache.hc.client5.http.HttpResponseException;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.message.StatusLine;

public class ExtendedHttpResponseException
extends HttpResponseException {
    private final transient StatusLine m_aStatusLine;
    private final transient HttpResponse m_aHttpResponse;
    private final byte[] m_aResponseBody;
    private final transient Charset m_aResponseCharset;

    public ExtendedHttpResponseException(@Nonnull StatusLine statusLine, @Nonnull HttpResponse httpResponse, @Nullable byte[] byArray, @Nonnull Charset charset) {
        super(statusLine.getStatusCode(), statusLine.getReasonPhrase() + " [" + statusLine.getStatusCode() + "]");
        ValueEnforcer.notNull((Object)httpResponse, (String)"HTTPResponse");
        ValueEnforcer.notNull((Object)charset, (String)"Charset");
        this.m_aStatusLine = statusLine;
        this.m_aHttpResponse = httpResponse;
        this.m_aResponseBody = byArray;
        this.m_aResponseCharset = charset;
    }

    @Nonnull
    public final StatusLine getStatusLine() {
        return this.m_aStatusLine;
    }

    @Nonnull
    public final HttpResponse getHttpResponse() {
        return this.m_aHttpResponse;
    }

    @Nullable
    @ReturnsMutableObject
    public final byte[] directGetResponseBody() {
        return this.m_aResponseBody;
    }

    @Nullable
    @ReturnsMutableCopy
    public final byte[] getResponseBody() {
        return ArrayHelper.getCopy((byte[])this.m_aResponseBody);
    }

    public final boolean hasResponseBody() {
        return ArrayHelper.isNotEmpty((byte[])this.m_aResponseBody);
    }

    @Nonnull
    public final Charset getResponseCharset() {
        return this.m_aResponseCharset;
    }

    @Nullable
    public final String getResponseBodyAsString() {
        return this.getResponseBodyAsString(this.m_aResponseCharset);
    }

    @Nullable
    public final String getResponseBodyAsString(@Nonnull Charset charset) {
        return this.m_aResponseBody == null ? null : new String(this.m_aResponseBody, charset);
    }

    @Nonnull
    @Nonempty
    public String getMessagePartStatusLine() {
        return this.m_aStatusLine.getReasonPhrase() + " [" + this.m_aStatusLine.getStatusCode() + "]";
    }

    @Nonnull
    @Nonempty
    public String getMessagePartHeaders() {
        StringBuilder stringBuilder = new StringBuilder();
        Header[] headerArray = this.m_aHttpResponse.getHeaders();
        stringBuilder.append("All ").append(headerArray.length).append(" headers returned");
        for (Header header : headerArray) {
            stringBuilder.append("\n  ").append(header.getName()).append('=').append(header.getValue());
        }
        return stringBuilder.toString();
    }

    @Nonnull
    @Nonempty
    public String getMessagePartResponseBody() {
        if (this.m_aResponseBody != null) {
            return "Response Body (in " + this.m_aResponseCharset.name() + "):\n" + this.getResponseBodyAsString(this.m_aResponseCharset);
        }
        return "No Response Body present!";
    }

    @Nonnull
    public String getMessage() {
        return this.getMessagePartStatusLine() + "\n" + this.getMessagePartHeaders() + "\n" + this.getMessagePartResponseBody();
    }

    @Nonnull
    public static ExtendedHttpResponseException create(@Nonnull ClassicHttpResponse classicHttpResponse) throws IOException {
        StatusLine statusLine = new StatusLine((HttpResponse)classicHttpResponse);
        return ExtendedHttpResponseException.create(statusLine, (HttpResponse)classicHttpResponse, classicHttpResponse.getEntity());
    }

    @Nonnull
    public static ExtendedHttpResponseException create(@Nonnull StatusLine statusLine, @Nonnull HttpResponse httpResponse, @Nonnull HttpEntity httpEntity) throws IOException {
        ContentType contentType = HttpClientHelper.getContentTypeOrDefault(httpEntity);
        Charset charset = HttpClientHelper.getCharset(contentType);
        byte[] byArray = EntityUtils.toByteArray((HttpEntity)httpEntity);
        return new ExtendedHttpResponseException(statusLine, httpResponse, byArray, charset);
    }
}

