/*
 * Decompiled with CFR 0.152.
 */
package com.helger.httpclient;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.id.factory.GlobalIDFactory;
import com.helger.base.state.EHandled;
import com.helger.collection.commons.ICommonsSet;
import com.helger.http.tls.ITLSConfigurationMode;
import com.helger.httpclient.HttpClientRetryStrategy;
import com.helger.httpclient.HttpClientSettings;
import com.helger.httpclient.HttpDebugger;
import com.helger.httpclient.HttpProxySettings;
import com.helger.httpclient.IHttpClientProvider;
import com.helger.httpclient.IHttpProxySettings;
import com.helger.httpclient.NonCachingDnsResolver;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.function.Function;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.hc.client5.http.DnsResolver;
import org.apache.hc.client5.http.HttpRequestRetryStrategy;
import org.apache.hc.client5.http.HttpRoute;
import org.apache.hc.client5.http.SchemePortResolver;
import org.apache.hc.client5.http.SystemDefaultDnsResolver;
import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.config.ConnectionConfig;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.DefaultClientConnectionReuseStrategy;
import org.apache.hc.client5.http.impl.DefaultSchemePortResolver;
import org.apache.hc.client5.http.impl.auth.BasicCredentialsProvider;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import org.apache.hc.client5.http.impl.routing.DefaultProxyRoutePlanner;
import org.apache.hc.client5.http.impl.routing.DefaultRoutePlanner;
import org.apache.hc.client5.http.io.ConnectionEndpoint;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.io.LeaseRequest;
import org.apache.hc.client5.http.protocol.RequestAddCookies;
import org.apache.hc.client5.http.routing.HttpRoutePlanner;
import org.apache.hc.client5.http.ssl.DefaultClientTlsStrategy;
import org.apache.hc.client5.http.ssl.HttpsSupport;
import org.apache.hc.client5.http.ssl.TlsSocketStrategy;
import org.apache.hc.core5.http.ConnectionReuseStrategy;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpRequestInterceptor;
import org.apache.hc.core5.http.URIScheme;
import org.apache.hc.core5.http.io.SocketConfig;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.reactor.ssl.SSLBufferMode;
import org.apache.hc.core5.ssl.SSLInitializationException;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class HttpClientFactory
implements IHttpClientProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpClientFactory.class);
    private final HttpClientSettings m_aSettings;

    public HttpClientFactory() {
        this(new HttpClientSettings());
    }

    public HttpClientFactory(@Nonnull HttpClientSettings httpClientSettings) {
        ValueEnforcer.notNull((Object)httpClientSettings, (String)"Settings");
        this.m_aSettings = httpClientSettings;
    }

    @Nonnull
    public final HttpClientSettings httpClientSettings() {
        return this.m_aSettings;
    }

    @Nonnull
    public SchemePortResolver createSchemePortResolver() {
        return DefaultSchemePortResolver.INSTANCE;
    }

    @Nullable
    protected TlsSocketStrategy createCustomTlsSocketStrategy() {
        DefaultClientTlsStrategy defaultClientTlsStrategy = null;
        try {
            SSLContext sSLContext = this.m_aSettings.getSSLContext();
            if (sSLContext != null) {
                HostnameVerifier hostnameVerifier;
                ITLSConfigurationMode iTLSConfigurationMode = this.m_aSettings.getTLSConfigurationMode();
                if (iTLSConfigurationMode == null) {
                    iTLSConfigurationMode = HttpClientSettings.DEFAULT_TLS_CONFIG_MODE;
                }
                if ((hostnameVerifier = this.m_aSettings.getHostnameVerifier()) == null) {
                    hostnameVerifier = HttpsSupport.getDefaultHostnameVerifier();
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Using the following TLS versions: " + String.valueOf(iTLSConfigurationMode.getAllTLSVersionIDs()));
                    LOGGER.debug("Using the following TLS cipher suites: " + String.valueOf(iTLSConfigurationMode.getAllCipherSuites()));
                    LOGGER.debug("Using the following hostname verifier: " + String.valueOf(hostnameVerifier));
                }
                defaultClientTlsStrategy = new DefaultClientTlsStrategy(sSLContext, iTLSConfigurationMode.getAllTLSVersionIDsAsArray(), iTLSConfigurationMode.getAllCipherSuitesAsArray(), SSLBufferMode.STATIC, hostnameVerifier);
            }
        }
        catch (SSLInitializationException sSLInitializationException) {
            LOGGER.warn("Failed to init custom TlsSocketStrategy - falling back to default TlsSocketStrategy", (Throwable)sSLInitializationException);
        }
        return defaultClientTlsStrategy;
    }

    @Nullable
    public TlsSocketStrategy createTlsSocketStrategy() {
        TlsSocketStrategy tlsSocketStrategy = this.createCustomTlsSocketStrategy();
        if (tlsSocketStrategy == null) {
            try {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Trying DefaultClientTlsStrategy.createSystemDefault ()");
                }
                tlsSocketStrategy = DefaultClientTlsStrategy.createSystemDefault();
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Using SSL socket factory with an SSL context based on system propertiesas described in JSSE Reference Guide.");
                }
            }
            catch (SSLInitializationException sSLInitializationException) {
                try {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Trying DefaultClientTlsStrategy.createDefault ()");
                    }
                    tlsSocketStrategy = DefaultClientTlsStrategy.createDefault();
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Using SSL socket factory with an SSL context based on the standard JSSE trust material (cacerts file in the security properties directory).System properties are not taken into consideration.");
                    }
                }
                catch (SSLInitializationException sSLInitializationException2) {
                    // empty catch block
                }
            }
        }
        return tlsSocketStrategy;
    }

    @Nonnull
    public SocketConfig.Builder createSocketConfigBuilder() {
        return SocketConfig.custom();
    }

    @Nonnull
    public SocketConfig createSocketConfig() {
        return this.createSocketConfigBuilder().build();
    }

    @Nullable
    public DnsResolver createDNSResolver() {
        return this.m_aSettings.isUseDNSClientCache() ? SystemDefaultDnsResolver.INSTANCE : NonCachingDnsResolver.INSTANCE;
    }

    @Nonnull
    public HttpClientConnectionManager createConnectionManager(@Nonnull TlsSocketStrategy tlsSocketStrategy) {
        Object object;
        DnsResolver dnsResolver = this.createDNSResolver();
        ConnectionConfig connectionConfig = this.createConnectionConfig();
        final PoolingHttpClientConnectionManager poolingHttpClientConnectionManager = PoolingHttpClientConnectionManagerBuilder.create().setTlsSocketStrategy(tlsSocketStrategy).setDnsResolver(dnsResolver).setDefaultConnectionConfig(connectionConfig).build();
        poolingHttpClientConnectionManager.setDefaultMaxPerRoute(100);
        poolingHttpClientConnectionManager.setMaxTotal(200);
        SocketConfig socketConfig = this.createSocketConfig();
        poolingHttpClientConnectionManager.setDefaultSocketConfig(socketConfig);
        if (HttpDebugger.isEnabled()) {
            final String string = "HttpClientConnectionManager[" + GlobalIDFactory.getNewIntID() + "].";
            object = new HttpClientConnectionManager(){

                public void close(CloseMode closeMode) {
                    LOGGER.info(string + "close(" + String.valueOf(closeMode) + ")");
                    poolingHttpClientConnectionManager.close(closeMode);
                }

                public void close() throws IOException {
                    LOGGER.info(string + "close()");
                    poolingHttpClientConnectionManager.close();
                }

                public LeaseRequest lease(String string2, HttpRoute httpRoute, Timeout timeout, Object object) {
                    LOGGER.info(string + "lease(" + string2 + ", " + String.valueOf(httpRoute) + ", " + String.valueOf(timeout) + ", " + String.valueOf(object) + ")");
                    return poolingHttpClientConnectionManager.lease(string2, httpRoute, object);
                }

                public void connect(ConnectionEndpoint connectionEndpoint, TimeValue timeValue, HttpContext httpContext) throws IOException {
                    LOGGER.info(string + "connect(" + String.valueOf(connectionEndpoint) + ", " + String.valueOf(timeValue) + ", " + String.valueOf(httpContext) + ")");
                    poolingHttpClientConnectionManager.connect(connectionEndpoint, timeValue, httpContext);
                }

                public void upgrade(ConnectionEndpoint connectionEndpoint, HttpContext httpContext) throws IOException {
                    LOGGER.info(string + "upgrade(" + String.valueOf(connectionEndpoint) + ", " + String.valueOf(httpContext) + ")");
                    poolingHttpClientConnectionManager.upgrade(connectionEndpoint, httpContext);
                }

                public void release(ConnectionEndpoint connectionEndpoint, Object object, TimeValue timeValue) {
                    LOGGER.info(string + "release(" + String.valueOf(connectionEndpoint) + ", " + String.valueOf(object) + ", " + String.valueOf(timeValue) + ")");
                    poolingHttpClientConnectionManager.release(connectionEndpoint, object, timeValue);
                }
            };
        } else {
            object = poolingHttpClientConnectionManager;
        }
        return object;
    }

    @Nullable
    public ConnectionReuseStrategy createConnectionReuseStrategy() {
        if (this.m_aSettings.isUseKeepAlive()) {
            return DefaultClientConnectionReuseStrategy.INSTANCE;
        }
        return (httpRequest, httpResponse, httpContext) -> false;
    }

    @Nonnull
    public ConnectionConfig.Builder createConnectionConfigBuilder() {
        return ConnectionConfig.custom().setConnectTimeout(this.m_aSettings.getConnectTimeout());
    }

    @Nonnull
    public ConnectionConfig createConnectionConfig() {
        return this.createConnectionConfigBuilder().build();
    }

    @Nonnull
    public RequestConfig.Builder createRequestConfigBuilder() {
        return RequestConfig.custom().setCookieSpec("strict").setConnectionRequestTimeout(this.m_aSettings.getConnectionRequestTimeout()).setResponseTimeout(this.m_aSettings.getResponseTimeout()).setCircularRedirectsAllowed(false).setRedirectsEnabled(this.m_aSettings.isFollowRedirects()).setProtocolUpgradeEnabled(this.m_aSettings.isProtocolUpgradeEnabled());
    }

    @Nonnull
    public RequestConfig createRequestConfig() {
        return this.createRequestConfigBuilder().build();
    }

    @Nullable
    public CredentialsProvider createCredentialsProvider() {
        BasicCredentialsProvider basicCredentialsProvider = new BasicCredentialsProvider();
        Function<IHttpProxySettings, EHandled> function = iHttpProxySettings -> {
            if (iHttpProxySettings.hasProxyHost() && iHttpProxySettings.hasProxyCredentials()) {
                basicCredentialsProvider.setCredentials(new AuthScope(iHttpProxySettings.getProxyHost()), iHttpProxySettings.getProxyCredentials());
                return EHandled.HANDLED;
            }
            return EHandled.UNHANDLED;
        };
        int n = 0;
        if (function.apply(this.m_aSettings.getGeneralProxy()).isHandled()) {
            ++n;
        }
        if (function.apply(this.m_aSettings.getHttpProxy()).isHandled()) {
            ++n;
        }
        if (function.apply(this.m_aSettings.getHttpsProxy()).isHandled()) {
            ++n;
        }
        return n > 0 ? basicCredentialsProvider : null;
    }

    @Nullable
    public HttpRequestRetryStrategy createRequestRetryStrategy(@Nonnegative int n, @Nonnull TimeValue timeValue, boolean bl) {
        return new HttpClientRetryStrategy(n, timeValue, bl);
    }

    @Nullable
    public HttpRoutePlanner createRoutePlanner(@Nonnull SchemePortResolver schemePortResolver) {
        final HttpProxySettings httpProxySettings = this.m_aSettings.getGeneralProxy();
        HttpProxySettings httpProxySettings2 = this.m_aSettings.getHttpProxy();
        HttpProxySettings httpProxySettings3 = this.m_aSettings.getHttpsProxy();
        boolean bl = httpProxySettings.hasProxyHost();
        final boolean bl2 = httpProxySettings2.hasProxyHost();
        final boolean bl3 = httpProxySettings3.hasProxyHost();
        if (!(bl || bl2 || bl3)) {
            return null;
        }
        if (bl && !bl2 && !bl3 && httpProxySettings.nonProxyHosts().isEmpty()) {
            return new DefaultProxyRoutePlanner(httpProxySettings.getProxyHost(), schemePortResolver);
        }
        final HttpProxySettings httpProxySettings4 = bl2 ? httpProxySettings2 : httpProxySettings;
        final HttpProxySettings httpProxySettings5 = bl3 ? httpProxySettings3 : httpProxySettings;
        final ICommonsSet<String> iCommonsSet = httpProxySettings.getAllNonProxyHosts();
        final ICommonsSet<String> iCommonsSet2 = httpProxySettings4.getAllNonProxyHosts();
        final ICommonsSet<String> iCommonsSet3 = httpProxySettings5.getAllNonProxyHosts();
        return new DefaultRoutePlanner(schemePortResolver){

            protected HttpHost determineProxy(@Nonnull HttpHost httpHost, @Nonnull HttpContext httpContext) throws HttpException {
                ICommonsSet iCommonsSet4;
                IHttpProxySettings iHttpProxySettings;
                String string = httpHost.getSchemeName();
                String string2 = httpHost.getHostName();
                if (string.equals(URIScheme.HTTP.getId())) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Choosing " + (bl2 ? "specific" : "general") + " http proxy settings");
                    }
                    iHttpProxySettings = httpProxySettings4;
                    iCommonsSet4 = iCommonsSet2;
                } else if (string.equals(URIScheme.HTTPS.getId())) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Choosing " + (bl3 ? "specific" : "general") + " https proxy settings");
                    }
                    iHttpProxySettings = httpProxySettings5;
                    iCommonsSet4 = iCommonsSet3;
                } else {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Choosing general proxy settings");
                    }
                    iHttpProxySettings = httpProxySettings;
                    iCommonsSet4 = iCommonsSet;
                }
                if (iHttpProxySettings.hasProxyHost()) {
                    if (iCommonsSet4.contains((Object)string2)) {
                        LOGGER.info("Not using proxy host for route to '" + string2 + "' because it is in the non-proxy host list");
                        return null;
                    }
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Using proxy host " + String.valueOf(iHttpProxySettings.getProxyHost()) + " for route to '" + string2 + "'");
                    }
                    return iHttpProxySettings.getProxyHost();
                }
                return null;
            }
        };
    }

    @Nonnull
    public HttpClientBuilder createHttpClientBuilder() {
        TlsSocketStrategy tlsSocketStrategy = this.createTlsSocketStrategy();
        if (tlsSocketStrategy == null) {
            throw new IllegalStateException("Failed to create TlsSocketStrategy");
        }
        SchemePortResolver schemePortResolver = this.createSchemePortResolver();
        HttpClientConnectionManager httpClientConnectionManager = this.createConnectionManager(tlsSocketStrategy);
        ConnectionReuseStrategy connectionReuseStrategy = this.createConnectionReuseStrategy();
        RequestConfig requestConfig = this.createRequestConfig();
        CredentialsProvider credentialsProvider = this.createCredentialsProvider();
        HttpRoutePlanner httpRoutePlanner = this.createRoutePlanner(schemePortResolver);
        HttpClientBuilder httpClientBuilder = HttpClients.custom().setSchemePortResolver(schemePortResolver).setConnectionManager(httpClientConnectionManager).setDefaultRequestConfig(requestConfig).setDefaultCredentialsProvider(credentialsProvider).setRoutePlanner(httpRoutePlanner).setConnectionReuseStrategy(connectionReuseStrategy);
        httpClientBuilder.addRequestInterceptorLast((HttpRequestInterceptor)new RequestAddCookies());
        if (this.m_aSettings.hasRetries()) {
            httpClientBuilder.setRetryStrategy(this.createRequestRetryStrategy(this.m_aSettings.getRetryCount(), this.m_aSettings.getRetryIntervalAsTimeValue(), this.m_aSettings.isRetryAlways()));
        }
        if (this.m_aSettings.hasUserAgent()) {
            httpClientBuilder.setUserAgent(this.m_aSettings.getUserAgent());
        }
        return httpClientBuilder;
    }

    @Override
    @Nonnull
    public CloseableHttpClient createHttpClient() {
        HttpClientBuilder httpClientBuilder = this.createHttpClientBuilder();
        return httpClientBuilder.build();
    }
}

