/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schematron;

import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.annotation.style.OverrideOnDemand;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.io.iface.IHasInputStream;
import com.helger.base.state.EValidity;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.io.resource.IReadableResource;
import com.helger.schematron.ISchematronResource;
import com.helger.schematron.SchematronResourceHelper;
import com.helger.schematron.svrl.jaxb.SchematronOutputType;
import com.helger.xml.EXMLParserFeature;
import com.helger.xml.sax.DefaultEntityResolver;
import com.helger.xml.serialize.read.DOMReader;
import com.helger.xml.serialize.read.DOMReaderSettings;
import com.helger.xml.serialize.read.IDOMReaderSettings;
import com.helger.xml.transform.TransformSourceFactory;
import java.io.InputStream;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.EntityResolver;

@NotThreadSafe
public abstract class AbstractSchematronResource
implements ISchematronResource {
    public static final boolean DEFAULT_USE_CACHE = true;
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractSchematronResource.class);
    private final IReadableResource m_aResource;
    private final String m_sResourceID;
    private boolean m_bUseCache = true;
    private boolean m_bLenient = false;
    private EntityResolver m_aEntityResolver;

    public AbstractSchematronResource(@NonNull IReadableResource iReadableResource) {
        this.m_aResource = (IReadableResource)ValueEnforcer.notNull((Object)iReadableResource, (String)"Resource");
        this.m_sResourceID = iReadableResource.getResourceID();
        this.m_aEntityResolver = DefaultEntityResolver.createOnDemand((IReadableResource)iReadableResource);
    }

    public final @NonNull String getID() {
        return this.m_sResourceID;
    }

    @Override
    public final @NonNull IReadableResource getResource() {
        return this.m_aResource;
    }

    @Override
    public final boolean isUseCache() {
        return this.m_bUseCache;
    }

    @Override
    public final void setUseCache(boolean bl) {
        this.m_bUseCache = bl;
    }

    @Override
    public final boolean isLenient() {
        return this.m_bLenient;
    }

    @Override
    public final void setLenient(boolean bl) {
        this.m_bLenient = bl;
    }

    @Override
    public final @Nullable EntityResolver getEntityResolver() {
        return this.m_aEntityResolver;
    }

    protected final void internalSetEntityResolver(@Nullable EntityResolver entityResolver) {
        this.m_aEntityResolver = entityResolver;
    }

    @ReturnsMutableCopy
    protected @NonNull DOMReaderSettings internalCreateDOMReaderSettings() {
        DOMReaderSettings dOMReaderSettings = new DOMReaderSettings();
        if (this.m_aEntityResolver != null) {
            dOMReaderSettings.setEntityResolver(this.m_aEntityResolver);
        }
        return dOMReaderSettings;
    }

    @OverrideOnDemand
    protected @Nullable NodeAndBaseURI getAsNode(@NonNull IHasInputStream iHasInputStream) throws Exception {
        StreamSource streamSource = TransformSourceFactory.create((IHasInputStream)iHasInputStream);
        InputStream inputStream = null;
        try {
            inputStream = streamSource.getInputStream();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        if (inputStream == null) {
            LOGGER.warn("XML resource " + String.valueOf(iHasInputStream) + " does not exist!");
            return null;
        }
        Document document = DOMReader.readXMLDOM((InputStream)inputStream, (IDOMReaderSettings)this.internalCreateDOMReaderSettings());
        if (document == null) {
            throw new IllegalArgumentException("Failed to read resource " + String.valueOf(iHasInputStream) + " as XML");
        }
        LOGGER.info("Read XML resource " + String.valueOf(iHasInputStream));
        return new NodeAndBaseURI(document, streamSource.getSystemId());
    }

    @OverrideOnDemand
    protected @Nullable Node getAsNode(@NonNull Source source) throws Exception {
        DOMReaderSettings dOMReaderSettings = this.internalCreateDOMReaderSettings();
        dOMReaderSettings.setFeatureValue(EXMLParserFeature.DISALLOW_DOCTYPE_DECL, false);
        return SchematronResourceHelper.getNodeOfSource(source, dOMReaderSettings);
    }

    @Override
    public @NonNull EValidity getSchematronValidity(@NonNull IHasInputStream iHasInputStream) throws Exception {
        NodeAndBaseURI nodeAndBaseURI = this.getAsNode(iHasInputStream);
        if (nodeAndBaseURI == null) {
            return EValidity.INVALID;
        }
        return this.getSchematronValidity(nodeAndBaseURI.m_aDoc, nodeAndBaseURI.m_sBaseURI);
    }

    @Override
    public @NonNull EValidity getSchematronValidity(@NonNull Source source) throws Exception {
        Node node = this.getAsNode(source);
        if (node == null) {
            return EValidity.INVALID;
        }
        return this.getSchematronValidity(node, source.getSystemId());
    }

    @Override
    public @Nullable Document applySchematronValidation(@NonNull IHasInputStream iHasInputStream) throws Exception {
        NodeAndBaseURI nodeAndBaseURI = this.getAsNode(iHasInputStream);
        if (nodeAndBaseURI == null) {
            return null;
        }
        return this.applySchematronValidation(nodeAndBaseURI.m_aDoc, nodeAndBaseURI.m_sBaseURI);
    }

    @Override
    public @Nullable Document applySchematronValidation(@NonNull Source source) throws Exception {
        Node node = this.getAsNode(source);
        if (node == null) {
            return null;
        }
        return this.applySchematronValidation(node, source.getSystemId());
    }

    @Override
    public @Nullable SchematronOutputType applySchematronValidationToSVRL(@NonNull IHasInputStream iHasInputStream) throws Exception {
        NodeAndBaseURI nodeAndBaseURI = this.getAsNode(iHasInputStream);
        if (nodeAndBaseURI == null) {
            return null;
        }
        return this.applySchematronValidationToSVRL(nodeAndBaseURI.m_aDoc, nodeAndBaseURI.m_sBaseURI);
    }

    @Override
    public @Nullable SchematronOutputType applySchematronValidationToSVRL(@NonNull Source source) throws Exception {
        Node node = this.getAsNode(source);
        if (node == null) {
            return null;
        }
        return this.applySchematronValidationToSVRL(node, source.getSystemId());
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("Resource", (Object)this.m_aResource).append("ResourceID", (Object)this.m_sResourceID).append("UseCache", this.m_bUseCache).append("Lenient", this.m_bLenient).appendIfNotNull("EntityResolver", (Object)this.m_aEntityResolver).getToString();
    }

    protected static final class NodeAndBaseURI {
        private final Document m_aDoc;
        private final String m_sBaseURI;

        public NodeAndBaseURI(@NonNull Document document, @Nullable String string) {
            this.m_aDoc = document;
            this.m_sBaseURI = string;
        }
    }
}

