/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schedule.quartz.listener;

import com.helger.annotation.Nonempty;
import com.helger.base.lang.clazz.ClassHelper;
import com.helger.quartz.IJobExecutionContext;
import com.helger.quartz.IJobListener;
import com.helger.quartz.JobExecutionException;
import com.helger.statistics.impl.StatisticsManager;
import jakarta.annotation.Nonnull;

public class StatisticsJobListener
implements IJobListener {
    @Nonnull
    @Nonempty
    public String getName() {
        return "StatisticsJobListener";
    }

    @Nonnull
    @Nonempty
    protected String getStatisticsName(@Nonnull IJobExecutionContext iJobExecutionContext) {
        return "quartz." + ClassHelper.getClassLocalName((Class)iJobExecutionContext.getJobDetail().getJobClass());
    }

    public void jobToBeExecuted(@Nonnull IJobExecutionContext iJobExecutionContext) {
    }

    public void jobExecutionVetoed(@Nonnull IJobExecutionContext iJobExecutionContext) {
        StatisticsManager.getCounterHandler((String)(this.getStatisticsName(iJobExecutionContext) + "$VETOED")).increment();
    }

    public void jobWasExecuted(@Nonnull IJobExecutionContext iJobExecutionContext, JobExecutionException jobExecutionException) {
        StatisticsManager.getCounterHandler((String)(this.getStatisticsName(iJobExecutionContext) + "$EXEC")).increment();
        if (jobExecutionException != null) {
            StatisticsManager.getCounterHandler((String)(this.getStatisticsName(iJobExecutionContext) + "$ERROR")).increment();
        }
    }
}

