/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schedule.quartz;

import com.helger.annotation.concurrent.Immutable;
import com.helger.quartz.IScheduler;
import com.helger.quartz.ISchedulerFactory;
import com.helger.quartz.SchedulerException;
import com.helger.quartz.SchedulerMetaData;
import com.helger.quartz.impl.StdSchedulerFactory;
import com.helger.schedule.quartz.ESchedulerState;
import jakarta.annotation.Nonnull;

@Immutable
public final class QuartzSchedulerHelper {
    public static final boolean DEFAULT_START_AUTOMATICALLY = true;
    private static final ISchedulerFactory SCHEDULER_FACTORY = new StdSchedulerFactory();

    private QuartzSchedulerHelper() {
    }

    @Nonnull
    public static ISchedulerFactory getSchedulerFactory() {
        return SCHEDULER_FACTORY;
    }

    @Nonnull
    public static IScheduler getScheduler() {
        return QuartzSchedulerHelper.getScheduler(true);
    }

    @Nonnull
    public static IScheduler getScheduler(boolean bl) {
        try {
            IScheduler iScheduler = SCHEDULER_FACTORY.getScheduler();
            if (bl && !iScheduler.isStarted()) {
                iScheduler.start();
            }
            return iScheduler;
        }
        catch (SchedulerException schedulerException) {
            throw new IllegalStateException("Failed to create" + (bl ? " and start" : "") + " scheduler!", schedulerException);
        }
    }

    @Nonnull
    public static SchedulerMetaData getSchedulerMetaData() {
        try {
            return SCHEDULER_FACTORY.getScheduler().getMetaData();
        }
        catch (SchedulerException schedulerException) {
            throw new IllegalStateException("Failed to get scheduler metadata", schedulerException);
        }
    }

    @Nonnull
    public static ESchedulerState getSchedulerState() {
        try {
            IScheduler iScheduler = SCHEDULER_FACTORY.getScheduler();
            if (iScheduler.isStarted()) {
                return ESchedulerState.STARTED;
            }
            if (iScheduler.isInStandbyMode()) {
                return ESchedulerState.STANDBY;
            }
            if (iScheduler.isShutdown()) {
                return ESchedulerState.SHUTDOWN;
            }
            throw new IllegalStateException("Unknown scheduler state: " + iScheduler.toString());
        }
        catch (SchedulerException schedulerException) {
            throw new IllegalStateException("Error retrieving scheduler state!", schedulerException);
        }
    }
}

